/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.lock.redisson.annotation;

import com.xforceplus.lock.redisson.RedissonLock;
import com.xforceplus.lock.redisson.annotation.DistributedLock;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Aspect
@Component
@ConditionalOnProperty(name={"redisson.plugins.enable"}, matchIfMissing=true)
public class DistributedLockHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributedLockHandler.class);
    @Autowired
    RedissonLock redissonLock;

    @Pointcut(value="@annotation(com.xforceplus.lock.redisson.annotation.DistributedLock)")
    public void distributedLock() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(distributedLock)")
    public void around(ProceedingJoinPoint joinPoint, DistributedLock distributedLock) {
        LOGGER.info("[\u5f00\u59cb]\u6267\u884cRedisLock\u73af\u7ed5\u901a\u77e5,\u83b7\u53d6Redis\u5206\u5e03\u5f0f\u9501\u5f00\u59cb");
        String lockName = distributedLock.value();
        int expireSeconds = distributedLock.expireSeconds();
        if (this.redissonLock.lock(lockName, expireSeconds)) {
            try {
                LOGGER.info("\u83b7\u53d6Redis\u5206\u5e03\u5f0f\u9501[\u6210\u529f]\uff0c\u52a0\u9501\u5b8c\u6210\uff0c\u5f00\u59cb\u6267\u884c\u4e1a\u52a1\u903b\u8f91...");
                joinPoint.proceed();
            }
            catch (Throwable var9) {
                LOGGER.error("\u83b7\u53d6Redis\u5206\u5e03\u5f0f\u9501[\u5f02\u5e38]\uff0c\u52a0\u9501\u5931\u8d25", var9);
                var9.printStackTrace();
            }
            finally {
                this.redissonLock.release(lockName);
            }
            LOGGER.info("\u91ca\u653eRedis\u5206\u5e03\u5f0f\u9501[\u6210\u529f]\uff0c\u89e3\u9501\u5b8c\u6210\uff0c\u7ed3\u675f\u4e1a\u52a1\u903b\u8f91...");
        } else {
            LOGGER.error("\u83b7\u53d6Redis\u5206\u5e03\u5f0f\u9501[\u5931\u8d25]");
        }
        LOGGER.info("[\u7ed3\u675f]\u6267\u884cRedisLock\u73af\u7ed5\u901a\u77e5");
    }
}

