/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.proxy;

import com.gargoylesoftware.htmlunit.WebClient;
import com.xforceplus.lock.redisson.RedissonLock;
import com.xforceplus.proxy.ProxyIpFactory;
import com.xforceplus.utils.FileUtil;
import java.util.Map;

public abstract class AbstractProxyConfigHandler {
    final String VALIDTOTAL_KEY = "job:ipproxy:valid_total";
    final String REQUESTTOTAL_KEY = "job:ipproxy:request_total";
    static final String PROXYCONFIGMAP_KEY = "job:ipproxy:map_cache:";
    final String CONCURRENCY_KEY = "job:ipproxy:concurrency";
    final String VALIDTOTAL_KEY_KUAI = "job:ipproxy:valid_total_kuai";
    final String REQUESTTOTAL_KEY_KUAI = "job:ipproxy:request_total_kuai";
    final String CONCURRENCY_KEY_KUAI = "job:ipproxy:concurrency_kuai";
    protected AbstractProxyConfigHandler next;
    protected RedissonLock redissonLock;

    public void next(AbstractProxyConfigHandler next) {
        this.next = next;
    }

    public AbstractProxyConfigHandler(RedissonLock redissonLock) {
        this.redissonLock = redissonLock;
    }

    public abstract Map<String, String> doHandler(WebClient var1, String var2);

    public abstract Map<String, Map<String, String>> setProxyConfig(WebClient var1, String var2) throws Exception;

    public void saveFileLog(String appendLogPattern, Object ... appendLogArguments) {
        FileUtil.saveFileLog("/ipproxy/", appendLogPattern, appendLogArguments);
    }

    public boolean validateProxy(String proxyIp, String proxyPort) {
        return ProxyIpFactory.validateProxy(proxyIp, proxyPort, "");
    }

    public static class Builder {
        private AbstractProxyConfigHandler head;
        private AbstractProxyConfigHandler tail;

        public Builder addHandler(AbstractProxyConfigHandler handler) {
            if (this.head == null) {
                this.head = this.tail = handler;
                return this;
            }
            this.tail.next(handler);
            this.tail = handler;
            return this;
        }

        public AbstractProxyConfigHandler build() {
            return this.head;
        }
    }
}

