/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.proxy;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ProxyConfig;
import com.gargoylesoftware.htmlunit.WebClient;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.core.enums.IntConstant;
import com.xforceplus.core.notice.ExceptionDdNoticer;
import com.xforceplus.janus.config.core.util.JanusHttpUtil;
import com.xforceplus.lock.redisson.RedissonLock;
import com.xforceplus.proxy.ALIYUNProxyConfigHandler;
import com.xforceplus.proxy.AbstractProxyConfigHandler;
import com.xforceplus.proxy.IpPoolProxyConfigHandler;
import com.xforceplus.proxy.IpTracker;
import com.xforceplus.proxy.JGProxyConfigHandler;
import com.xforceplus.proxy.KuaiProxyConfigHandler;
import com.xforceplus.proxy.TencentFirstProxyConfigHandler;
import com.xforceplus.proxy.TencentSecondProxyConfigHandler;
import com.xforceplus.proxy.domain.IpBaseResponse;
import com.xforceplus.proxy.domain.IpResponse;
import com.xforceplus.utils.BaseUtils;
import com.xforceplus.utils.JsonUtils;
import com.xforceplus.utils.WebClientUtil;
import com.xxl.job.core.log.XxlJobLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RBucket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyIpFactory {
    private static final Logger log = LoggerFactory.getLogger(ProxyIpFactory.class);
    private static final RedissonLock redissonLock = null;
    static final String PROXY_IP_LOCK_KEY = "job:ipproxy:lockkey";
    private static Cache<String, IpResponse> cache = CacheBuilder.newBuilder().maximumSize(2000L).expireAfterWrite(15L, TimeUnit.MINUTES).build();

    public static Map<String, String> getIpProxy(WebClient webClient, AccountTemplateDO account) {
        return ProxyIpFactory.getIpProxyProcess(webClient, 1, account);
    }

    private static Map<String, String> getIpProxyLocked(WebClient webClient, int times, AccountTemplateDO account) {
        if (times == 10) {
            throw new RuntimeException("\u83b7\u53d6\u4ee3\u740610\u6b21\u4f9d\u7136\u83b7\u53d6\u5931\u8d25,\u9000\u51fa...");
        }
        XxlJobLogger.log((String)"\u7b2c{}\u6b21\u83b7\u53d6\u4ee3\u7406IP...", (Object[])new Object[]{times});
        boolean lock = redissonLock.lock(PROXY_IP_LOCK_KEY, IntConstant.SIXTY);
        String accountKey = account.getAccountId();
        if (lock) {
            XxlJobLogger.log((String)"\u52a0\u9501\u6210\u529f,\u5148\u83b7\u53d6\u7f13\u5b58\u4ee3\u7406IP...", (Object[])new Object[0]);
            Map<String, String> proxyConfig = ProxyIpFactory.getProxy(accountKey);
            if (proxyConfig != null) {
                redissonLock.release(PROXY_IP_LOCK_KEY);
                return proxyConfig;
            }
            AbstractProxyConfigHandler.Builder builder = new AbstractProxyConfigHandler.Builder();
            builder.addHandler(new KuaiProxyConfigHandler(redissonLock)).addHandler(new JGProxyConfigHandler(redissonLock)).addHandler(new ALIYUNProxyConfigHandler(redissonLock)).addHandler(new TencentFirstProxyConfigHandler(redissonLock)).addHandler(new TencentSecondProxyConfigHandler(redissonLock));
            proxyConfig = builder.build().doHandler(webClient, accountKey);
            redissonLock.release(PROXY_IP_LOCK_KEY);
            if (proxyConfig == null || proxyConfig.isEmpty()) {
                throw new RuntimeException("\u83b7\u53d6\u4ee3\u7406\u5931\u8d25..");
            }
            IpPoolProxyConfigHandler.addIpPoolProxy(proxyConfig);
            String proxyIp = proxyConfig.get("proxyIp");
            String proxyPort = proxyConfig.get("proxyPort");
            IpTracker.getInstance().addOrUpdateIp(account.getAccountId(), proxyIp + "," + proxyPort);
            return proxyConfig;
        }
        XxlJobLogger.log((String)"\u83b7\u53d6\u4ee3\u7406IP\u9501\u88ab\u5360\u7528,\u4f11\u77205s...", (Object[])new Object[0]);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        XxlJobLogger.log((String)"\u91cd\u65b0\u83b7\u53d6IP\u4ee3\u7406...", (Object[])new Object[0]);
        return ProxyIpFactory.getIpProxyProcess(webClient, ++times, account);
    }

    public static Map<String, String> getIpProxyProcess(WebClient webClient, int times, AccountTemplateDO account) {
        Map<String, String> proxyConfig = ProxyIpFactory.getProxy(account.getAccountId());
        if (proxyConfig != null) {
            String proxyIp = proxyConfig.get("proxyIp");
            String proxyPort = proxyConfig.get("proxyPort");
            IpTracker.getInstance().addOrUpdateIp(account.getAccountId(), proxyIp + "," + proxyPort);
            return proxyConfig;
        }
        proxyConfig = IpPoolProxyConfigHandler.getProxy(account.getAccountId());
        if (proxyConfig != null) {
            return proxyConfig;
        }
        return ProxyIpFactory.getIpProxyLocked(webClient, times, account);
    }

    public static Map<String, String> getProxy(String accountKey) {
        String proxyPort;
        String proxyIp;
        boolean validCheck;
        Map proxyConfig;
        RBucket proxyConfigRBucket = redissonLock.getRedissonManager().getRedisson().getBucket("job:ipproxy:map_cache:" + accountKey);
        Map proxyConfigMap = (Map)proxyConfigRBucket.get();
        if (proxyConfigMap != null && (proxyConfig = (Map)proxyConfigMap.get("proxyConfig")) != null && !proxyConfig.isEmpty() && (validCheck = ProxyIpFactory.validateProxy(proxyIp = (String)proxyConfig.get("proxyIp"), proxyPort = (String)proxyConfig.get("proxyPort"), ""))) {
            XxlJobLogger.log((String)"\u7f13\u5b58\u4ee3\u7406IP\u3010{}:{}\u3011\u6709\u6548\uff01", (Object[])new Object[]{proxyIp, proxyPort});
            return proxyConfig;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validateProxy(String proxyIp, String proxyPort, String basicProxy) {
        WebClient webClient_tmp = WebClientUtil.getWebClient("");
        webClient_tmp.getOptions().setTimeout(3000);
        webClient_tmp.addRequestHeader("Cache-Control", "max-age=0,no-store");
        webClient_tmp.addRequestHeader("Pragma", "no-cache");
        if (StringUtils.isNotBlank((CharSequence)proxyIp) && StringUtils.isNotBlank((CharSequence)proxyPort)) {
            webClient_tmp.getOptions().setProxyConfig(new ProxyConfig(proxyIp, Integer.parseInt(proxyPort)));
            try {
                Page testProxyPage;
                String htmlString;
                if (StringUtils.isNotBlank((CharSequence)basicProxy)) {
                    webClient_tmp.addRequestHeader("Proxy-Authorization", basicProxy);
                }
                if ((htmlString = (testProxyPage = webClient_tmp.getPage("http://checkip-kjw.powere2e.com/?v=" + System.currentTimeMillis())).getWebResponse().getContentAsString()).contains("ok")) {
                    XxlJobLogger.log((String)"\u5b9d\u5c71IDC\u673a\u623f\u8bf7\u6c42\uff0c\u4ee3\u7406IP\u3010{}:{}\u3011\u6709\u6548\uff01", (Object[])new Object[]{proxyIp, proxyPort});
                    boolean bl = true;
                    return bl;
                }
                XxlJobLogger.log((String)"\u5b9d\u5c71IDC\u673a\u623f\u8bf7\u6c42\u5931\u8d25{}:{}", (Object[])new Object[]{proxyIp, proxyPort});
                testProxyPage = null;
                htmlString = null;
                testProxyPage = webClient_tmp.getPage("https://baidu.com/?v=" + System.currentTimeMillis());
                htmlString = testProxyPage.getWebResponse().getContentAsString();
                if (htmlString.contains("submit")) {
                    XxlJobLogger.log((String)"\u767e\u5ea6\u641c\u7d22\u8bf7\u6c42\uff0c\u4ee3\u7406IP\u3010{}:{}\u3011\u6709\u6548\uff01", (Object[])new Object[]{proxyIp, proxyPort});
                    boolean bl = true;
                    return bl;
                }
                XxlJobLogger.log((String)"\u767e\u5ea6\u641c\u7d22\u8bf7\u6c42\u5931\u8d25{}:{}", (Object[])new Object[]{proxyIp, proxyPort});
            }
            catch (Exception e) {
                XxlJobLogger.log((String)"\u4ee3\u7406IP\u3010{}:{}\u3011\u6709\u6548\u6027\u68c0\u67e5\u5f02\u5e38\uff01msg={}", (Object[])new Object[]{proxyIp, proxyPort, e.getMessage()});
                boolean bl = false;
                return bl;
            }
            finally {
                webClient_tmp.close();
            }
        }
        webClient_tmp.close();
        return false;
    }

    public static Map<String, String> getIpProxy(String accountKey) {
        RBucket proxyConfigRBucket = redissonLock.getRedissonManager().getRedisson().getBucket("job:ipproxy:map_cache:" + accountKey);
        Map proxyConfigMap = (Map)proxyConfigRBucket.get();
        if (proxyConfigMap != null) {
            return (Map)proxyConfigMap.get("proxyConfig");
        }
        return null;
    }

    public static IpResponse getRemoteIpProxy(String accountKey, String area) {
        boolean flag;
        IpResponse ipResponse = (IpResponse)cache.getIfPresent((Object)accountKey);
        if (null != ipResponse && (flag = ProxyIpFactory.validateProxy(ipResponse.getIp(), ipResponse.getPort(), ipResponse.getBasicProxy()))) {
            return ipResponse;
        }
        if (StringUtils.isBlank((CharSequence)BaseUtils.JANUS_TOKEN) || StringUtils.isBlank((CharSequence)BaseUtils.JANUS_URL) || StringUtils.isBlank((CharSequence)BaseUtils.IP_PROXY_ACTION)) {
            throw new RuntimeException("ip\u4ee3\u7406\u914d\u7f6e\u5f02\u5e38");
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("authentication", BaseUtils.JANUS_TOKEN);
        header.put("serialNo", accountKey);
        header.put("accountKey", accountKey);
        header.put("action", BaseUtils.IP_PROXY_ACTION);
        try {
            for (int i = 0; i < 5; ++i) {
                boolean flag2;
                IpBaseResponse ipBaseResponse;
                JanusHttpUtil.ResponseCus responseCus;
                HashMap<String, String> params = new HashMap<String, String>();
                if (i > 0) {
                    params.put("retry", "true");
                }
                if (StringUtils.isNotBlank((CharSequence)area)) {
                    params.put("area", area);
                }
                if (null != (responseCus = JanusHttpUtil.doGetEntire((String)BaseUtils.JANUS_URL, params, (boolean)false, header)) && Objects.equals(responseCus.getStatus(), 200) && StringUtils.isNotBlank((CharSequence)responseCus.getBody()) && null != (ipBaseResponse = JsonUtils.toBean(responseCus.getBody(), IpBaseResponse.class)) && Objects.equals(ipBaseResponse.getCode(), "200") && null != ipBaseResponse.getResult() && (flag2 = ProxyIpFactory.validateProxy((ipResponse = ipBaseResponse.getResult()).getIp(), ipResponse.getPort(), ipResponse.getBasicProxy()))) {
                    cache.put((Object)accountKey, (Object)ipResponse);
                    return ipResponse;
                }
                Thread.sleep(3000L);
            }
        }
        catch (Exception e) {
            ExceptionDdNoticer.loggerError(log, ErrorUtil.getStackMsg((Exception)e));
        }
        XxlJobLogger.log((String)("\u672a\u83b7\u53d6\u5230\u6709\u6548\u5230\u4ee3\u7406IP,\u8d26\u53f7\u6807\u8bc6:" + accountKey), (Object[])new Object[0]);
        return null;
    }

    public static void main(String[] args) {
        boolean b = ProxyIpFactory.validateProxy("49.67.128.176", "17835", "");
        boolean b1 = ProxyIpFactory.validateProxy("49.67.128.176", "17835", "");
        System.out.println(b);
        System.out.println(b1);
    }
}

