/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.service.account;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.core.exception.RemoteCallException;
import com.xforceplus.service.ultraman.ConditionField;
import com.xforceplus.service.ultraman.QueryResponse;
import com.xforceplus.utils.AesUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;

@Service
public class AccountService {
    private static final Logger log = LoggerFactory.getLogger(AccountService.class);
    @Value(value="${user.center.requestUrl}")
    private String url;
    @Value(value="${dcs.common.account.aesKey}")
    private String aesKey;

    @Retryable(value={Throwable.class}, maxAttempts=5, backoff=@Backoff(delay=2000L))
    public AccountTemplateDO queryAccount(String accountId, JSONObject extra) {
        HashMap<String, Serializable> request = new HashMap<String, Serializable>(8);
        request.put("pageNo", Integer.valueOf(1));
        request.put("pageSize", Integer.valueOf(1));
        HashMap<String, List<ConditionField>> conditionMap = new HashMap<String, List<ConditionField>>(2);
        conditionMap.put("fields", Arrays.asList(new ConditionField("pSysAccountNo", "eq", accountId)));
        request.put("conditions", conditionMap);
        HttpResponse httpResponse = ((HttpRequestWithBody)Unirest.post((String)(this.url + "/api/unified-bill-pool/bos/1808389741298176001/entities/query")).header("Content-Type", "application/json")).body(request).asObject(QueryAccountResponse.class);
        if (!httpResponse.isSuccess()) {
            throw new RemoteCallException("\u67e5\u8be2\u8d26\u53f7\u5931\u8d25! " + httpResponse.getStatusText());
        }
        String okCode = "1";
        QueryAccountResponse response = (QueryAccountResponse)httpResponse.getBody();
        if (!okCode.equals(response.getCode())) {
            throw new RemoteCallException(response.getMessage());
        }
        if (response.getResult() == null || CollectionUtils.isEmpty(response.getResult().getRows())) {
            return null;
        }
        JSONObject accountJson = (JSONObject)response.getResult().getRows().get(0);
        AccountTemplateDO account = new AccountTemplateDO();
        JSONObject jobExtraInfo = accountJson.getJSONObject("jobExtraInfo");
        if (jobExtraInfo == null) {
            jobExtraInfo = new JSONObject();
        }
        jobExtraInfo.putAll((Map)extra);
        account = (AccountTemplateDO)jobExtraInfo.to(AccountTemplateDO.class, new JSONReader.Feature[0]);
        account.setAccountId(accountId);
        account.setAccountName(accountJson.getString("collectionAccount"));
        account.setAccountPassword(this.getPassword(accountJson.getString("accountSecretKey")));
        account.setRetailKey(accountJson.getString("purchaseRetailerId"));
        account.setRetail(accountJson.getString("purchaseRetailerName"));
        account.setTenantId(accountJson.getLong("belongTenant"));
        account.setProject(accountJson.getString("belongTenantCode"));
        account.setProjectKey(accountJson.getString("belongTenantCode"));
        account.setDragValidityDateStart(new Date(accountJson.getLong("effectiveDateFrom")));
        account.setDragValidityDateEnd(new Date(accountJson.getLong("effectiveDateTo")));
        return account;
    }

    public void tryReportSuccess(String accountId) {
        try {
            this.reportStatus(accountId, true, "");
        }
        catch (Exception ex) {
            log.error("\u4e0a\u62a5\u8d26\u53f7\u72b6\u6001\u5f02\u5e38 {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    public void tryReportError(String accountId, String errorMsg) {
        try {
            this.reportStatus(accountId, false, errorMsg);
        }
        catch (Exception ex) {
            log.error("\u4e0a\u62a5\u8d26\u53f7\u72b6\u6001\u5f02\u5e38 {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    public void reportStatus(String accountId, boolean success, String errorMsg) {
        ReportRequest body = new ReportRequest(accountId, success, errorMsg);
        HttpResponse httpResponse = ((HttpRequestWithBody)Unirest.post((String)(this.url + "/api/unified-bill-pool/account/action/report-status")).header("Content-Type", "application/json")).body((Object)body).asString();
        log.debug("request user center status = {}, body = {}", (Object)httpResponse.getStatus(), httpResponse.getBody());
        if (!httpResponse.isSuccess()) {
            throw new RemoteCallException("\u4e0a\u62a5\u8d26\u53f7\u72b6\u6001\u5931\u8d25! " + httpResponse.getStatusText());
        }
    }

    private String getPassword(String encrypted) {
        if (StringUtils.isBlank((CharSequence)encrypted)) {
            throw new RuntimeException("\u8d26\u53f7\u5bc6\u7801\u4e3a\u7a7a");
        }
        try {
            return AesUtil.aesDecrypt(encrypted, this.aesKey);
        }
        catch (Exception ex) {
            throw new RuntimeException("\u8d26\u53f7\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25 " + ex.getMessage());
        }
    }

    private static class QueryAccountResponse
    extends QueryResponse<JSONObject> {
        private QueryAccountResponse() {
        }
    }

    private static class ReportRequest {
        private String channel = "DCS";
        private String accountNo;
        private Integer successFlag;
        private String abnormalInfo;

        public ReportRequest(String accountNo, boolean success, String errorMsg) {
            this.accountNo = accountNo;
            this.successFlag = success ? 1 : 0;
            this.abnormalInfo = errorMsg;
        }

        public String getChannel() {
            return this.channel;
        }

        public String getAccountNo() {
            return this.accountNo;
        }

        public Integer getSuccessFlag() {
            return this.successFlag;
        }

        public String getAbnormalInfo() {
            return this.abnormalInfo;
        }

        public void setChannel(String channel) {
            this.channel = channel;
        }

        public void setAccountNo(String accountNo) {
            this.accountNo = accountNo;
        }

        public void setSuccessFlag(Integer successFlag) {
            this.successFlag = successFlag;
        }

        public void setAbnormalInfo(String abnormalInfo) {
            this.abnormalInfo = abnormalInfo;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportRequest)) {
                return false;
            }
            ReportRequest other = (ReportRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$channel = this.getChannel();
            String other$channel = other.getChannel();
            if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
                return false;
            }
            String this$accountNo = this.getAccountNo();
            String other$accountNo = other.getAccountNo();
            if (this$accountNo == null ? other$accountNo != null : !this$accountNo.equals(other$accountNo)) {
                return false;
            }
            Integer this$successFlag = this.getSuccessFlag();
            Integer other$successFlag = other.getSuccessFlag();
            if (this$successFlag == null ? other$successFlag != null : !((Object)this$successFlag).equals(other$successFlag)) {
                return false;
            }
            String this$abnormalInfo = this.getAbnormalInfo();
            String other$abnormalInfo = other.getAbnormalInfo();
            return !(this$abnormalInfo == null ? other$abnormalInfo != null : !this$abnormalInfo.equals(other$abnormalInfo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReportRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
            String $accountNo = this.getAccountNo();
            result = result * 59 + ($accountNo == null ? 43 : $accountNo.hashCode());
            Integer $successFlag = this.getSuccessFlag();
            result = result * 59 + ($successFlag == null ? 43 : ((Object)$successFlag).hashCode());
            String $abnormalInfo = this.getAbnormalInfo();
            result = result * 59 + ($abnormalInfo == null ? 43 : $abnormalInfo.hashCode());
            return result;
        }

        public String toString() {
            return "AccountService.ReportRequest(channel=" + this.getChannel() + ", accountNo=" + this.getAccountNo() + ", successFlag=" + this.getSuccessFlag() + ", abnormalInfo=" + this.getAbnormalInfo() + ")";
        }
    }
}

