/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Sha256Utils {
    public static String getSignCommon(Map<String, Object> map, List<String> removeKeyList) {
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        params.putAll(map);
        if (removeKeyList == null) {
            removeKeyList = new ArrayList<String>();
        }
        StringBuilder sb = new StringBuilder();
        String resultStr = "";
        for (String key : params.keySet()) {
            if (removeKeyList.contains(key)) continue;
            String format = null;
            format = String.format("%s=%s&", key, params.get(key));
            sb.append(format);
        }
        StringBuilder delete = sb.delete(sb.length() - 1, sb.length());
        String string = delete.toString();
        resultStr = Sha256Utils.getSHA256(string);
        return resultStr;
    }

    public static String getSHA256(String str) {
        String encodestr = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes("UTF-8"));
            encodestr = Sha256Utils.byte2Hex(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encodestr;
    }

    private static String byte2Hex(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer();
        String temp = null;
        for (int i = 0; i < bytes.length; ++i) {
            temp = Integer.toHexString(bytes[i] & 0xFF);
            if (temp.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(temp);
        }
        return stringBuffer.toString();
    }
}

