/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils.logincheck;

import com.alibaba.fastjson.annotation.JSONField;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.core.config.MessageDO;
import com.xforceplus.core.enums.RetailConstantEnum;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class LoginCheck
extends MessageDO
implements Serializable {
    private String belongKa;
    private String retailerId;
    private String retailerName;
    private String regionCode;
    private String supplierCode;
    private String siteUrl;
    private String accountPassword;
    private Integer loginNo;
    @JSONField(format="yyyy-MM-dd HH:mm:ssSSS")
    private Date loginStartDate;
    @JSONField(format="yyyy-MM-dd HH:mm:ssSSS")
    private Date loginEndDate;
    private BigDecimal loginCost;
    private String loginStatus;
    private String msg;
    private String detailMsg;
    private String loginClass;

    public String getDetailMsg() {
        return this.detailMsg;
    }

    public void setDetailMsg(String detailMsg) {
        this.detailMsg = detailMsg;
    }

    public void setDetailMsg(Exception e) {
        if (e != null) {
            this.detailMsg = ExceptionUtils.getStackTrace((Throwable)e);
        }
    }

    public LoginCheck() {
    }

    public LoginCheck(AccountTemplateDO account, Map<String, String> contextMap) {
        this.belongKa = account.getProjectKey();
        super.setProjectKey(account.getProjectKey());
        super.setRetailKey(account.getRetailKey());
        this.retailerId = account.getRetailKey();
        this.retailerName = RetailConstantEnum.geLabelByKey(super.getRetailKey());
        this.regionCode = account.getArea();
        this.supplierCode = account.getSupplierCode();
        this.siteUrl = contextMap.get("protocolName") + account.getSiteUrl();
        super.setAccountName(account.getAccountName());
        this.accountPassword = account.getAccountPassword();
    }

    public String getBelongKa() {
        return this.belongKa;
    }

    public void setBelongKa(String belongKa) {
        this.belongKa = belongKa;
    }

    public String getRetailerId() {
        return this.retailerId;
    }

    public void setRetailerId(String retailerId) {
        this.retailerId = retailerId;
    }

    public String getRetailerName() {
        return this.retailerName;
    }

    public void setRetailerName(String retailerName) {
        this.retailerName = retailerName;
    }

    public String getRegionCode() {
        return this.regionCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    public String getSupplierCode() {
        return this.supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    public String getSiteUrl() {
        return this.siteUrl;
    }

    public void setSiteUrl(String siteUrl) {
        this.siteUrl = siteUrl;
    }

    public String getAccountPassword() {
        return this.accountPassword;
    }

    public void setAccountPassword(String accountPassword) {
        this.accountPassword = accountPassword;
    }

    public Integer getLoginNo() {
        return this.loginNo;
    }

    public void setLoginNo(Integer loginNo) {
        this.loginNo = loginNo;
    }

    public Date getLoginStartDate() {
        return this.loginStartDate;
    }

    public void setLoginStartDate(Date loginStartDate) {
        this.loginStartDate = loginStartDate;
    }

    public Date getLoginEndDate() {
        return this.loginEndDate;
    }

    public void setLoginEndDate(Date loginEndDate) {
        this.loginEndDate = loginEndDate;
    }

    public BigDecimal getLoginCost() {
        BigDecimal loginCost = null;
        try {
            loginCost = BigDecimal.valueOf(this.loginEndDate.getTime() - this.loginStartDate.getTime()).divide(BigDecimal.valueOf(1000L), 3, 4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return loginCost;
    }

    public void setLoginCost(BigDecimal loginCost) {
        this.loginCost = loginCost;
    }

    public String getLoginStatus() {
        return this.loginStatus;
    }

    public void setLoginStatus(String loginStatus) {
        this.loginStatus = loginStatus;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getLoginClass() {
        return this.loginClass;
    }

    public void setLoginClass(String loginClass) {
        this.loginClass = loginClass;
    }
}

