/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.gargoylesoftware.htmlunit.Page;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class BatchNumberUtils {
    private static final String E2E_KEY = "e2e_key";
    private static final String START = "[@BH_NO_";
    private static final String END = "]";
    private static final String REGEX = "[.*]*\\[@BH_NO_([\\d]{19})\\][.*]*";
    private static final String EMPTY_STR = "";
    private static final Pattern PATTERN = Pattern.compile("[.*]*\\[@BH_NO_([\\d]{19})\\][.*]*");

    public static void assemblingBatchNumber(List<Page> pages) {
        String batchNumber = BatchNumberUtils.createBatchNumber(pages.size());
        for (Page page : pages) {
            BatchNumberUtils.assembling(page, batchNumber);
        }
    }

    private static void assembling(Page page, String batchNumber) {
        Map map = page.getWebResponse().getWebRequest().getAdditionalHeaders();
        String fileName = (String)map.get(E2E_KEY);
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = EMPTY_STR;
        }
        fileName = fileName + START + batchNumber + END;
        map.put(E2E_KEY, fileName);
        page.getWebResponse().getWebRequest().setAdditionalHeaders(map);
    }

    public static String parseBatchNumber(Map<String, Object> context) {
        String filePath = (String)context.get("fileName");
        Matcher matcher = PATTERN.matcher(filePath);
        return matcher.find() ? matcher.group(1) : null;
    }

    private static String createBatchNumber(int size) {
        Random random = new Random();
        String initId = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String randomStr = String.valueOf(random.nextInt(9));
        String sizeStr = StringUtils.leftPad((String)String.valueOf(size), (int)4, (String)"0");
        return initId + randomStr + sizeStr;
    }
}

