/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.controller;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.xforceplus.bean.JobBillTypeBean;
import com.xforceplus.controller.vo.TriggerJobRequest;
import com.xforceplus.core.annotation.DcsJobHandler;
import com.xforceplus.core.resolve.ResolveTask;
import com.xforceplus.core.resolve.TaskQueueManager;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingDeque;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"admin"})
public class AdminController {
    @Resource
    private TaskQueueManager taskQueueManager;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private ConfigurableEnvironment environment;

    @PostMapping(value={"/trigger-job"})
    public String triggerJob(@Valid @RequestBody TriggerJobRequest request) {
        Map beanMap = this.applicationContext.getBeansWithAnnotation(DcsJobHandler.class);
        for (Map.Entry entry : beanMap.entrySet()) {
            Object bean = entry.getValue();
            if (!(bean instanceof IJobHandler)) continue;
            DcsJobHandler dcsJobHandler = bean.getClass().getAnnotation(DcsJobHandler.class);
            JobHandler jobHandler = bean.getClass().getAnnotation(JobHandler.class);
            if (dcsJobHandler == null || !dcsJobHandler.billType().name().equals(request.getBillType()) && (null == jobHandler || !Objects.equals(jobHandler.value(), request.getBillType())) || !dcsJobHandler.version().equals(request.getVersion())) continue;
            try {
                ((IJobHandler)bean).execute(request.getAccount().toJSONString(new JSONWriter.Feature[0]));
                return dcsJobHandler.value();
            }
            catch (Exception ex) {
                return ex.getMessage();
            }
        }
        return "\u672a\u627e\u5230\u5bf9\u5e94Job";
    }

    @GetMapping(value={"/queue"})
    public Object getResolveQueueInfo() {
        Map<JobBillTypeBean, BlockingDeque<ResolveTask>> queueMap = this.taskQueueManager.getQueueMap();
        JSONObject result = new JSONObject();
        for (Map.Entry<JobBillTypeBean, BlockingDeque<ResolveTask>> entry : queueMap.entrySet()) {
            JSONObject obj = new JSONObject();
            obj.put((Object)"queueSize", (Object)entry.getValue().size());
            result.put((Object)String.format("%s-%s", entry.getKey().getBillType(), entry.getKey().getVersion()), (Object)obj);
        }
        return result;
    }

    @GetMapping(value={"/env"})
    public Object getEnv() {
        HashMap<String, String> envVars = new HashMap<String, String>();
        MutablePropertySources sourceList = this.environment.getPropertySources();
        for (PropertySource source : sourceList) {
            Object value;
            OriginTrackedMapPropertySource propertySource;
            if (source instanceof OriginTrackedMapPropertySource) {
                propertySource = (OriginTrackedMapPropertySource)source;
                for (String key : ((Map)propertySource.getSource()).keySet()) {
                    value = propertySource.getProperty(key);
                    if (value == null) continue;
                    envVars.put(key, value.toString());
                }
                continue;
            }
            if (!(source instanceof PropertiesPropertySource) || (propertySource = (PropertiesPropertySource)source).getName().equals("systemProperties")) continue;
            for (String key : ((Map)propertySource.getSource()).keySet()) {
                value = propertySource.getProperty(key);
                if (value == null) continue;
                envVars.put(key, value.toString());
            }
        }
        return envVars;
    }
}

