/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.lock.redisson.strategy.impl;

import com.xforceplus.lock.constant.GlobalConstant;
import com.xforceplus.lock.redisson.config.RedissonProperties;
import com.xforceplus.lock.redisson.strategy.RedissonConfigStrategy;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import org.apache.commons.lang3.StringUtils;
import org.redisson.client.codec.Codec;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class ClusterRedissonConfigStrategyImpl
implements RedissonConfigStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterRedissonConfigStrategyImpl.class);
    private String codec = "org.redisson.codec.JsonJacksonCodec";

    public String getCodec() {
        return this.codec;
    }

    public void setCodec(String codec) {
        this.codec = codec;
    }

    @Override
    public Config createRedissonConfig(RedissonProperties redissonProperties) {
        Config config = new Config();
        try {
            String address = redissonProperties.getAddress();
            String password = redissonProperties.getPassword();
            int cpuNum = redissonProperties.getCpuNum();
            int connectionMinimumIdleSize = 10;
            int idleConnectionTimeout = 10000;
            int pingTimeout = 2000;
            int connectTimeout = 60000;
            int timeout = 10000;
            int retryAttempts = 3;
            int retryInterval = 1500;
            int reconnectionTimeout = 6000;
            int failedAttempts = 3;
            int subscriptionsPerConnection = 5;
            String clientName = null;
            int subscriptionConnectionMinimumIdleSize = 1;
            int subscriptionConnectionPoolSize = 50;
            int connectionPoolSize = 1000;
            int scanInterval = 2000;
            String[] addrTokens = address.split(",");
            if (addrTokens[0].isEmpty()) {
                LOGGER.error("---------- cluster Redisson init address error!!------------");
                return config;
            }
            for (int i = 0; i < addrTokens.length; ++i) {
                config.useClusterServers().addNodeAddress(new String[]{GlobalConstant.REDIS_CONNECTION_PREFIX.getConstant_value() + addrTokens[i]});
                if (!StringUtils.isNotBlank((CharSequence)password)) continue;
                config.useClusterServers().setPassword(password);
                config.useClusterServers().setTimeout(timeout);
                config.useClusterServers().setConnectTimeout(reconnectionTimeout);
                config.useClusterServers().setMasterConnectionMinimumIdleSize(connectionMinimumIdleSize);
                config.useClusterServers().setSlaveConnectionMinimumIdleSize(connectionMinimumIdleSize);
                config.useClusterServers().setMasterConnectionPoolSize(connectionPoolSize);
                config.useClusterServers().setSlaveConnectionPoolSize(connectionPoolSize);
                config.useClusterServers().setSubscriptionConnectionMinimumIdleSize(subscriptionConnectionMinimumIdleSize);
                config.useClusterServers().setSubscriptionConnectionPoolSize(subscriptionConnectionPoolSize);
                config.useClusterServers().setSubscriptionsPerConnection(subscriptionsPerConnection);
                config.useClusterServers().setClientName(clientName);
                config.useClusterServers().setFailedSlaveCheckInterval(failedAttempts);
                config.useClusterServers().setRetryAttempts(retryAttempts);
                config.useClusterServers().setRetryInterval(retryInterval);
                config.useClusterServers().setConnectTimeout(connectTimeout);
                config.useClusterServers().setIdleConnectionTimeout(idleConnectionTimeout);
                config.useClusterServers().setPingConnectionInterval(pingTimeout);
                config.useClusterServers().setScanInterval(scanInterval);
                Codec codec = (Codec)ClassUtils.forName((String)this.getCodec(), (ClassLoader)ClassUtils.getDefaultClassLoader()).newInstance();
                config.setCodec(codec);
                config.setThreads(cpuNum);
                config.setEventLoopGroup((EventLoopGroup)new NioEventLoopGroup());
            }
            LOGGER.info("\u521d\u59cb\u5316[cluster]\u65b9\u5f0fConfig,redisAddress:" + address);
        }
        catch (Exception var24) {
            LOGGER.error("cluster Redisson init error", (Throwable)var24);
            var24.printStackTrace();
        }
        return config;
    }
}

