/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.service.handler;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.gargoylesoftware.htmlunit.WebClient;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.xforceplus.account.AbstractLoginSys;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.apollo.utils.DateFormatUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.bean.JobBillTypeBean;
import com.xforceplus.core.annotation.DcsJobHandler;
import com.xforceplus.core.annotation.JobHandlerParam;
import com.xforceplus.core.domain.CollectParam;
import com.xforceplus.core.exception.PasswordErrorException;
import com.xforceplus.core.notice.ExceptionDdNoticer;
import com.xforceplus.core.resolve.ResolveTask;
import com.xforceplus.core.resolve.TaskProducer;
import com.xforceplus.core.resolve.dto.CollectAccountDto;
import com.xforceplus.core.resolve.dto.CollectAccountResponse;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.config.core.util.JanusHttpUtil;
import com.xforceplus.lock.redisson.RedissonLock;
import com.xforceplus.service.account.AccountService;
import com.xforceplus.service.handler.CollectRecordHandler;
import com.xforceplus.service.oss.OssService;
import com.xforceplus.utils.AesUtil;
import com.xforceplus.utils.FileUtil;
import com.xforceplus.utils.RedisUtil;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;

public abstract class BaseDcsHandler
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(BaseDcsHandler.class);
    @Resource
    private AccountService accountService;
    @Resource
    private OssService ossService;
    @Resource
    private TaskProducer taskProducer;
    @Resource
    private RedissonLock redissonLock;
    @Value(value="${janus.businessKey}")
    private String businessKey;
    @Value(value="${janus.authentication}")
    private String authentication;
    @Value(value="${janus.url}")
    private String janusUrl;
    @Value(value="${janus.thread: 1}")
    private Integer threadNum;
    @Value(value="${dcs.common.account.aesKey}")
    private String aesKey;
    @Resource
    private ApplicationContext applicationContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReturnT<String> execute(String param) throws Exception {
        this.threadNum = null == this.threadNum ? 1 : this.threadNum;
        String paramStr = param.trim();
        if (paramStr.isEmpty()) {
            XxlJobLogger.log((String)"\u4f9b\u5e94\u5546(\u5ba2\u6237)\u5e73\u53f0\u7b80\u79f0\uff08\u4efb\u52a1\u53c2\u6570\uff09\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            return FAIL;
        }
        Map beanMap = this.applicationContext.getBeansWithAnnotation(DcsJobHandler.class);
        if (MapUtils.isEmpty((Map)beanMap)) {
            XxlJobLogger.log((String)"\u6ca1\u6709\u5904\u7406handlers", (Object[])new Object[0]);
            return FAIL;
        }
        ExecutorService executorService = null;
        ConcurrentHashMap resultMap = new ConcurrentHashMap();
        try {
            CollectAccountResponse accountResponse;
            DcsJobHandler dcsJobHandler = this.getDcsJobHandler();
            JobHandlerParam jobHandlerParam = this.getJobHandlerParam();
            JSONObject json = JSON.parseObject((String)paramStr);
            String accountId = json.getString("accountId");
            String projectId = json.getString("projectId");
            String collectType = json.getString("collectType");
            if (StringUtils.isNotBlank((CharSequence)collectType)) {
                json.remove((Object)"collectType");
            }
            String billType = dcsJobHandler.billType().name();
            HashMap<String, String> params = new HashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)accountId)) {
                params.put("accountId", accountId);
            }
            if (StringUtils.isNotBlank((CharSequence)projectId)) {
                params.put("projectId", projectId);
            }
            if (StringUtils.isNotBlank((CharSequence)billType) && !Objects.equals(billType.toUpperCase(), "ALL")) {
                params.put("billType", billType);
            }
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put("Authentication", HttpConfig.getConfig((String)"common.authentication"));
            headers.put("action", HttpConfig.getConfig((String)"common.account.action"));
            headers.put("serialNo", this.businessKey);
            headers.put("businessKey", this.businessKey);
            JanusHttpUtil.ResponseCus responseCus = JanusHttpUtil.doGetEntire((String)this.janusUrl, params, (boolean)false, headers);
            if (null == responseCus || !Objects.equals(responseCus.getStatus(), 200) || StringUtils.isBlank((CharSequence)responseCus.getBody())) {
                Thread.sleep(5000L);
                responseCus = JanusHttpUtil.doGetEntire((String)this.janusUrl, params, (boolean)false, headers);
                if (null == responseCus || !Objects.equals(responseCus.getStatus(), 200) || StringUtils.isBlank((CharSequence)responseCus.getBody())) {
                    XxlJobLogger.log((String)"\u83b7\u53d6\u8d26\u53f7\u5931\u8d25", (Object[])new Object[0]);
                    ReturnT returnT = FAIL;
                    return returnT;
                }
            }
            if (null == (accountResponse = (CollectAccountResponse)JacksonUtil.getInstance().fromJson(responseCus.getBody(), CollectAccountResponse.class)) || CollectionUtils.isEmpty(accountResponse.getResult())) {
                XxlJobLogger.log((String)("\u8d26\u53f7\u89e3\u6790\u5931\u8d25:" + responseCus.getBody()), (Object[])new Object[0]);
                ReturnT returnT = FAIL;
                return returnT;
            }
            List<CollectAccountDto> accounts = accountResponse.getResult();
            JobBillTypeBean jobBillType = new JobBillTypeBean(dcsJobHandler.billType(), dcsJobHandler.version());
            CountDownLatch latch = new CountDownLatch(accounts.size());
            executorService = Executors.newFixedThreadPool(this.threadNum);
            log.info("\u91c7\u96c6\u5b50\u4efb\u52a1\u603b\u6570:" + accounts.size());
            XxlJobLogger.log((String)("\u91c7\u96c6\u5b50\u4efb\u52a1\u603b\u6570:" + accounts.size()), (Object[])new Object[0]);
            for (CollectAccountDto accountDto : accounts) {
                executorService.submit(() -> {
                    block39: {
                        String flag = "true";
                        String start = DateFormatUtil.getCurrentFormatDateTime();
                        String remark = "";
                        AccountTemplateDO account = null;
                        try {
                            account = this.genAccount(accountDto, json, jobHandlerParam);
                            account.setBillsType(dcsJobHandler.billType().getKey());
                            if (StringUtils.isNotBlank((CharSequence)collectType) && !Objects.equals(collectType, account.getCollectType())) {
                                return;
                            }
                            if (!StringUtils.isNotBlank((CharSequence)account.getBillsType())) break block39;
                            boolean lock = false;
                            String key = null;
                            try {
                                int dragTime = account.getDragTime();
                                key = RedisUtil.getKey(account);
                                lock = this.redissonLock.lock(key, dragTime);
                                XxlJobLogger.log((String)"\u91c7\u96c6\u767b\u5f55\u52a0\u9501\uff0cRedissonKey={}, Status={}, lockTime={}/S.", (Object[])new Object[]{key, lock, dragTime});
                                if (lock) {
                                    HashMap contextMap = Maps.newHashMap();
                                    WebClient webClient = null;
                                    try {
                                        webClient = this.getLoginSys().doLogin(account, contextMap);
                                        if (webClient == null) {
                                            remark = "WebClient \u4e3a\u7a7a\uff0c\u767b\u5f55\u5931\u8d25\uff01";
                                            XxlJobLogger.log((String)remark, (Object[])new Object[0]);
                                            ExceptionDdNoticer.loggerError(log, "\u767b\u5f55\u5931\u8d25 \u8d26\u53f7: {}", account.getAccountName());
                                            flag = "false";
                                            return;
                                        }
                                    }
                                    catch (PasswordErrorException passwordErrorException) {
                                        remark = "\u5bc6\u7801\u9a8c\u8bc1\u5931\u8d25\uff0c\u8d26\u53f7\u9501\u5b9a\uff01";
                                        this.lockAccount(accountDto.getAccountId());
                                        XxlJobLogger.log((String)remark, (Object[])new Object[0]);
                                        flag = "false";
                                        return;
                                    }
                                    XxlJobLogger.log((String)"\u5f00\u59cb\u91c7\u96c6", (Object[])new Object[0]);
                                    List<String> filePathList = this.doCollect(webClient, account, contextMap);
                                    if (account.isBatchRenameEnable()) {
                                        FileUtil.renFile(account);
                                    }
                                    XxlJobLogger.log((String)("\u91c7\u96c6\u5b8c\u6bd5 \u6587\u4ef6\u6570\uff1a" + filePathList.size()), (Object[])new Object[0]);
                                    if (CollectionUtils.isNotEmpty(filePathList)) {
                                        for (String filePath : filePathList) {
                                            List as;
                                            if (StringUtils.isBlank((CharSequence)filePath) || !new File(filePath).exists()) continue;
                                            String url = this.ossService.uploadRawFile(filePath, account);
                                            ResolveTask resolveTask = new ResolveTask(account, jobBillType, filePath, url);
                                            if (filePath.endsWith(".pdf") && CollectionUtils.isNotEmpty((Collection)(as = Splitter.on((String)"-").splitToList((CharSequence)filePath)))) {
                                                String orderNo = (String)as.get(as.size() - 1);
                                                orderNo = orderNo.replace(".pdf", "");
                                                resolveTask.setOrderNo(orderNo);
                                            }
                                            this.taskProducer.addTask(resolveTask);
                                        }
                                    }
                                    XxlJobLogger.log((String)"\u4e0a\u4f20\u91c7\u96c6\u6587\u4ef6\u5230OSS\u5b8c\u6bd5", (Object[])new Object[0]);
                                    break block39;
                                }
                                flag = "false";
                                remark = "\u672a\u83b7\u53d6\u5230\u9501";
                                XxlJobLogger.log((String)remark, (Object[])new Object[0]);
                                ExceptionDdNoticer.loggerError(log, "\u91c7\u96c6\u4efb\u52a1\u672a\u83b7\u53d6\u5230\u9501 \u8d26\u53f7: {}, \u5355\u636e\u7c7b\u578b: {}", account.getAccountName(), dcsJobHandler.billType());
                            }
                            catch (Exception e) {
                                log.error("\u91c7\u96c6\u6216\u89e3\u6790\u5f02\u5e38 {} {} {}", new Object[]{paramStr, dcsJobHandler.billType(), e.getMessage(), e});
                                remark = "\u91c7\u96c6\u6216\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage();
                                XxlJobLogger.log((String)remark, (Object[])new Object[0]);
                                if (account.isBatchRenameEnable()) {
                                    FileUtil.deleteFile(account);
                                }
                                ExceptionDdNoticer.loggerError(log, "\u91c7\u96c6\u6216\u89e3\u6790\u5f02\u5e38 \u8d26\u53f7: {}, \u5355\u636e\u7c7b\u578b: {}, {}", account.getAccountName(), dcsJobHandler.billType(), e.getMessage());
                                flag = "false";
                            }
                            finally {
                                if (lock) {
                                    this.redissonLock.release(key);
                                    XxlJobLogger.log((String)"\u9501\u5df2\u91ca\u653e", (Object[])new Object[0]);
                                }
                            }
                        }
                        catch (Exception e) {
                            remark = "\u91c7\u96c6\u5f02\u5e38:" + e.getMessage();
                            log.error(remark);
                            e.printStackTrace();
                            XxlJobLogger.log((String)e.getMessage(), (Object[])new Object[0]);
                            flag = "false";
                        }
                        finally {
                            log.info("\u91c7\u96c6\u5b50\u4efb\u52a1\u6570:" + latch.getCount());
                            latch.countDown();
                            log.info("\u91c7\u96c6\u5b50\u4efb\u52a1\u51cf1:" + latch.getCount());
                            resultMap.put(accountDto.getAccountId() + ":" + accountDto.getCollectionAccount(), flag);
                            try {
                                if (null != account) {
                                    CollectRecordHandler.doHoldData(new CollectParam(account.getAccountId(), flag, remark, start, DateFormatUtil.getCurrentFormatDateTime()));
                                }
                            }
                            catch (Exception e) {
                                XxlJobLogger.log((String)e.getMessage(), (Object[])new Object[0]);
                            }
                        }
                    }
                });
            }
            latch.await();
        }
        catch (Exception ex) {
            XxlJobLogger.log((String)("\u83b7\u53d6\u8d26\u53f7\u5f02\u5e38 " + ex.getMessage()), (Object[])new Object[0]);
            ExceptionDdNoticer.loggerError(log, "\u83b7\u53d6\u8d26\u53f7\u5f02\u5e38 \u4efb\u52a1\u53c2\u6570: {}, {}", paramStr, ex.getMessage());
            ReturnT returnT = FAIL;
            return returnT;
        }
        finally {
            if (null != executorService) {
                executorService.shutdown();
            }
        }
        boolean isSuccess = true;
        for (String key : resultMap.keySet()) {
            if (Objects.equals(resultMap.get(key), "true")) {
                XxlJobLogger.log((String)("ID+\u8d26\u53f7\u91c7\u96c6\u6210\u529f" + key), (Object[])new Object[0]);
                continue;
            }
            isSuccess = false;
            XxlJobLogger.log((String)("ID+\u8d26\u53f7\u91c7\u96c6\u5931\u8d25" + key), (Object[])new Object[0]);
        }
        return isSuccess ? SUCCESS : FAIL;
    }

    private void lockAccount(String accountId) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("Authentication", HttpConfig.getConfig((String)"common.authentication"));
        headers.put("action", HttpConfig.getConfig((String)"common.lockAccount.action"));
        headers.put("serialNo", accountId);
        headers.put("businessKey", accountId);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("doJanusLock", "true");
        try {
            JanusHttpUtil.doGetEntire((String)this.janusUrl, params, (boolean)false, headers);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    private DcsJobHandler getDcsJobHandler() {
        DcsJobHandler dcsJobHandler = ((Object)((Object)this)).getClass().getAnnotation(DcsJobHandler.class);
        if (dcsJobHandler == null) {
            throw new RuntimeException("\u672a\u627e\u5230DcsJobHandler\u6ce8\u89e3");
        }
        return dcsJobHandler;
    }

    private JobHandlerParam getJobHandlerParam() {
        JobHandlerParam jobHandlerParam = ((Object)((Object)this)).getClass().getAnnotation(JobHandlerParam.class);
        if (jobHandlerParam == null) {
            return null;
        }
        return jobHandlerParam;
    }

    private AccountTemplateDO genAccount(CollectAccountDto accountDto, JSONObject extra, JobHandlerParam jobHandlerParam) {
        long times;
        JSONObject jobExtraInfo;
        String jobExtra = accountDto.getJobExtraInfo();
        String siteUrl = null;
        if (StringUtils.isBlank((CharSequence)jobExtra)) {
            jobExtraInfo = new JSONObject();
        } else {
            jobExtraInfo = JSONObject.parseObject((String)jobExtra);
            jobExtraInfo = null == jobExtraInfo ? new JSONObject() : jobExtraInfo;
            siteUrl = jobExtraInfo.getString("siteUrl");
        }
        Boolean retailExist = StringUtils.isBlank((CharSequence)accountDto.getPurchaseRetailerId());
        jobExtraInfo.putAll((Map)extra);
        AccountTemplateDO account = (AccountTemplateDO)jobExtraInfo.to(AccountTemplateDO.class, new JSONReader.Feature[0]);
        account.setSiteUrl(StringUtils.isNotBlank((CharSequence)siteUrl) ? siteUrl : accountDto.getSiteUrl());
        account.setAccountId(accountDto.getAccountId());
        account.setAccountName(accountDto.getCollectionAccount());
        account.setAccountPassword(this.getPassword(accountDto.getAccountSecretKey()));
        account.setRetailKey(retailExist != false ? jobHandlerParam.retail().getKey() : accountDto.getPurchaseRetailerId());
        account.setRetail(retailExist != false ? jobHandlerParam.retail().getLabel() : accountDto.getPurchaseRetailerName());
        if (StringUtils.isNotBlank((CharSequence)accountDto.getBelongTenant()) && StringUtils.isNumeric((CharSequence)accountDto.getBelongTenant())) {
            account.setTenantId(Long.parseLong(accountDto.getBelongTenant()));
        } else {
            account.setTenantId(0L);
        }
        String projectKey = jobExtraInfo.getString("projectKey");
        account.setProject(StringUtils.isNotBlank((CharSequence)projectKey) ? projectKey : accountDto.getKaCode());
        account.setProjectKey(StringUtils.isNotBlank((CharSequence)projectKey) ? projectKey : accountDto.getKaCode());
        if (null == accountDto.getEffectiveDateFrom()) {
            times = System.currentTimeMillis() - 3600000L;
            accountDto.setEffectiveDateFrom(times);
        }
        if (null == accountDto.getEffectiveDateTo()) {
            times = System.currentTimeMillis() + 2592000000L;
            accountDto.setEffectiveDateTo(times);
        }
        account.setDragValidityDateEnd(new Date(accountDto.getEffectiveDateTo()));
        account.setDragValidityDateStart(new Date(accountDto.getEffectiveDateFrom()));
        return account;
    }

    private String getPassword(String encrypted) {
        if (StringUtils.isBlank((CharSequence)encrypted)) {
            throw new RuntimeException("\u8d26\u53f7\u5bc6\u7801\u4e3a\u7a7a");
        }
        try {
            return AesUtil.aesDecrypt(encrypted, this.aesKey);
        }
        catch (Exception ex) {
            throw new RuntimeException("\u8d26\u53f7\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25 " + ex.getMessage());
        }
    }

    protected abstract AbstractLoginSys getLoginSys();

    protected abstract List<String> doCollect(WebClient var1, AccountTemplateDO var2, Map<String, String> var3) throws Exception;

    protected String getCharset() {
        return "utf-8";
    }
}

