/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.xforceplus.utils.StringLib;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtil {
    private static BiMap<Integer, String> excelColKeyMap = HashBiMap.create();

    private static String index2ColName(int index) {
        int remainder;
        if (index < 0) {
            return null;
        }
        int num = 65;
        String colName = "";
        do {
            if (colName.length() > 0) {
                --index;
            }
            remainder = index % 26;
            colName = (char)(remainder + num) + colName;
        } while ((index = (index - remainder) / 26) > 0);
        return colName;
    }

    public static String getExcelColKeyByIndex(int index) {
        return (String)excelColKeyMap.get((Object)index);
    }

    public static HashSet<String> getColumnSet(String filePath, int column, int startRow, int endRow) {
        Workbook wb = ExcelUtil.readExcel(filePath);
        Sheet sheet = wb.getSheetAt(0);
        Row row = null;
        HashSet<String> result = new HashSet<String>();
        String cellData = null;
        for (int i = startRow - 1; i < endRow && (row = sheet.getRow(i)) != null; ++i) {
            cellData = (String)ExcelUtil.getCellFormatValue(row.getCell(column - 1));
            result.add(cellData.replaceAll(" ", ""));
        }
        return result;
    }

    public static HashSet<String> getColumnSet(String filePath, int column, int startRow) {
        Workbook wb = ExcelUtil.readExcel(filePath);
        Sheet sheet = wb.getSheetAt(0);
        int rownum = sheet.getPhysicalNumberOfRows();
        return ExcelUtil.getColumnSet(filePath, column, startRow, rownum - 1);
    }

    public static Workbook readExcel(String filePath) {
        XSSFWorkbook wb = null;
        if (filePath == null) {
            return null;
        }
        String extString = filePath.substring(filePath.lastIndexOf("."));
        FileInputStream is = null;
        try {
            is = new FileInputStream(filePath);
            if (".xls".equals(extString)) {
                wb = new XSSFWorkbook((InputStream)is);
                return wb;
            }
            if (".xlsx".equals(extString)) {
                wb = new XSSFWorkbook((InputStream)is);
                return wb;
            }
            wb = null;
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return wb;
        }
    }

    public static Object getCellFormatValue(Cell cell) {
        String cellValue = null;
        if (cell != null) {
            switch (cell.getCellType()) {
                case 0: {
                    cell.setCellType(CellType.STRING);
                    cellValue = cell.getStringCellValue();
                    break;
                }
                case 1: {
                    cellValue = cell.getRichStringCellValue().getString();
                    break;
                }
                default: {
                    cellValue = "";
                    break;
                }
            }
        } else {
            cellValue = "";
        }
        return cellValue;
    }

    public static Object getExcelVal(InputStream inputStream, int leastRow, int rowIdx, int cellIdx, String suffix) {
        return ExcelUtil.getExcelVal(inputStream, leastRow, 0, rowIdx, cellIdx, suffix);
    }

    public static Object getExcelVal(InputStream inputStream, int leastRow, int sheetIdx, int rowIdx, int cellIdx, String suffix) {
        Object value = "";
        try {
            boolean flag;
            Object workbook = ".xlsx".equalsIgnoreCase(suffix) ? new XSSFWorkbook(inputStream) : new HSSFWorkbook(inputStream);
            Sheet sheet = workbook.getSheetAt(sheetIdx);
            boolean bl = flag = sheet == null || sheet.getPhysicalNumberOfRows() < leastRow;
            if (!flag) {
                try {
                    Row row = sheet.getRow(rowIdx);
                    Cell cell = row.getCell(cellIdx);
                    value = ExcelUtil.getCellFormatValue(cell);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    static {
        for (int i = 0; i < 200; ++i) {
            excelColKeyMap.put((Object)i, (Object)StringLib.lowerCase((String)ExcelUtil.index2ColName(i)));
        }
    }
}

