/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.UnexpectedPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import com.xforceplus.exception.XxlCrawlerException;
import com.xforceplus.utils.PageUtil;
import com.xforceplus.utils.StringConvertUtils;
import com.xxl.job.core.log.XxlJobLogger;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;

public class RetryUtil {
    public static final int RETRY_MAX_TIME = 3;
    public static final int RETRY_INTERVAL = 3000;
    public static final int SUCCESS_STATUS_CODE = 200;

    public static void retry(WebClient webClient, String url, Page page) {
        try {
            RetryUtil.retry(webClient, new WebRequest(new URL(url)), page);
        }
        catch (Exception e) {
            throw new XxlCrawlerException(e.getMessage());
        }
    }

    public static void retry(WebClient webClient, WebRequest webRequest, Page page) {
        try {
            for (int retryTime = 1; (page == null || page.getWebResponse().getStatusCode() != 200) && retryTime <= 3; ++retryTime) {
                Thread.sleep(3000L);
                page = webClient.getPage(webRequest);
                XxlJobLogger.log((String)"\u94fe\u63a5{}\u8bf7\u6c42{}\u6b21", (Object[])new Object[]{page.getUrl(), retryTime});
            }
        }
        catch (Exception e) {
            throw new XxlCrawlerException(e.getMessage());
        }
    }

    public static void retry(WebClient webClient, String url, HttpMethod httpMethod, String[][] params, Page page, String ... signArr) {
        try {
            int retryTime = 1;
            String pageContent = "";
            if (page instanceof XmlPage) {
                pageContent = ((XmlPage)page).asXml();
            } else if (page instanceof HtmlPage) {
                pageContent = ((HtmlPage)page).asXml();
            }
            boolean isContainFlag = false;
            if (signArr.length > 0) {
                for (String sign : signArr) {
                    if (!pageContent.contains(sign)) continue;
                    isContainFlag = true;
                }
            }
            while ((page == null || page.getWebResponse().getStatusCode() != 200 || signArr.length > 0 && !isContainFlag) && retryTime <= 3) {
                Thread.sleep(3000L);
                XxlJobLogger.log((String)"\u91cd\u8bd5{}\u6b21\uff0c\u94fe\u63a5{}", (Object[])new Object[]{retryTime, url});
                page = PageUtil.getPage(webClient, url, httpMethod, params, null, null, null);
                ++retryTime;
            }
        }
        catch (Exception e) {
            throw new XxlCrawlerException(e.getMessage());
        }
    }

    public static void retry(WebClient webClient, String url, HttpMethod httpMethod, String[][] params, Map<String, String> headers, Charset charset, FormEncodingType formEncodingType, Page page, String ... signArr) {
        try {
            int retryTime = 1;
            String pageContent = "";
            if (page instanceof XmlPage) {
                pageContent = ((XmlPage)page).asXml();
            } else if (page instanceof HtmlPage) {
                pageContent = ((HtmlPage)page).asXml();
            } else if (page instanceof UnexpectedPage) {
                pageContent = page.getWebResponse().getContentAsString();
            } else if (page instanceof TextPage) {
                pageContent = page.getWebResponse().getContentAsString();
            }
            boolean isContainFlag = false;
            if (signArr.length > 0) {
                for (String sign : signArr) {
                    if (!pageContent.contains(sign)) continue;
                    isContainFlag = true;
                }
            }
            while ((page == null || page.getWebResponse().getStatusCode() != 200 || signArr.length > 0 && !isContainFlag) && retryTime <= 3) {
                Thread.sleep(3000L);
                XxlJobLogger.log((String)"\u91cd\u8bd5{}\u6b21\uff0c\u94fe\u63a5{}", (Object[])new Object[]{retryTime, url});
                page = PageUtil.getPage(webClient, url, httpMethod, params, headers, charset, formEncodingType);
                ++retryTime;
            }
        }
        catch (Exception e) {
            throw new XxlCrawlerException(e.getMessage());
        }
    }

    public static void retry(WebClient webClient, WebRequest webRequest, Page page, String ... signArr) {
        try {
            int retryTime = 1;
            String pageContent = "";
            if (page instanceof XmlPage) {
                pageContent = ((XmlPage)page).asXml();
            } else if (page instanceof HtmlPage) {
                pageContent = ((HtmlPage)page).asXml();
            }
            boolean isContainFlag = false;
            if (signArr.length > 0) {
                for (String sign : signArr) {
                    if (!pageContent.contains(sign)) continue;
                    isContainFlag = true;
                }
            }
            while ((page == null || page.getWebResponse().getStatusCode() != 200 || signArr.length > 0 && !isContainFlag) && retryTime <= 3) {
                Thread.sleep(3000L);
                XxlJobLogger.log((String)"\u91cd\u8bd5{}\u6b21\uff0c\u94fe\u63a5{}", (Object[])new Object[]{retryTime, webRequest.getUrl()});
                page = webClient.getPage(webRequest);
                ++retryTime;
            }
        }
        catch (Exception e) {
            throw new XxlCrawlerException(e.getMessage());
        }
    }

    public static void retry(WebClient webClient, String url, HttpMethod httpMethod, String requestBody, Map<String, String> headers, Charset charset, Page page, String ... signArr) {
        try {
            int retryTime = 1;
            String pageContent = "";
            if (page instanceof XmlPage) {
                pageContent = ((XmlPage)page).asXml();
            } else if (page instanceof HtmlPage) {
                pageContent = ((HtmlPage)page).asXml();
            } else if (page instanceof UnexpectedPage) {
                pageContent = page.getWebResponse().getContentAsString();
            } else if (page instanceof TextPage) {
                pageContent = page.getWebResponse().getContentAsString();
            }
            boolean isContainFlag = false;
            if (signArr.length > 0) {
                for (String sign : signArr) {
                    if (!pageContent.contains(sign)) continue;
                    isContainFlag = true;
                }
            }
            while ((page == null || page.getWebResponse().getStatusCode() != 200 || signArr.length > 0 && !isContainFlag) && retryTime <= 3) {
                Thread.sleep(3000L);
                XxlJobLogger.log((String)"\u91cd\u8bd5{}\u6b21\uff0c\u94fe\u63a5{}", (Object[])new Object[]{retryTime, url});
                page = PageUtil.getPage(webClient, url, httpMethod, requestBody, headers, charset);
                ++retryTime;
            }
        }
        catch (Exception e) {
            throw new XxlCrawlerException(e.getMessage());
        }
    }

    private RetryUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String retryLoadingAll(WebClient webClient, String url, Page page) {
        try {
            WebRequest webRequest = new WebRequest(new URL(url));
            RetryUtil.retry(webClient, webRequest, page);
            for (int retryTime = 1; page != null && retryTime <= 3; ++retryTime) {
                String contentAsString = page.getWebResponse().getContentAsString();
                if (!StringConvertUtils.loading(contentAsString)) {
                    return contentAsString;
                }
                RetryUtil.retry(webClient, webRequest, page);
            }
            XxlJobLogger.log((String)"\u672a\u52a0\u8f7d\u5b8c\u6210------", (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new XxlCrawlerException(e.getMessage());
        }
        return null;
    }

    public static String retryLoadingAll(WebClient webClient, String url, HttpMethod httpMethod, String[][] params, Map<String, String> headers, Charset charset, FormEncodingType formEncodingType, Page page) {
        try {
            int retryTime;
            for (retryTime = 1; (page == null || page.getWebResponse().getStatusCode() != 200) && retryTime <= 3; ++retryTime) {
                Thread.sleep(3000L);
                page = PageUtil.getPage(webClient, url, httpMethod, params, headers, charset, formEncodingType);
            }
            for (retryTime = 1; page != null && retryTime <= 3; ++retryTime) {
                String contentAsString = page.getWebResponse().getContentAsString();
                if (!StringConvertUtils.loading(contentAsString)) {
                    return contentAsString;
                }
                Thread.sleep(3000L);
                page = PageUtil.getPage(webClient, url, httpMethod, params, headers, charset, formEncodingType);
            }
            XxlJobLogger.log((String)"\u672a\u52a0\u8f7d\u5b8c\u6210------", (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new XxlCrawlerException(e.getMessage());
        }
        return null;
    }

    public static String retryLoadingAll(WebClient webClient, WebRequest webRequest, Page page) {
        try {
            RetryUtil.retry(webClient, webRequest, page);
            for (int retryTime = 1; page != null && retryTime <= 3; ++retryTime) {
                String contentAsString = page.getWebResponse().getContentAsString();
                if (!StringConvertUtils.loading(contentAsString)) {
                    return contentAsString;
                }
                RetryUtil.retry(webClient, webRequest, page);
            }
            XxlJobLogger.log((String)"\u672a\u52a0\u8f7d\u5b8c\u6210------", (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new XxlCrawlerException(e.getMessage());
        }
        return null;
    }

    public static void retry(WebClient webClient, String url, Map<String, String> headers, HttpMethod httpMethod, Page page) {
        RetryUtil.retry(webClient, url, httpMethod, null, headers, null, page, new String[0]);
    }

    public static Page retryReturnPage(WebClient webClient, WebRequest webRequest, Page page) {
        try {
            for (int retryTime = 1; (page == null || page.getWebResponse().getStatusCode() != 200) && retryTime <= 3; ++retryTime) {
                Thread.sleep(3000L);
                page = webClient.getPage(webRequest);
                XxlJobLogger.log((String)"\u94fe\u63a5{}\u8bf7\u6c42{}\u6b21", (Object[])new Object[]{page.getUrl(), retryTime});
            }
        }
        catch (Exception e) {
            throw new XxlCrawlerException(e.getMessage());
        }
        return page;
    }
}

