/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.captcha;

import com.alibaba.fastjson.JSONObject;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.xforceplus.captcha.ChaoJiYing;
import com.xforceplus.core.config.CommonConfig;
import com.xforceplus.core.enums.IntConstant;
import com.xforceplus.utils.Config;
import com.xforceplus.utils.HtmlStrUtil;
import com.xforceplus.utils.RedisUtil;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;

public class CaptchaUtil {
    public static String ORIGIN_URL = CommonConfig.ORIGIN_URL;
    public static String SLIDER_URL = CommonConfig.SLIDER_URL;
    private static int POWERE2E_RETRY = CommonConfig.POWERE2E_RETRY;
    private static int CHAOJIYING_RETRY = CommonConfig.CHAOJIYING_RETRY;

    public static String getVcodeByDama2(Page page, int type, int timeout) {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            if (page != null) {
                File file = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString());
                InputStream inputStream = page.getWebResponse().getContentAsStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
                byte[] data = byteArrayOutputStream.toByteArray();
                FileUtils.writeByteArrayToFile((File)file, (byte[])data);
                String pluginName = ThreadContext.get((String)"pluginName");
                ThreadContext.put((String)(pluginName + "_vcodePath"), (String)file.getAbsolutePath());
                HashMap<String, String> codetypeMap = new HashMap<String, String>();
                codetypeMap.put("42", "1902");
                codetypeMap.put("53", "1005");
                codetypeMap.put("54", "1006");
                codetypeMap.put("55", "6001");
                codetypeMap.put("50", "5000");
                HashMap<String, String> lenMinMap = new HashMap<String, String>();
                lenMinMap.put("42", "4");
                lenMinMap.put("53", "5");
                lenMinMap.put("54", "6");
                lenMinMap.put("55", "0");
                lenMinMap.put("50", "5");
                String msg = ChaoJiYing.PostPic(Config.UNAME, Config.UPASS, Config.APPID, (String)codetypeMap.get(String.valueOf(type)), (String)lenMinMap.get(String.valueOf(type)), data);
                RedisUtil.cjyTotalAdd();
                JSONObject jsonObject = JSONObject.parseObject((String)msg);
                String err_str = jsonObject.getString("err_str");
                String code = jsonObject.getString("pic_str");
                XxlJobLogger.log((String)file.getAbsolutePath(), (Object[])new Object[0]);
                XxlJobLogger.log((String)(code + "=" + err_str), (Object[])new Object[0]);
                ThreadContext.put((String)(pluginName + "_vcodeValue"), (String)code);
                return code;
            }
        }
        catch (Throwable e) {
            XxlJobLogger.log((String)"get vcode error by datam2", (Object[])new Object[]{e});
        }
        return null;
    }

    public static String getVcodeByDama2(WebClient webClient, int type, int timeout, String url) {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            Page page = webClient.getPage(url);
            if (page != null) {
                File file = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString());
                InputStream inputStream = page.getWebResponse().getContentAsStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
                byte[] data = byteArrayOutputStream.toByteArray();
                FileUtils.writeByteArrayToFile((File)file, (byte[])data);
                String pluginName = ThreadContext.get((String)"pluginName");
                ThreadContext.put((String)(pluginName + "_vcodePath"), (String)file.getAbsolutePath());
                HashMap<String, String> codetypeMap = new HashMap<String, String>();
                codetypeMap.put("42", "1902");
                codetypeMap.put("53", "1005");
                codetypeMap.put("54", "1006");
                codetypeMap.put("55", "6001");
                HashMap<String, String> lenMinMap = new HashMap<String, String>();
                lenMinMap.put("42", "4");
                lenMinMap.put("53", "5");
                lenMinMap.put("54", "6");
                lenMinMap.put("55", "0");
                String msg = ChaoJiYing.PostPic(Config.UNAME, Config.UPASS, Config.APPID, (String)codetypeMap.get(String.valueOf(type)), (String)lenMinMap.get(String.valueOf(type)), data);
                RedisUtil.cjyTotalAdd();
                JSONObject jsonObject = JSONObject.parseObject((String)msg);
                String err_str = jsonObject.getString("err_str");
                String code = jsonObject.getString("pic_str");
                XxlJobLogger.log((String)file.getAbsolutePath(), (Object[])new Object[0]);
                XxlJobLogger.log((String)(code + "=" + err_str), (Object[])new Object[0]);
                ThreadContext.put((String)(pluginName + "_vcodeValue"), (String)code);
                return code;
            }
        }
        catch (Throwable e) {
            XxlJobLogger.log((String)"get vcode error by datam2", (Object[])new Object[]{e});
        }
        return null;
    }

    public static String decode(WebClient webClient, String type, String url) {
        String captcha = CaptchaUtil.getString(webClient, type, url, "");
        if (StringUtils.isEmpty((CharSequence)captcha)) {
            for (int index = IntConstant.ZERO; index < IntConstant.FIVE; ++index) {
                if ((captcha = CaptchaUtil.getString(webClient, type, url, captcha)) == null || captcha.length() <= 0) continue;
                return captcha;
            }
        }
        assert (captcha != null);
        if (captcha.contains("#")) {
            CaptchaUtil.decode(webClient, type, url);
        }
        return captcha;
    }

    private static String getString(WebClient webClient, String type, String url, String captcha) {
        int count = IntConstant.ZERO;
        int i = IntConstant.ZERO;
        Page page = null;
        try {
            page = webClient.getPage(url);
            while (count == IntConstant.ZERO) {
                Thread.sleep(IntConstant.ONE_THOUSAND);
                count = page.getWebResponse().getContentAsStream().available();
                if (i >= IntConstant.THREE && count == IntConstant.ZERO) {
                    XxlJobLogger.log((String)"\u7b2c{}\u6b21\u9a8c\u8bc1\u7801\u56fe\u7247\u8bf7\u6c42{}", (Object[])new Object[]{i, url});
                    page = webClient.getPage(url);
                    break;
                }
                ++i;
            }
            XxlJobLogger.log((String)"\u9a8c\u8bc1\u7801\u56fe\u7247\u8bf7\u6c42{} \u56fe\u7247Size={}/Bit", (Object[])new Object[]{url, count});
            captcha = CaptchaUtil.decode(page, type);
        }
        catch (FailingHttpStatusCodeException e) {
            XxlJobLogger.log((String)"\u8bc1\u7801\u56fe\u7247\u8bf7\u6c42{},FailingHttpStatusCodeException-\u5f02\u5e38{}", (Object[])new Object[]{url, e.getMessage()});
            captcha = "";
        }
        catch (MalformedURLException e) {
            XxlJobLogger.log((String)"\u8bc1\u7801\u56fe\u7247\u8bf7\u6c42{},MalformedURLException-\u5f02\u5e38{}", (Object[])new Object[]{url, e.getMessage()});
            captcha = "";
        }
        catch (IOException e) {
            XxlJobLogger.log((String)"\u91cd\u8bd5\u9a8c\u8bc1\u7801\u56fe\u7247\u8bf7\u6c42{}\uff0cIOException-\u5f02\u5e38{},", (Object[])new Object[]{url, e.getMessage()});
            try {
                Thread.sleep(IntConstant.TWO_THOUSAND);
                captcha = "";
            }
            catch (InterruptedException e2) {
                XxlJobLogger.log((String)"\u91cd\u8bd5\u9a8c\u8bc1\u7801\u56fe\u7247\u8bf7\u6c42{} InterruptedException-\u5f02\u5e38{},", (Object[])new Object[]{url, e2.getMessage()});
            }
        }
        catch (InterruptedException e) {
            captcha = "";
            e.printStackTrace();
        }
        return captcha;
    }

    public static String decode(Page page, String type) {
        try {
            for (int i = IntConstant.ZERO; i < POWERE2E_RETRY; ++i) {
                InputStream inputStream = page.getWebResponse().getContentAsStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
                byte[] imgByteArr = byteArrayOutputStream.toByteArray();
                OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
                clientBuilder.readTimeout((long)IntConstant.FOUR_HUNDRED, TimeUnit.SECONDS);
                clientBuilder.connectTimeout((long)IntConstant.SIXTY, TimeUnit.SECONDS);
                clientBuilder.writeTimeout((long)IntConstant.SIXTY, TimeUnit.SECONDS);
                OkHttpClient client = clientBuilder.build();
                MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", type, RequestBody.create((MediaType)MediaType.parse((String)"text/plain; charset=utf-8"), (byte[])imgByteArr)).build();
                Request request = new Request.Builder().url(ORIGIN_URL).post((RequestBody)requestBody).build();
                Response response = client.newCall(request).execute();
                RedisUtil.e2eTotalAdd();
                assert (response.body() != null);
                JSONObject jsonObject = JSONObject.parseObject((String)response.body().string());
                if (jsonObject.get((Object)"value") != null) {
                    XxlJobLogger.log((String)"\u5546\u8054\u8bc6\u522b\u9a8c\u8bc1\u7801=".concat(jsonObject.get((Object)"value").toString()), (Object[])new Object[0]);
                    return jsonObject.get((Object)"value").toString();
                }
                try {
                    Thread.sleep(IntConstant.ONE_THOUSAND);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            if (e.getMessage().contains("<html>")) {
                XxlJobLogger.log((String)"\u5546\u8054\u9a8c\u8bc1\u7801\u670d\u52a1\u5f02\u5e38\uff01{}", (Object[])new Object[]{HtmlStrUtil.html2Text(e.getMessage(), "<[^>]+>")});
            }
            XxlJobLogger.log((String)"\u5546\u8054\u9a8c\u8bc1\u7801\u670d\u52a1\u5f02\u5e38\uff01{}", (Object[])new Object[]{e.getMessage()});
        }
        try {
            for (int j = IntConstant.ZERO; j < CHAOJIYING_RETRY; ++j) {
                String code_ = CaptchaUtil.getVcodeByDama2(page, 42, 60000);
                if (StringUtils.isNotBlank((CharSequence)code_)) {
                    XxlJobLogger.log((String)"\u8d85\u7ea7\u9e70\u8bc6\u522b\u9a8c\u8bc1\u7801=".concat(code_), (Object[])new Object[0]);
                    return code_;
                }
                try {
                    Thread.sleep(IntConstant.ONE_THOUSAND);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            XxlJobLogger.log((String)"\u8d85\u7ea7\u9e70\u9a8c\u8bc1\u7801\u670d\u52a1\u5f02\u5e38\uff01", (Object[])new Object[0]);
        }
        return null;
    }

    public static String sliderDecode(String accountName, String accountPassword, String customer, String url) {
        for (int i = 0; i < 1; ++i) {
            XxlJobLogger.log((String)"\u9a8c\u8bc1\u7801\u91cd\u8bd5{}", (Object[])new Object[]{i + 1});
            try {
                OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
                clientBuilder.readTimeout((long)IntConstant.FOUR_HUNDRED, TimeUnit.SECONDS);
                clientBuilder.connectTimeout((long)IntConstant.SIXTY, TimeUnit.SECONDS);
                clientBuilder.writeTimeout((long)IntConstant.SIXTY, TimeUnit.SECONDS);
                OkHttpClient okHttpClient = clientBuilder.build();
                JSONObject jsonBody = new JSONObject();
                JSONObject data = new JSONObject();
                jsonBody.put("username", (Object)accountName);
                jsonBody.put("password", (Object)accountPassword);
                jsonBody.put("customer", (Object)customer);
                jsonBody.put("url", (Object)url);
                data.put("data", (Object)jsonBody);
                XxlJobLogger.log((String)data.toJSONString(), (Object[])new Object[0]);
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)data.toJSONString());
                Request request = new Request.Builder().url(SLIDER_URL).post(requestBody).build();
                Response response = okHttpClient.newCall(request).execute();
                RedisUtil.e2eTotalAdd();
                assert (response.body() != null);
                String result = response.body().string();
                XxlJobLogger.log((String)"\u9a8c\u8bc1\u7801:{}", (Object[])new Object[]{result});
                return result;
            }
            catch (Exception e) {
                XxlJobLogger.log((String)"\u9a8c\u8bc1\u7801\u670d\u52a1\u5f02\u5e38\uff01{}", (Object[])new Object[]{e.getMessage()});
                continue;
            }
        }
        return null;
    }

    public static String decode(InputStream inputStream, String type) {
        try {
            for (int i = 0; i < 3; ++i) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
                byte[] imgByteArr = byteArrayOutputStream.toByteArray();
                OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
                clientBuilder.readTimeout((long)IntConstant.FOUR_HUNDRED, TimeUnit.SECONDS);
                clientBuilder.connectTimeout((long)IntConstant.SIXTY, TimeUnit.SECONDS);
                clientBuilder.writeTimeout((long)IntConstant.SIXTY, TimeUnit.SECONDS);
                OkHttpClient client = clientBuilder.build();
                MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", type, RequestBody.create((MediaType)MediaType.parse((String)"text/plain; charset=utf-8"), (byte[])imgByteArr)).build();
                Request request = new Request.Builder().url(ORIGIN_URL).post((RequestBody)requestBody).build();
                Response response = client.newCall(request).execute();
                RedisUtil.e2eTotalAdd();
                assert (response.body() != null);
                JSONObject jsonObject = JSONObject.parseObject((String)response.body().string());
                if (jsonObject.get((Object)"value") != null) {
                    XxlJobLogger.log((String)"\u5546\u8054\u8bc6\u522b\u9a8c\u8bc1\u7801=".concat(jsonObject.get((Object)"value").toString()), (Object[])new Object[0]);
                    return jsonObject.get((Object)"value").toString();
                }
                try {
                    Thread.sleep(IntConstant.ONE_THOUSAND);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            if (e.getMessage().contains("<html>")) {
                XxlJobLogger.log((String)"\u5546\u8054\u9a8c\u8bc1\u7801\u670d\u52a1\u5f02\u5e38\uff01{}", (Object[])new Object[]{HtmlStrUtil.html2Text(e.getMessage(), "<[^>]+>")});
            }
            XxlJobLogger.log((String)"\u5546\u8054\u9a8c\u8bc1\u7801\u670d\u52a1\u5f02\u5e38\uff01{}", (Object[])new Object[]{e.getMessage()});
        }
        try {
            for (int j = IntConstant.ZERO; j < CHAOJIYING_RETRY; ++j) {
                String code_ = CaptchaUtil.getVcodeByDama2(inputStream, 42, 60000);
                if (StringUtils.isNotBlank((CharSequence)code_)) {
                    XxlJobLogger.log((String)"\u8d85\u7ea7\u9e70\u8bc6\u522b\u9a8c\u8bc1\u7801=".concat(code_), (Object[])new Object[0]);
                    return code_;
                }
                try {
                    Thread.sleep(IntConstant.ONE_THOUSAND);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            XxlJobLogger.log((String)"\u8d85\u7ea7\u9e70\u9a8c\u8bc1\u7801\u670d\u52a1\u5f02\u5e38\uff01", (Object[])new Object[0]);
        }
        return null;
    }

    public static String getVcodeByDama2(InputStream inputStream, int type, int timeout) {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            File file = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
            byte[] data = byteArrayOutputStream.toByteArray();
            FileUtils.writeByteArrayToFile((File)file, (byte[])data);
            String pluginName = ThreadContext.get((String)"pluginName");
            ThreadContext.put((String)(pluginName + "_vcodePath"), (String)file.getAbsolutePath());
            HashMap<String, String> codetypeMap = new HashMap<String, String>();
            codetypeMap.put("42", "1902");
            codetypeMap.put("53", "1005");
            codetypeMap.put("54", "1006");
            codetypeMap.put("55", "6001");
            codetypeMap.put("50", "5000");
            HashMap<String, String> lenMinMap = new HashMap<String, String>();
            lenMinMap.put("42", "4");
            lenMinMap.put("53", "5");
            lenMinMap.put("54", "6");
            lenMinMap.put("55", "0");
            lenMinMap.put("50", "5");
            String msg = ChaoJiYing.PostPic(Config.UNAME, Config.UPASS, Config.APPID, (String)codetypeMap.get(String.valueOf(type)), (String)lenMinMap.get(String.valueOf(type)), data);
            RedisUtil.cjyTotalAdd();
            JSONObject jsonObject = JSONObject.parseObject((String)msg);
            String err_str = jsonObject.getString("err_str");
            String code = jsonObject.getString("pic_str");
            XxlJobLogger.log((String)file.getAbsolutePath(), (Object[])new Object[0]);
            XxlJobLogger.log((String)(code + "=" + err_str), (Object[])new Object[0]);
            ThreadContext.put((String)(pluginName + "_vcodeValue"), (String)code);
            return code;
        }
        catch (Throwable e) {
            XxlJobLogger.log((String)"get vcode error by datam2", (Object[])new Object[]{e});
            return null;
        }
    }
}

