/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.core.resolve.html;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Stopwatch;
import com.xforceplus.core.config.CommonConfig;
import com.xforceplus.core.enums.CharSetEnum;
import com.xforceplus.core.resolve.AbstractFileTypeImportBean;
import com.xforceplus.core.resolve.ResolveTask;
import com.xforceplus.utils.FileUtils;
import com.xforceplus.utils.ProcessRuntimeLib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeHtmlImportBean
extends AbstractFileTypeImportBean {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)NodeHtmlImportBean.class.getName());
    private static final Integer RETRIES_NUM = 5;
    private String html = "";
    private String javaScriptCode = "";
    private ResolveTask task;

    public NodeHtmlImportBean(String html_, String javascriptCode_, ResolveTask task) {
        String htmlCache = html_;
        this.html = htmlCache.replace("\\", "\\\\");
        this.javaScriptCode = javascriptCode_;
        this.task = task;
    }

    public NodeHtmlImportBean() {
    }

    public String parseData() {
        try {
            String nodeDirectory = CommonConfig.HTML_NODE_DIRECTORY;
            Stopwatch stopwatch = Stopwatch.createStarted();
            String data = this.loadJSToRuntime(nodeDirectory);
            stopwatch.stop();
            LOGGER.info("NodeHtmlImportBean stopwatch time:{},rowlist:{}", (Object)stopwatch, (Object)data.length());
            return data;
        }
        catch (Exception ex) {
            LOGGER.error("", (Throwable)ex);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadJSToRuntime(String nodeDirectory) {
        this.javaScriptCode = Convert.toStr((Object)this.javaScriptCode, (String)"");
        this.html = Convert.toStr((Object)this.html, (String)"");
        String functionName = StrUtil.join((CharSequence)"_", (Object[])new Object[]{"func", IdUtil.fastSimpleUUID()});
        String templateJS = FileUtils.readClassPathFileContent("js/htmlparser.txt");
        templateJS = StringUtils.replace((String)templateJS, (String)"@FUNC_NAME@", (String)functionName);
        templateJS = StringUtils.replace((String)templateJS, (String)"@FUNC_TEXT@", (String)this.javaScriptCode);
        templateJS = StringUtils.replace((String)templateJS, (String)"@HTML_CONTENT@", (String)this.html);
        templateJS = StringUtils.replace((String)templateJS, (String)"@task@", (String)JSON.toJSONString((Object)this.task));
        String filePath = StrUtil.join((CharSequence)File.separator, (Object[])new Object[]{nodeDirectory, functionName.concat(".js")});
        try {
            String data;
            LOGGER.info("filePath={}", (Object)filePath);
            FileUtil.writeUtf8String((String)templateJS, (File)new File(filePath));
            String cmd = StrUtil.join((CharSequence)" ", (Object[])new Object[]{"node", filePath});
            LOGGER.info("cmd={}", (Object)cmd);
            String errorData = data = ProcessRuntimeLib.getProcessResult(cmd, RETRIES_NUM);
            LOGGER.info("loadJSToRuntime final data:{}", (Object)data);
            data = StrUtil.subAfter((CharSequence)data, (CharSequence)"@@@@", (boolean)true);
            data = StrUtil.subBefore((CharSequence)data, (CharSequence)"====", (boolean)true);
            if (StrUtil.isNotEmpty((CharSequence)data)) {
                String string = data;
                return string;
            }
            LOGGER.error("loadJSToRuntime final errorData:{}", (Object)errorData);
        }
        catch (Exception ex) {
            String stacktrace = ExceptionUtil.stacktraceToString((Throwable)ex);
            LOGGER.error("error msg:{}", (Object)stacktrace);
        }
        finally {
            FileUtil.del((String)filePath);
        }
        return "";
    }

    @Override
    protected void handle1(InputStream inputStream, ResolveTask dataSource) {
        try {
            String charset = dataSource.getCharset();
            if (StringUtils.isEmpty((CharSequence)charset)) {
                charset = CharSetEnum.UTF8.getCharSet();
            }
            String inputStr = IOUtils.toString((InputStream)inputStream, (String)charset);
            this.addData("data1", inputStr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

