/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.lock.redisson;

import com.xforceplus.lock.constant.ReadWriteEnum;
import com.xforceplus.lock.redisson.RedissonManager;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RBucket;
import org.redisson.api.RLock;
import org.redisson.api.RMap;
import org.redisson.api.RReadWriteLock;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.RedisException;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.WriteRedisConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedissonLock.class);
    RedissonManager redissonManager;
    private boolean cacheNull;
    private static final int NULL_VALUE_KEY_CACHE_MILLISECONDS = 300000;
    private RMap rMap;
    private int reTry = 0;

    public RedissonLock(RedissonManager redissonManager) {
        this.redissonManager = redissonManager;
    }

    public RedissonLock() {
    }

    public boolean lock(String lockName, long expireSeconds) {
        boolean flag = false;
        if (!lockName.isEmpty() && expireSeconds > 0L) {
            block16: {
                try {
                    RLock rLock = this.redissonManager.getRedisson().getLock(lockName);
                    if (rLock.isLocked()) {
                        return flag;
                    }
                    flag = rLock.tryLock(0L, expireSeconds, TimeUnit.SECONDS);
                    return flag;
                }
                catch (WriteRedisConnectionException var11) {
                    LOGGER.error("LockKey={},Redisson\u5206\u5e03\u5f0f\u9501[\u9501\u5199\u5165\u5f02\u5e38]{}", (Object)lockName, (Object)var11.getMessage());
                    LOGGER.error("LockKey={},\u6b63\u5728\u91cd\u8bd5\u7b2c{}\u6b21,\u6bcf\u6b21\u6682\u505c20\u79d2,\u51713\u6b21 ", (Object)lockName, (Object)this.reTry);
                    if (this.reTry > 3) break block16;
                    ++this.reTry;
                    try {
                        Thread.sleep(20000L);
                        this.lock(lockName, expireSeconds);
                    }
                    catch (InterruptedException var10) {
                        var10.printStackTrace();
                        return false;
                    }
                }
                catch (RedisConnectionException var12) {
                    LOGGER.error("LockKey={},Redisson\u5206\u5e03\u5f0f\u9501[\u8fde\u63a5\u5f02\u5e38]{}", (Object)lockName, (Object)var12.getMessage());
                    LOGGER.error("LockKey={},\u6b63\u5728\u91cd\u8bd5\u7b2c{}\u6b21,\u6bcf\u6b21\u6682\u505c5\u79d2,\u51713\u6b21 ", (Object)lockName, (Object)this.reTry);
                    if (this.reTry > 3) break block16;
                    ++this.reTry;
                    try {
                        Thread.sleep(5000L);
                        this.lock(lockName, expireSeconds);
                    }
                    catch (InterruptedException var9) {
                        var9.printStackTrace();
                        return false;
                    }
                }
                catch (RedisTimeoutException var13) {
                    LOGGER.error("LockKey={},\u83b7\u53d6Redisson\u5206\u5e03\u5f0f\u9501[\u8d85\u65f6\u5f02\u5e38]{}", (Object)lockName, (Object)var13.getMessage());
                    LOGGER.error("LockKey={},\u6b63\u5728\u91cd\u8bd5\u7b2c{}\u6b21,\u6bcf\u6b21\u6682\u505c5\u79d2,\u51712\u6b21 ", (Object)lockName, (Object)this.reTry);
                    if (this.reTry > 2) break block16;
                    ++this.reTry;
                    try {
                        Thread.sleep(2000L);
                        this.lock(lockName, expireSeconds);
                    }
                    catch (InterruptedException var8) {
                        var8.printStackTrace();
                        return false;
                    }
                }
                catch (RedisException var14) {
                    LOGGER.error("LockKey={},Redisson\u5206\u5e03\u5f0f\u9501[\u5f02\u5e38]{}", (Object)lockName, (Object)var14.getMessage());
                    LOGGER.error("LockKey={},\u6b63\u5728\u91cd\u8bd5\u7b2c{}\u6b21,\u6bcf\u6b21\u6682\u505c5\u79d2,\u51712\u6b21 ", (Object)lockName, (Object)this.reTry);
                    if (this.reTry > 2) break block16;
                    ++this.reTry;
                    try {
                        Thread.sleep(2000L);
                        this.lock(lockName, expireSeconds);
                    }
                    catch (InterruptedException var7) {
                        var7.printStackTrace();
                        return false;
                    }
                }
                catch (Exception var15) {
                    LOGGER.error("LockKey={},Redisson\u5206\u5e03\u5f0f\u9501[\u5f02\u5e38]{}", (Object)lockName, (Object)var15.getMessage());
                    return false;
                }
            }
            return flag;
        }
        return flag;
    }

    public boolean lock(String lockName) {
        if (!lockName.isEmpty() && !"".equals(lockName)) {
            block16: {
                try {
                    RLock rLock = this.redissonManager.getRedisson().getLock(lockName);
                    if (rLock.isLocked()) {
                        LOGGER.info("\u52a0\u9501\u5931\u8d25,\u9501\u5df2\u5b58\u5728\uff0clockName=" + lockName);
                        return false;
                    }
                    rLock.lock();
                    LOGGER.info(" \u52a0\u9501\u6210\u529f! lockName=" + lockName);
                    return true;
                }
                catch (WriteRedisConnectionException var8) {
                    LOGGER.error("LockKey={},Redisson\u5206\u5e03\u5f0f\u9501[\u9501\u5199\u5165\u5f02\u5e38]{}", (Object)lockName, (Object)var8.getMessage());
                    LOGGER.error("LockKey={},\u6b63\u5728\u91cd\u8bd5\u7b2c{}\u6b21,\u6bcf\u6b21\u6682\u505c20\u79d2,\u51713\u6b21 ", (Object)lockName, (Object)this.reTry);
                    if (this.reTry > 3) break block16;
                    ++this.reTry;
                    try {
                        Thread.sleep(20000L);
                        this.lock(lockName);
                    }
                    catch (InterruptedException var7) {
                        var7.printStackTrace();
                        return false;
                    }
                }
                catch (RedisConnectionException var9) {
                    LOGGER.error("LockKey={},Redisson\u5206\u5e03\u5f0f\u9501[\u8fde\u63a5\u5f02\u5e38]{}", (Object)lockName, (Object)var9.getMessage());
                    LOGGER.error("LockKey={},\u6b63\u5728\u91cd\u8bd5\u7b2c{}\u6b21,\u6bcf\u6b21\u6682\u505c5\u79d2,\u51713\u6b21 ", (Object)lockName, (Object)this.reTry);
                    if (this.reTry > 3) break block16;
                    ++this.reTry;
                    try {
                        Thread.sleep(5000L);
                        this.lock(lockName);
                    }
                    catch (InterruptedException var6) {
                        var6.printStackTrace();
                        return false;
                    }
                }
                catch (RedisTimeoutException var10) {
                    LOGGER.error("LockKey={},\u83b7\u53d6Redisson\u5206\u5e03\u5f0f\u9501[\u8d85\u65f6\u5f02\u5e38]{}", (Object)lockName, (Object)var10.getMessage());
                    LOGGER.error("LockKey={},\u6b63\u5728\u91cd\u8bd5\u7b2c{}\u6b21,\u6bcf\u6b21\u6682\u505c5\u79d2,\u51712\u6b21 ", (Object)lockName, (Object)this.reTry);
                    if (this.reTry > 2) break block16;
                    ++this.reTry;
                    try {
                        Thread.sleep(2000L);
                        this.lock(lockName);
                    }
                    catch (InterruptedException var5) {
                        var5.printStackTrace();
                        return false;
                    }
                }
                catch (RedisException var11) {
                    LOGGER.error("LockKey={},Redisson\u5206\u5e03\u5f0f\u9501[\u5f02\u5e38]{}", (Object)lockName, (Object)var11.getMessage());
                    LOGGER.error("LockKey={},\u6b63\u5728\u91cd\u8bd5\u7b2c{}\u6b21,\u6bcf\u6b21\u6682\u505c5\u79d2,\u51712\u6b21 ", (Object)lockName, (Object)this.reTry);
                    if (this.reTry > 2) break block16;
                    ++this.reTry;
                    try {
                        Thread.sleep(2000L);
                        this.lock(lockName);
                    }
                    catch (InterruptedException var4) {
                        var4.printStackTrace();
                        return false;
                    }
                }
                catch (Exception var12) {
                    LOGGER.error("LockKey={},Redisson\u5206\u5e03\u5f0f\u9501[\u5f02\u5e38]{}", (Object)lockName, (Object)var12.getMessage());
                }
            }
            return false;
        }
        return false;
    }

    public boolean release(String lockName) {
        RLock lock = this.redissonManager.getRedisson().getLock(lockName);
        if (lock.isLocked()) {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
                RLock Lock2 = this.redissonManager.getRedisson().getLock(lockName);
                if (Lock2.isLocked()) {
                    Lock2.unlock();
                }
                LOGGER.info(" \u6210\u529f\u89e3\u9501! lockName=" + lockName);
                return true;
            }
            LOGGER.error("\u89e3\u9501\u5931\u8d25,\u53ef\u80fd\u4e0d\u662f\u540c\u4e00\u7ebf\u7a0b! lockName=" + lockName);
        }
        return false;
    }

    public Boolean expire(String lockName, Long leaseTime, TimeUnit timeUnit) {
        try {
            RLock lock = this.redissonManager.getRedisson().getLock(lockName);
            lock.lockInterruptibly(leaseTime.longValue(), timeUnit);
            return true;
        }
        catch (Exception var5) {
            LOGGER.error("-------->\u5ef6\u65f6\u64cd\u4f5c\u5931\u8d25!!! key[{}]", (Object)lockName);
            return false;
        }
    }

    public RBucket<Object> createCacheKey(String cacheKay) {
        return this.redissonManager.getRedisson().getBucket(cacheKay);
    }

    public long decr(String cacheKay) {
        RAtomicLong atomicVar = this.redissonManager.getRedisson().getAtomicLong(cacheKay);
        long decr_value = atomicVar.decrementAndGet();
        return decr_value;
    }

    public long setAtomicLong(String cacheKay, long initValue) {
        RAtomicLong atomicVar = this.redissonManager.getRedisson().getAtomicLong(cacheKay);
        atomicVar.set(initValue);
        long atomicValue = atomicVar.get();
        return atomicValue;
    }

    public long getAtomicLong(String cacheKay) {
        RAtomicLong atomicVar = this.redissonManager.getRedisson().getAtomicLong(cacheKay);
        long Atomic_value = atomicVar.get();
        return Atomic_value;
    }

    public long incr(String cacheKay) {
        RAtomicLong atomicVar = this.redissonManager.getRedisson().getAtomicLong(cacheKay);
        long decr_value = atomicVar.incrementAndGet();
        return decr_value;
    }

    public Boolean isLock(String lockName) {
        RLock lock = this.getLock(lockName, false);
        Boolean flag = lock.isLocked();
        return flag;
    }

    public boolean tryLock(String lockName, long waitSeconds, long expireSeconds) {
        boolean res = false;
        if (!lockName.isEmpty() && expireSeconds > 1L && waitSeconds > 1L) {
            RLock lock = this.redissonManager.getRedisson().getLock(lockName);
            try {
                res = lock.tryLock(waitSeconds, expireSeconds, TimeUnit.SECONDS);
            }
            catch (InterruptedException var9) {
                var9.printStackTrace();
            }
            if (res) {
                return res;
            }
            LOGGER.error("\u52a0\u9501\u5931\u8d25\uff0clockName=" + lockName);
            return false;
        }
        return res;
    }

    public boolean tryLock(String lockName, long waitSeconds) {
        boolean res = false;
        if (waitSeconds > 1L && !lockName.isEmpty()) {
            RLock lock = this.redissonManager.getRedisson().getLock(lockName);
            try {
                res = lock.tryLock(waitSeconds, TimeUnit.SECONDS);
            }
            catch (InterruptedException var7) {
                var7.printStackTrace();
            }
            if (res) {
                return res;
            }
            LOGGER.error("\u52a0\u9501\u5931\u8d25\uff0clockName=" + lockName);
            return false;
        }
        return res;
    }

    public boolean tryLock(String lockName) {
        if (lockName.isEmpty()) {
            return false;
        }
        RLock lock = this.redissonManager.getRedisson().getLock(lockName);
        boolean res = false;
        try {
            res = lock.tryLock();
        }
        catch (Exception var5) {
            var5.printStackTrace();
        }
        if (res) {
            return res;
        }
        LOGGER.error("\u52a0\u9501\u5931\u8d25\uff0clockName=" + lockName);
        return false;
    }

    public boolean ReadWriteLock(String lockName, long expireSeconds, ReadWriteEnum readWriteEnum) {
        RReadWriteLock rwlock = this.redissonManager.getRedisson().getReadWriteLock(lockName);
        boolean res = false;
        if (readWriteEnum.getValue().equals(ReadWriteEnum.READ.getValue())) {
            try {
                res = rwlock.readLock().tryLock(3L, expireSeconds, TimeUnit.SECONDS);
            }
            catch (InterruptedException var9) {
                var9.printStackTrace();
            }
        } else {
            if (!readWriteEnum.getValue().equals(ReadWriteEnum.WRITE.getValue())) {
                return false;
            }
            rwlock.writeLock().lock();
            rwlock.writeLock().lock(expireSeconds, TimeUnit.SECONDS);
            try {
                res = rwlock.writeLock().tryLock(3L, expireSeconds, TimeUnit.SECONDS);
            }
            catch (InterruptedException var8) {
                var8.printStackTrace();
            }
        }
        return res;
    }

    public Object put(String key, Object value) {
        if (value == null) {
            if (this.cacheNull) {
                this.redissonManager.getRedisson().getSetCache(key).add((Object)key, 300000L, TimeUnit.MILLISECONDS);
            }
        } else {
            this.rMap = this.redissonManager.getRedisson().getMapCache(key);
            this.rMap.put((Object)key, value);
        }
        return value;
    }

    private RLock getLock(String lockName, Boolean fairLock) {
        return fairLock != false ? this.redissonManager.getRedisson().getFairLock(lockName) : this.redissonManager.getRedisson().getLock(lockName);
    }

    public RedissonManager getRedissonManager() {
        return this.redissonManager;
    }

    public void setRedissonManager(RedissonManager redissonManager) {
        this.redissonManager = redissonManager;
    }
}

