/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.lock.redisson.config;

import com.xforceplus.lock.redisson.RedissonLock;
import com.xforceplus.lock.redisson.RedissonManager;
import com.xforceplus.lock.redisson.config.RedissonProperties;
import org.redisson.Redisson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"redisson.plugins.enable"}, matchIfMissing=true)
@ConditionalOnClass(value={Redisson.class})
@EnableConfigurationProperties(value={RedissonProperties.class})
public class RedissonAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedissonAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public RedissonLock redissonLock(RedissonManager redissonManager) {
        RedissonLock redissonLock = new RedissonLock();
        redissonLock.setRedissonManager(redissonManager);
        LOGGER.info("[RedissonLock]\u7ec4\u88c5\u5b8c\u6bd5");
        return redissonLock;
    }

    @Bean
    @ConditionalOnMissingBean
    public RedissonManager redissonManager(RedissonProperties redissonProperties) {
        RedissonManager redissonManager = new RedissonManager(redissonProperties);
        LOGGER.info("[RedissonManager]\u7ec4\u88c5\u5b8c\u6bd5,\u5f53\u524d\u8fde\u63a5\u65b9\u5f0f:" + redissonProperties.getType() + ",\u8fde\u63a5\u5730\u5740:" + redissonProperties.getAddress());
        return redissonManager;
    }
}

