/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.lock.redisson.strategy.impl;

import com.xforceplus.lock.constant.GlobalConstant;
import com.xforceplus.lock.redisson.config.RedissonProperties;
import com.xforceplus.lock.redisson.strategy.RedissonConfigStrategy;
import com.xforceplus.lock.redisson.strategy.impl.ClusterRedissonConfigStrategyImpl;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterslaveRedissonConfigStrategyImpl
implements RedissonConfigStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterRedissonConfigStrategyImpl.class);

    @Override
    public Config createRedissonConfig(RedissonProperties redissonProperties) {
        Config config = new Config();
        try {
            String address = redissonProperties.getAddress();
            String password = redissonProperties.getPassword();
            int database = redissonProperties.getDatabase();
            String[] addrTokens = address.split(",");
            String masterNodeAddr = addrTokens[0];
            config.useMasterSlaveServers().setMasterAddress(masterNodeAddr);
            if (StringUtils.isNotBlank((CharSequence)password)) {
                config.useMasterSlaveServers().setPassword(password);
            }
            config.useMasterSlaveServers().setDatabase(database);
            ArrayList<String> slaveList = new ArrayList<String>();
            String[] var9 = addrTokens;
            int var10 = addrTokens.length;
            for (int var11 = 0; var11 < var10; ++var11) {
                String addrToken = var9[var11];
                slaveList.add(GlobalConstant.REDIS_CONNECTION_PREFIX.getConstant_value() + addrToken);
            }
            slaveList.remove(0);
            config.useMasterSlaveServers().addSlaveAddress((String[])slaveList.toArray());
            LOGGER.info("\u521d\u59cb\u5316[MASTERSLAVE]\u65b9\u5f0fConfig,redisAddress:" + address);
        }
        catch (Exception var13) {
            LOGGER.error("MASTERSLAVE Redisson init error", (Throwable)var13);
            var13.printStackTrace();
        }
        return config;
    }
}

