/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.proxy;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.xforceplus.core.config.CommonConfig;
import com.xforceplus.lock.redisson.RedissonLock;
import com.xforceplus.proxy.AbstractProxyConfigHandler;
import com.xforceplus.utils.DateUtils;
import com.xxl.job.core.log.XxlJobLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RBucket;

public class KuaiProxyConfigHandler
extends AbstractProxyConfigHandler {
    public static String IP_PROXY_ADDRESS_KUAI = CommonConfig.IP_PROXY_ADDRESS_KUAI;
    public static String PROXY_STRATEGY = "\u5feb\u4ee3\u7406";

    public KuaiProxyConfigHandler(RedissonLock redissonLock) {
        super(redissonLock);
    }

    @Override
    public Map<String, String> doHandler(WebClient webClient, String accountKey) {
        XxlJobLogger.log((String)"\u6839\u636eDCS\u91c7\u96c6\u914d\u7f6e,\u4f7f\u7528\u5febIP\u4ee3\u7406........", (Object[])new Object[0]);
        try {
            Map<String, Map<String, String>> proxyConfigMap = this.setProxyConfig(webClient, accountKey);
            if (proxyConfigMap != null) {
                return proxyConfigMap.get("proxyConfig");
            }
        }
        catch (Exception e) {
            XxlJobLogger.log((String)"\u83b7\u53d6\u5febIP\u4ee3\u7406\u5931\u8d25\uff0cerrorMsg={}", (Object[])new Object[]{e.getMessage()});
        }
        if (null != this.next) {
            XxlJobLogger.log((String)"\u83b7\u53d6\u5febIP\u4ee3\u7406\u5931\u8d25,\u4f7f\u7528\u4e0b\u4e00\u79cd\u4ee3\u7406\u7b56\u7565...", (Object[])new Object[0]);
            return this.next.doHandler(webClient, accountKey);
        }
        return null;
    }

    @Override
    public Map<String, Map<String, String>> setProxyConfig(WebClient webClient, String accountKey) throws Exception {
        RBucket keyObject = this.redissonLock.getRedissonManager().getRedisson().getBucket("job:ipproxy:map_cache:" + accountKey);
        Page proxyPage = webClient.getPage(IP_PROXY_ADDRESS_KUAI);
        String proxyData = proxyPage.getWebResponse().getContentAsString();
        JSONObject jsonObject = JSONObject.parseObject((String)proxyData);
        XxlJobLogger.log((String)"\u83b7\u53d6\u4ee3\u7406IP\uff1a{}", (Object[])new Object[]{jsonObject.toJSONString()});
        JSONObject data = jsonObject.getJSONObject("data");
        Integer code = jsonObject.getInteger("code");
        if (code == 1) {
            XxlJobLogger.log((String)"\u5febIP\u4ee3\u7406\u5f53\u5929\u83b7\u53d6\u6b21\u6570\u5df2\u7528\u5b8c...", (Object[])new Object[0]);
            this.saveFileLog("{}    \u5febIP\u4ee3\u7406\u5f53\u5929\u83b7\u53d6\u6b21\u6570\u5df2\u7528\u5b8c", PROXY_STRATEGY);
            return null;
        }
        JSONArray array = data.getJSONArray("proxy_list");
        String proxyServer = array.get(0).toString().split(",")[0];
        String proxyIp = proxyServer.split(":")[0];
        String proxyPort = proxyServer.split(":")[1];
        long requestCount = this.redissonLock.incr("job:ipproxy:request_total_kuai");
        XxlJobLogger.log((String)"\u5171\u8bf7\u6c42\u5febIP\u4ee3\u7406 {}\u6b21\uff01", (Object[])new Object[]{requestCount});
        boolean validCheck = this.validateProxy(proxyIp, proxyPort);
        if (!validCheck) {
            XxlJobLogger.log((String)"\u5febIP\u4ee3\u7406\u3010{}:{}\u3011\u6709\u6548\u6027\u68c0\u67e5\u5931\u8d25...", (Object[])new Object[]{proxyIp, proxyPort});
            this.saveFileLog("{}    {}:{}   \u65e0\u6548", PROXY_STRATEGY, proxyIp, proxyPort);
            return null;
        }
        this.saveFileLog("{}    {}:{}   \u6210\u529f", PROXY_STRATEGY, proxyIp, proxyPort);
        long valid = this.redissonLock.incr("job:ipproxy:valid_total_kuai");
        XxlJobLogger.log((String)"\u5176\u4e2d\u3010\u5febIP\u6709\u6548\u3011IP\u4ee3\u7406{}\u4e2a\uff01", (Object[])new Object[]{valid});
        HashMap<String, Map<String, String>> proxyConfigMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("proxyIp", proxyIp);
        map.put("proxyPort", proxyPort);
        map.put("createTime", DateUtils.getNowTime());
        map.put("expire", "150");
        proxyConfigMap.put("proxyConfig", map);
        keyObject.delete();
        keyObject.set(proxyConfigMap);
        keyObject.expire(2L, TimeUnit.HOURS);
        return proxyConfigMap;
    }
}

