/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.proxy;

import com.gargoylesoftware.htmlunit.WebClient;
import com.xforceplus.core.config.CommonConfig;
import com.xforceplus.lock.redisson.RedissonLock;
import com.xforceplus.proxy.AbstractProxyConfigHandler;
import com.xforceplus.utils.DateUtils;
import com.xxl.job.core.log.XxlJobLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RBucket;

public class TencentSecondProxyConfigHandler
extends AbstractProxyConfigHandler {
    public static String IP_PROXY_ADDRESS_TENCENT_SECOND = CommonConfig.IP_PROXY_ADDRESS_TENCENT_SECOND;
    public static String PROXY_STRATEGY = "\u817e\u8baf2";

    public TencentSecondProxyConfigHandler(RedissonLock redissonLock) {
        super(redissonLock);
    }

    @Override
    public Map<String, String> doHandler(WebClient webClient, String accountKey) {
        XxlJobLogger.log((String)"\u6839\u636eDCS\u91c7\u96c6\u914d\u7f6e,\u4f7f\u7528\u516c\u53f8(\u817e\u8baf2)IP\u4ee3\u7406........", (Object[])new Object[0]);
        try {
            Map<String, Map<String, String>> proxyConfigMap = this.setProxyConfig(webClient, accountKey);
            if (proxyConfigMap != null) {
                return proxyConfigMap.get("proxyConfig");
            }
        }
        catch (Exception e) {
            XxlJobLogger.log((String)"\u4f7f\u7528\u516c\u53f8\u4ee3\u7406IP\u5931\u8d25\uff0cerrorMsg={}", (Object[])new Object[]{e.getMessage()});
        }
        if (null != this.next) {
            XxlJobLogger.log((String)"\u83b7\u53d6\u516c\u53f8(\u817e\u8baf2)IP\u4ee3\u7406\u5931\u8d25,\u4f7f\u7528\u4e0b\u4e00\u79cd\u4ee3\u7406\u7b56\u7565...", (Object[])new Object[0]);
            return this.next.doHandler(webClient, accountKey);
        }
        return null;
    }

    @Override
    public Map<String, Map<String, String>> setProxyConfig(WebClient webClient, String accountKey) throws Exception {
        String proxyIp = IP_PROXY_ADDRESS_TENCENT_SECOND.split(":")[0];
        String proxyPort = IP_PROXY_ADDRESS_TENCENT_SECOND.split(":")[1];
        XxlJobLogger.log((String)"\u4f7f\u7528\u516c\u53f8\u4ee3\u7406IP\u3010{}:{}\u3011", (Object[])new Object[]{proxyIp, proxyPort});
        RBucket keyObject = this.redissonLock.getRedissonManager().getRedisson().getBucket("job:ipproxy:map_cache:" + accountKey);
        boolean validCheck = this.validateProxy(proxyIp, proxyPort);
        if (!validCheck) {
            XxlJobLogger.log((String)"\u4f7f\u7528\u516c\u53f8\u4ee3\u7406IP\u3010{}:{}\u3011\u6709\u6548\u6027\u68c0\u67e5\u5931\u8d25...", (Object[])new Object[]{proxyIp, proxyPort});
            this.saveFileLog("{}    {}:{}   \u65e0\u6548", PROXY_STRATEGY, proxyIp, proxyPort);
            return null;
        }
        this.saveFileLog("{}    {}:{}   \u6210\u529f", PROXY_STRATEGY, proxyIp, proxyPort);
        HashMap<String, Map<String, String>> proxyConfigMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("proxyIp", proxyIp);
        map.put("proxyPort", proxyPort);
        map.put("createTime", DateUtils.getNowTime());
        map.put("expire", "180");
        proxyConfigMap.put("proxyConfig", map);
        keyObject.delete();
        keyObject.set(proxyConfigMap);
        keyObject.expire(3L, TimeUnit.HOURS);
        return proxyConfigMap;
    }
}

