/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.service.handler;

import com.xforceplus.core.annotation.DcsJobHandler;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class DcsHandlerReporter {
    private static final Logger log = LoggerFactory.getLogger(DcsHandlerReporter.class);
    @Resource
    private ApplicationContext applicationContext;
    private List<DcsJobHandler> handlerList = new ArrayList<DcsJobHandler>();

    @PostConstruct
    public void report() {
        Map serviceBeanMap = this.applicationContext.getBeansWithAnnotation(DcsJobHandler.class);
        if (serviceBeanMap.size() == 0) {
            log.error("\u672a\u626b\u63cf\u5230\u4efb\u52a1");
            return;
        }
        for (Map.Entry entry : serviceBeanMap.entrySet()) {
            Object bean = entry.getValue();
            if (!(bean instanceof IJobHandler)) continue;
            DcsJobHandler dcsJobHandler = bean.getClass().getAnnotation(DcsJobHandler.class);
            JobHandler jobHandler = bean.getClass().getAnnotation(JobHandler.class);
            if (dcsJobHandler == null || jobHandler == null) continue;
            this.handlerList.add(dcsJobHandler);
            log.info("\u626b\u63cf\u5230DcsJobHandler {}, \u540d\u79f0: {}, \u5355\u636e\u7c7b\u578b: {}", new Object[]{jobHandler.value(), dcsJobHandler.value(), dcsJobHandler.billType()});
        }
    }

    public List<DcsJobHandler> getHandlerList() {
        return this.handlerList;
    }
}

