/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.service.oss;

import com.aliyun.oss.OSS;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.core.resolve.ResolveTask;
import com.xforceplus.utils.MD5;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;

@Service
public class OssService {
    private static final Logger log = LoggerFactory.getLogger(OssService.class);
    @Value(value="${oss.bucket:eccp-prod}")
    private String bucket;
    @Value(value="${oss.region:oss-cn-hangzhou.aliyuncs.com}")
    private String region;
    @Value(value="${spring.profiles.active}")
    private String env;
    @Resource
    private OSS ossClient;
    private static long times = 7776000000L;

    public String getResolvePath(AccountTemplateDO account, String fileName) {
        String dir = String.format("rpa/eccpdcs/%s/RPACapturedData/%s/%s/%s/%s", this.env, account.getRetailKey(), account.getBillsType(), this.getAccountMd5(account.getAccountName()), new SimpleDateFormat("yyyyMMdd").format(new Date()));
        return String.format("%s/%s", dir, fileName);
    }

    @Retryable(value={Throwable.class}, maxAttempts=5, backoff=@Backoff(delay=5000L))
    public String uploadResolveResult(String json, ResolveTask task) {
        String dir = String.format("rpa/eccpdcs/%s/RPACapturedData/%s/%s/%s/%s", this.env, task.getRetailKey(), task.getJobBillType().getBillType().toString(), this.getAccountMd5(task.getAccountName()), new SimpleDateFormat("yyyyMMdd").format(new Date()));
        String name = String.format("%s_Capture_data_%s.json", UUID.randomUUID(), new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        String key = String.format("%s/%s", dir, name);
        ObjectMetadata objectMetadata = new ObjectMetadata();
        PutObjectRequest request = new PutObjectRequest(this.bucket, key, (InputStream)new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)), objectMetadata);
        request.addParameter("supplierTenantCode", task.getTenantCode());
        PutObjectResult result = this.ossClient.putObject(request);
        log.info("\u4e0a\u4f20\u89e3\u6790\u7ed3\u679c\u5b8c\u6bd5 {}", (Object)result.getETag());
        XxlJobLogger.log((String)"\u4e0a\u4f20\u89e3\u6790\u7ed3\u679c\u5b8c\u6bd5 {}", (Object[])new Object[]{result.getETag()});
        return this.getUrl(key);
    }

    public String getUploadPdf(AccountTemplateDO account, String fileName) {
        String dir = String.format("rpa/eccpdcs/%s/RPACapturedData/%s/%s/%s/%s", this.env, account.getRetailKey(), account.getBillsType(), this.getAccountMd5(account.getAccountName()), new SimpleDateFormat("yyyyMMdd").format(new Date()));
        return String.format("%s/%s", dir, fileName);
    }

    @Retryable(value={Throwable.class}, maxAttempts=5, backoff=@Backoff(delay=5000L))
    public String uploadPdf(ResolveTask task) {
        String dir = String.format("rpa/eccpdcs/%s/RPACapturedData/%s/%s/%s/%s", this.env, task.getRetailKey(), task.getJobBillType().getBillType().toString(), this.getAccountMd5(task.getAccountName()), new SimpleDateFormat("yyyyMMdd").format(new Date()));
        String name = String.format("%s_Original_Document_%s_%s.pdf", UUID.randomUUID(), task.getOrderNo(), new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        String key = String.format("%s/%s", dir, name);
        PutObjectRequest request = new PutObjectRequest(this.bucket, key, new File(task.getFilePath()));
        PutObjectResult result = this.ossClient.putObject(request);
        log.info("\u4e0a\u4f20\u89e3\u6790\u7ed3\u679c\u5b8c\u6bd5 {}", (Object)result.getETag());
        XxlJobLogger.log((String)"\u4e0a\u4f20\u89e3\u6790\u7ed3\u679c\u5b8c\u6bd5 {}", (Object[])new Object[]{result.getETag()});
        return this.getUrl(key);
    }

    public String getUploadRawFilePath(AccountTemplateDO account, String fileName) {
        String dir = String.format("%s/%s/%s/%s/%s/OriginalFile", account.getProjectKey(), account.getRetailKey(), account.getBillsType(), this.getAccountMd5(account.getAccountName()), new SimpleDateFormat("yyyyMMdd").format(new Date()));
        return String.format("eccp-dcs-%s/raw-files/%s", this.env, String.format("%s/%s", dir, fileName));
    }

    @Retryable(value={Throwable.class}, maxAttempts=5, backoff=@Backoff(delay=5000L))
    public String uploadPdfRawFile(String filePath, AccountTemplateDO account) {
        String dir = String.format("rpa/eccpdcs/%s/RPACapturedData/%s/%s/%s/%s", this.env, account.getRetailKey(), StringUtils.toRootUpperCase((String)account.getBillsType()), this.getAccountMd5(account.getAccountName()), new SimpleDateFormat("yyyyMMdd").format(new Date()));
        String fileType = filePath.substring(filePath.lastIndexOf("."));
        String name = String.format("%s%s_%s_%s_%s_Capture_data_%s", "print", account.getProjectKey(), account.getRetailKey(), account.getOrderNo(), new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()), fileType);
        String key = String.format("%s/%s", dir, name);
        log.info("\u4e0a\u4f20pdf\u539f\u59cb\u6587\u4ef6 {}", (Object)key);
        XxlJobLogger.log((String)"\u4e0a\u4f20pdf\u539f\u59cb\u6587\u4ef6 {}", (Object[])new Object[]{key});
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, key, new File(filePath));
        PutObjectResult putResult = this.ossClient.putObject(putObjectRequest);
        log.info("\u4e0a\u4f20pdf\u539f\u59cb\u6587\u4ef6\u5b8c\u6bd5 {}", (Object)putResult.getETag());
        XxlJobLogger.log((String)"\u4e0a\u4f20pdf\u539f\u59cb\u6587\u4ef6\u5b8c\u6bd5 {}", (Object[])new Object[]{putResult.getETag()});
        return this.getUrl(key);
    }

    @Retryable(value={Throwable.class}, maxAttempts=5, backoff=@Backoff(delay=5000L))
    public String uploadRawFile(String filePath, AccountTemplateDO account) {
        String dir = String.format("%s/%s/%s/%s/%s/OriginalFile", account.getProjectKey(), account.getRetailKey(), account.getBillsType(), this.getAccountMd5(account.getAccountName()), new SimpleDateFormat("yyyyMMdd").format(new Date()));
        String fileName = "";
        if (filePath.contains("/")) {
            String[] split = filePath.split("/");
            fileName = split[split.length - 1];
        } else {
            String[] split = filePath.split(File.separator);
            fileName = split[split.length - 1];
        }
        return this.uploadRawFile(filePath, String.format("%s/%s", dir, fileName));
    }

    public String uploadRawFile(String filePath, String key) {
        key = String.format("eccp-dcs-%s/raw-files/%s", this.env, key);
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, key, new File(filePath));
        PutObjectResult putResult = this.ossClient.putObject(putObjectRequest);
        log.info("\u4e0a\u4f20\u539f\u59cb\u6587\u4ef6\u5b8c\u6bd5 {}", (Object)putResult.getETag());
        XxlJobLogger.log((String)"\u4e0a\u4f20\u539f\u59cb\u6587\u4ef6\u5b8c\u6bd5 {}", (Object[])new Object[]{putResult.getETag()});
        return this.getUrl(key);
    }

    private String getUrl(String key) {
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(this.bucket, key);
        request.setExpiration(new Date(System.currentTimeMillis() + times));
        URL url = this.ossClient.generatePresignedUrl(request);
        return url.toString();
    }

    private String getAccountMd5(String account) {
        return MD5.encrypt(account).toUpperCase();
    }

    public String uploadDiyFile(String key, InputStream input) {
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, key, input);
        PutObjectResult putResult = this.ossClient.putObject(putObjectRequest);
        log.info("\u4e0a\u4f20diy\u539f\u59cb\u6587\u4ef6\u5b8c\u6bd5 {}", (Object)putResult.getETag());
        XxlJobLogger.log((String)"\u4e0a\u4f20\u539f\u59cb\u6587\u4ef6\u5b8c\u6bd5 {}", (Object[])new Object[]{putResult.getETag()});
        return this.getUrl(key);
    }

    public OSSObject getOssObject(String ossKey) {
        try {
            return this.ossClient.getObject(this.bucket, ossKey);
        }
        catch (Exception e) {
            log.error(ErrorUtil.getStackMsg((Exception)e));
            return null;
        }
    }
}

