/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.utils.JsonUtils;
import com.xxl.job.core.log.XxlJobLogger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static Logger logger = LoggerFactory.getLogger(DateUtil.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static ThreadLocal<Map<String, DateFormat>> dateFormatThreadLocal = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DateFormat getDateFormat(String pattern) {
        if (pattern != null && pattern.trim().length() != 0) {
            Map<String, DateFormat> dateFormatMap = dateFormatThreadLocal.get();
            if (dateFormatMap != null && dateFormatMap.containsKey(pattern)) {
                return dateFormatMap.get(pattern);
            }
            ThreadLocal<Map<String, DateFormat>> threadLocal = dateFormatThreadLocal;
            synchronized (threadLocal) {
                if (dateFormatMap == null) {
                    dateFormatMap = new HashMap<String, DateFormat>();
                }
                dateFormatMap.put(pattern, new SimpleDateFormat(pattern));
                dateFormatThreadLocal.set(dateFormatMap);
            }
            return dateFormatMap.get(pattern);
        }
        throw new IllegalArgumentException("pattern cannot be empty.");
    }

    public static String formatDate(Date date) {
        return DateUtil.format(date, DATE_FORMAT);
    }

    public static String formatDateTime(Date date) {
        return DateUtil.format(date, DATETIME_FORMAT);
    }

    public static String format(Date date, String patten) {
        return DateUtil.getDateFormat(patten).format(date);
    }

    public static Date parseDate(String dateString) {
        return DateUtil.parse(dateString, DATE_FORMAT);
    }

    public static Date parseDateTime(String dateString) {
        return DateUtil.parse(dateString, DATETIME_FORMAT);
    }

    public static Date parse(String dateString, String pattern) {
        try {
            Date date = DateUtil.getDateFormat(pattern).parse(dateString);
            return date;
        }
        catch (Exception var3) {
            logger.warn("parse date error, dateString = {}, pattern={}; errorMsg = ", new Object[]{dateString, pattern, var3.getMessage()});
            return null;
        }
    }

    public static Date addDays(Date date, int amount) {
        return DateUtil.add(date, 5, amount);
    }

    public static Date addYears(Date date, int amount) {
        return DateUtil.add(date, 1, amount);
    }

    public static Date addMonths(Date date, int amount) {
        return DateUtil.add(date, 2, amount);
    }

    private static Date add(Date date, int calendarField, int amount) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }

    public static void main(String[] args) {
        AccountTemplateDO account = new AccountTemplateDO();
        account.setDefaultDate("{T-5, T-5}");
        System.out.println(JsonUtils.toString(DateUtil.getDefaultArr(account)));
    }

    public static String dateToStamp(String s) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATETIME_FORMAT);
        Date date = null;
        try {
            date = simpleDateFormat.parse(s);
        }
        catch (ParseException var6) {
            var6.printStackTrace();
        }
        long ts = date.getTime() / 1000L;
        String res = String.valueOf(ts);
        return res;
    }

    public static String sysStamp() {
        Date currentLocalDate = new Date();
        return String.format("%tF %tT", currentLocalDate, currentLocalDate);
    }

    public static String calDate(String value) {
        if (StringUtils.isBlank((CharSequence)value) || !value.startsWith("{") || !value.endsWith("}")) {
            return null;
        }
        if ((value = value.replace("\uff0c", ",")).contains("MTD")) {
            String newvalue = value.replace("{", "").replace("}", "").replaceAll("MTD", "").replaceAll(" ", "");
            if (StringUtils.isBlank((CharSequence)newvalue)) {
                return DateFormatUtils.format((Date)new Date(), (String)DATE_FORMAT);
            }
            if (newvalue.contains(",")) {
                String[] temps = newvalue.split(",");
                if (temps.length != 2) {
                    XxlJobLogger.log((String)("date param exception >>>>>>>>>>>>>>>>>>>> " + value), (Object[])new Object[0]);
                    return null;
                }
                String[] tmps1 = temps[0].split("-");
                Object[] tmps2 = temps[1].split("-");
                if (tmps2.length == 2) {
                    tmps2 = (String[])ArrayUtils.add((Object[])tmps2, (Object)String.valueOf(Calendar.getInstance().get(5)));
                }
                if (tmps1.length != 3 || tmps2.length != 3) {
                    XxlJobLogger.log((String)("date param exception >>>>>>>>>>>>>>>>>>>> " + value), (Object[])new Object[0]);
                    return null;
                }
                String start1 = tmps1[1];
                String start2 = tmps1[2];
                Calendar startcal = Calendar.getInstance();
                startcal.add(2, -Integer.parseInt(start1.trim()));
                startcal.set(5, Integer.parseInt(start2.trim()));
                startcal.set(11, 0);
                startcal.set(12, 0);
                startcal.set(13, 0);
                startcal.set(14, 0);
                Object start3 = tmps2[1];
                Object start4 = tmps2[2];
                Calendar endCal = Calendar.getInstance();
                endCal.add(2, -Integer.parseInt(((String)start3).trim()));
                endCal.set(5, Integer.parseInt((String)start4));
                endCal.set(11, 0);
                endCal.set(12, 0);
                endCal.set(13, 0);
                endCal.set(14, 0);
                newvalue = "";
                while (startcal.getTimeInMillis() <= endCal.getTimeInMillis()) {
                    if (StringUtils.isNotBlank((CharSequence)newvalue)) {
                        newvalue = newvalue + "|";
                    }
                    newvalue = newvalue + DateFormatUtils.format((Calendar)startcal, (String)DATE_FORMAT);
                    startcal.add(5, 1);
                }
                return newvalue;
            }
            Calendar calendar = Calendar.getInstance();
            int num = StringUtils.isBlank((CharSequence)newvalue) ? 0 : Integer.parseInt(newvalue.trim());
            calendar.add(2, num);
            int actualMinimum = calendar.getActualMinimum(5);
            int actualMaximum = calendar.getActualMaximum(5);
            if (num == 0) {
                actualMaximum = calendar.get(5);
            }
            newvalue = "";
            for (int i = actualMinimum; i <= actualMaximum; ++i) {
                if (StringUtils.isNotBlank((CharSequence)newvalue)) {
                    newvalue = newvalue + "|";
                }
                calendar.set(5, i);
                newvalue = newvalue + DateFormatUtils.format((Calendar)calendar, (String)DATE_FORMAT);
            }
            return newvalue;
        }
        if (value.contains("MTF")) {
            int day;
            String newvalue = value.replace("{", "").replace("}", "").replaceAll("MTF", "").replaceAll(" ", "");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            int monthDay = calendar.get(5);
            if (monthDay == 1) {
                return DateFormatUtils.format((Date)new Date(), (String)DATE_FORMAT);
            }
            int n = day = StringUtils.isEmpty((CharSequence)newvalue) ? 0 : Integer.parseInt(newvalue);
            if (monthDay - Math.abs(day) <= 1) {
                calendar.set(5, 1);
                return DateFormatUtils.format((Calendar)calendar, (String)DATE_FORMAT);
            }
            calendar.add(5, day);
            monthDay = calendar.get(5);
            int actualMinimum = calendar.getActualMinimum(5);
            Calendar cal = Calendar.getInstance();
            cal.set(5, 1);
            newvalue = DateFormatUtils.format((Calendar)cal, (String)DATE_FORMAT);
            for (int i = actualMinimum; i < monthDay; ++i) {
                if (StringUtils.isNotBlank((CharSequence)newvalue)) {
                    newvalue = newvalue + "|";
                }
                cal.add(5, 1);
                newvalue = newvalue + DateFormatUtils.format((Calendar)cal, (String)DATE_FORMAT);
            }
            return newvalue;
        }
        if (value.contains("T") || value.contains("M")) {
            String newvalue;
            int type = 5;
            if (value.contains("M")) {
                type = 2;
            }
            if (StringUtils.isBlank((CharSequence)(newvalue = value.replace("{", "").replace("}", "").replaceAll("T", "").replaceAll("M", "").replaceAll(" ", "")))) {
                return DateFormatUtils.format((Date)new Date(), (String)DATE_FORMAT);
            }
            if (newvalue.endsWith(",")) {
                newvalue = newvalue + "0";
            }
            if (newvalue.startsWith(",")) {
                newvalue = "0" + newvalue;
            }
            if (newvalue.contains(",")) {
                String[] temps = newvalue.split(",");
                if (temps.length != 2) {
                    XxlJobLogger.log((String)("date param exception >>>>>>>>>>>>>>>>>>>> " + value), (Object[])new Object[0]);
                    return value;
                }
                int day1 = 0;
                int day2 = 0;
                try {
                    if (StringUtils.isNotBlank((CharSequence)temps[0])) {
                        day1 = Integer.parseInt(temps[0]);
                    }
                    if (StringUtils.isNotBlank((CharSequence)temps[1])) {
                        day2 = Integer.parseInt(temps[1]);
                    }
                    if (day1 > day2) {
                        XxlJobLogger.log((String)("date param exception >>>>>>>>>>>>>>>>>>>> " + value), (Object[])new Object[0]);
                        return value;
                    }
                    newvalue = "";
                    for (int i = day1; i <= day2; ++i) {
                        if (StringUtils.isNotBlank((CharSequence)newvalue)) {
                            newvalue = newvalue + "|";
                        }
                        Calendar calendar = Calendar.getInstance();
                        calendar.add(type, i);
                        newvalue = newvalue + DateFormatUtils.format((Calendar)calendar, (String)DATE_FORMAT);
                    }
                    XxlJobLogger.log((String)("date value:" + newvalue), (Object[])new Object[0]);
                    return newvalue;
                }
                catch (NumberFormatException e) {
                    XxlJobLogger.log((String)("date param exception >>>>>>>>>>>>>>>>>>>> " + value), (Object[])new Object[]{e});
                }
            } else {
                try {
                    int day = Integer.parseInt(newvalue);
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(type, day);
                    newvalue = DateFormatUtils.format((Calendar)calendar, (String)DATE_FORMAT);
                    XxlJobLogger.log((String)("date value:" + newvalue), (Object[])new Object[0]);
                    return newvalue;
                }
                catch (NumberFormatException e) {
                    XxlJobLogger.log((String)("date param exception >>>>>>>>>>>>>>>>>>>> " + value), (Object[])new Object[]{e});
                }
            }
        }
        return null;
    }

    public static String[] getDateArr(AccountTemplateDO account) {
        String[] dateArr = DateUtil.getDefaultArr(account);
        String startDate = dateArr[0];
        String endDate = dateArr[dateArr.length - 1];
        return new String[]{startDate, endDate};
    }

    public static String[] getDefaultArr(AccountTemplateDO account) {
        String defaultDate = account.getDefaultDate();
        defaultDate = DateUtil.calDate(defaultDate);
        assert (defaultDate != null);
        return defaultDate.split("\\|");
    }

    public static String converDatePath(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return path;
        }
        Pattern pattern = Pattern.compile(".+(\\{T([-\\+\\d]*)})");
        Matcher matcher = pattern.matcher(path);
        if (matcher.find()) {
            String string = matcher.group(1);
            String day = matcher.group(2);
            LocalDateTime localDateTime = LocalDateTime.now();
            if (StringUtils.isNotBlank((CharSequence)day)) {
                localDateTime = localDateTime.plusDays(Long.parseLong(day));
            }
            String date = localDateTime.format(DateTimeFormatter.ofPattern(DATE_FORMAT));
            path = path.replace(string, date);
        }
        return path;
    }
}

