/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.xforceplus.utils.StringLib;
import com.xforceplus.utils.bean.CnvBooleanDeserializer;
import com.xforceplus.utils.bean.CnvBooleanSerializer;
import com.xforceplus.utils.bean.CnvDateDeserializer;
import com.xforceplus.utils.bean.CnvDateSerializer;
import com.xforceplus.utils.bean.CnvNumberDeserializer;
import com.xforceplus.utils.bean.CnvNumberSerializer;
import com.xforceplus.utils.jsonfilter.JsonPropertyFilter1;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.json.JSONObject;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonLib {
    private static final ObjectMapper mapper = JsonLib.getInstance();
    private static Logger logger = LoggerFactory.getLogger(JsonLib.class);

    public static ObjectMapper getInstance() {
        ObjectMapper filterMapper = new ObjectMapper();
        filterMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        filterMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        filterMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        filterMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        filterMapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        filterMapper.configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true);
        SimpleModule simpleModule = new SimpleModule("SimpleModule");
        simpleModule.addSerializer((JsonSerializer)new CnvDateSerializer());
        simpleModule.addSerializer(Number.class, (JsonSerializer)new CnvNumberSerializer());
        simpleModule.addSerializer(Boolean.class, (JsonSerializer)new CnvBooleanSerializer());
        simpleModule.addDeserializer(Date.class, (JsonDeserializer)new CnvDateDeserializer());
        simpleModule.addDeserializer(Boolean.class, new CnvBooleanDeserializer());
        simpleModule.addDeserializer(Float.class, (JsonDeserializer)new CnvNumberDeserializer());
        filterMapper.registerModule((Module)simpleModule);
        return filterMapper;
    }

    public static String toString(Object object) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            logger.warn("write to json string error:" + object, (Throwable)e);
            return null;
        }
    }

    public static JsonNode xmlToJson(String xml) {
        JSONObject jObject = XML.toJSONObject((String)xml);
        return JsonLib.parseJSON(jObject.toString());
    }

    public static JsonNode toJSON(Object object) {
        return (JsonNode)mapper.convertValue(object, JsonNode.class);
    }

    public static JsonNode toJSON(Object object, Class clazz, String ... propertyArray) {
        if (propertyArray == null || propertyArray.length == 0) {
            return JsonLib.toJSON(object);
        }
        if (object != null) {
            ObjectMapper filterMapper = JsonLib.getInstance();
            filterMapper.addMixIn(clazz, JsonPropertyFilter1.class);
            SimpleFilterProvider filterProvider = new SimpleFilterProvider().addFilter("Filter1", SimpleBeanPropertyFilter.filterOutAllExcept((String[])propertyArray));
            filterMapper.setFilterProvider((FilterProvider)filterProvider);
            return (JsonNode)filterMapper.convertValue(object, JsonNode.class);
        }
        return JsonLib.createObjNode();
    }

    public static JsonNode parseJSON(String str) {
        ObjectNode node = null;
        JsonFactory factory = mapper.getFactory();
        try {
            JsonParser jp = factory.createParser(str);
            node = (JsonNode)mapper.readTree(jp);
        }
        catch (Exception e) {
            e.printStackTrace();
            node = mapper.createObjectNode();
        }
        return node;
    }

    public static ObjectNode createObjNode() {
        return mapper.createObjectNode();
    }

    public static ArrayNode createArrNode() {
        return mapper.createArrayNode();
    }

    public static <T> List<T> parseArray(String jsonString, Class<T> clazz) {
        return JsonLib.parseArray(JsonLib.parseJSON(jsonString), clazz);
    }

    public static <T> List<T> parseArray(JsonNode node, Class<T> clazz) {
        if (node == null) {
            return null;
        }
        return (List)mapper.convertValue((Object)node, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, clazz));
    }

    public static <T> Map<String, T> parseMap(JsonNode node) {
        if (node != null) {
            return JsonLib.parseMap(node.toString());
        }
        return null;
    }

    public static <T> Map<String, T> parseMap(String json) {
        if (StringLib.isNotEmpty((CharSequence)json)) {
            try {
                return (Map)mapper.readValue(json, Map.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static <T> T parseJSON(String jsonString, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        try {
            return (T)mapper.readValue(jsonString, clazz);
        }
        catch (IOException e) {
            logger.warn("parse json string error:" + jsonString, (Throwable)e);
            return null;
        }
    }

    public static <T> T parseJSON(JsonNode node, Class<T> clazz) {
        if (node == null) {
            return null;
        }
        return (T)mapper.convertValue((Object)node, clazz);
    }

    public static <T> T parseJSON(String jsonString, TypeReference<T> reference) {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        try {
            return (T)mapper.readValue(jsonString, reference);
        }
        catch (IOException e) {
            logger.warn("parse json string error:" + jsonString, (Throwable)e);
            return null;
        }
    }

    public static <T> T parseJSON(JsonNode node, TypeReference<T> reference) {
        if (node == null) {
            return null;
        }
        return (T)mapper.convertValue((Object)node, reference);
    }

    public static <T> T parseJSON(String jsonString, JavaType javaType) {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        try {
            return (T)mapper.readValue(jsonString, javaType);
        }
        catch (IOException e) {
            logger.warn("parse json string error:" + jsonString, (Throwable)e);
            return null;
        }
    }

    public static Long getLong(JsonNode node, String key) {
        if (!node.has(key)) {
            return 0L;
        }
        JsonNode jNode = node.get(key);
        if (jNode != null && NumberUtils.isCreatable((String)jNode.asText())) {
            return StringLib.toLong(jNode.asText());
        }
        return 0L;
    }

    public static Boolean getBoolean(JsonNode node, String key) {
        if (!node.has(key)) {
            return false;
        }
        JsonNode jNode = node.get(key);
        if ("true".equals(jNode.asText())) {
            return true;
        }
        return false;
    }

    public static Integer getInteger(JsonNode node, String key) {
        if (!node.has(key)) {
            return 0;
        }
        JsonNode jNode = node.get(key);
        if (jNode != null && NumberUtils.isCreatable((String)jNode.asText())) {
            return StringLib.toInteger(jNode.asText());
        }
        return 0;
    }

    public static Double getDouble(JsonNode node, String key) {
        if (!node.has(key)) {
            return 0.0;
        }
        JsonNode jNode = node.get(key);
        if (jNode != null && NumberUtils.isCreatable((String)jNode.asText())) {
            return StringLib.toDouble(jNode.asText());
        }
        return 0.0;
    }

    public static Float getFloat(JsonNode node, String key) {
        if (!node.has(key)) {
            return Float.valueOf(0.0f);
        }
        JsonNode jNode = node.get(key);
        if (jNode != null && NumberUtils.isCreatable((String)jNode.asText())) {
            return StringLib.toFloat(jNode.asText());
        }
        return Float.valueOf(0.0f);
    }

    public static ArrayNode getArrayNode(JsonNode node, String key) {
        if (!node.has(key)) {
            return JsonLib.createArrNode();
        }
        JsonNode jNode = node.get(key);
        if (jNode != null && jNode.isArray()) {
            return (ArrayNode)jNode;
        }
        return JsonLib.createArrNode();
    }

    public static ObjectNode getObjectNode(JsonNode node, String key) {
        if (!node.has(key)) {
            return JsonLib.createObjNode();
        }
        JsonNode jNode = node.get(key);
        if (jNode != null && jNode.isObject()) {
            return (ObjectNode)jNode;
        }
        return JsonLib.createObjNode();
    }

    public static String getString(JsonNode node, String key) {
        if (!node.has(key)) {
            return "";
        }
        JsonNode jNode = node.get(key);
        if (jNode != null) {
            return jNode.asText();
        }
        return "";
    }
}

