/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.alibaba.fastjson.JSONObject;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.core.config.CommonConfig;
import com.xforceplus.core.enums.CharSetEnum;
import com.xforceplus.core.enums.SupplierConstantEnum;
import com.xforceplus.service.oss.OssService;
import com.xforceplus.utils.FileUtil;
import com.xforceplus.utils.SpringContext;
import com.xforceplus.utils.html2pdf.generator.HtmlGenerator;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.xhtmlrenderer.pdf.ITextFontResolver;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class PDFPrintUtil {
    private static final Logger log = LoggerFactory.getLogger(PDFPrintUtil.class);
    private static final OssService ossService = SpringContext.getBean(OssService.class);
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final String PDF_PRINT_URL = CommonConfig.PDF_PRINT_URL;
    private static final String EXCEL2PDF_URL = CommonConfig.EXCEL2PDF_URL;

    public static boolean savePDF(String pageUrl, Map<String, String> headerMap, HttpMethod httpMethod, Map<String, String> cookieMap, Map<String, String> paramMap, AccountTemplateDO account, String orderId) {
        Boolean printStatus = account.getPrintStatus();
        String pdfFileName = FileUtil.getPDFFileName(account, orderId);
        String pdfFilePath = FileUtil.getPDFFilePath(account);
        String projectKey = account.getProjectKey();
        if (Objects.equals(SupplierConstantEnum.HUAMER.getKey(), projectKey)) {
            String area = "";
            if (StringUtils.isNotBlank((CharSequence)account.getArea())) {
                area = account.getArea() + "-";
            }
            pdfFileName = area + account.getStoreCode() + "_" + orderId;
        }
        if (Objects.equals("HTML", account.getType())) {
            pdfFileName = pdfFilePath + "/" + pdfFileName + ".pdf";
        }
        OkHttpClient client = new OkHttpClient();
        JSONObject jsonBody = new JSONObject();
        jsonBody.put("pageUrl", (Object)pageUrl);
        if (!CollectionUtils.isEmpty(headerMap)) {
            account.setHeadParam(headerMap);
        }
        if (httpMethod != null) {
            account.setType(httpMethod.name());
        }
        jsonBody.put("cookies", JSONObject.toJSON(cookieMap));
        if (!CollectionUtils.isEmpty(paramMap)) {
            account.setPostParam(paramMap);
        }
        jsonBody.put("account", JSONObject.toJSON((Object)account));
        jsonBody.put("fileName", (Object)pdfFileName);
        jsonBody.put("printStatus", (Object)printStatus);
        String result = null;
        try {
            RequestBody body = RequestBody.create((MediaType)JSON, (String)URLEncoder.encode(jsonBody.toJSONString(), CharSetEnum.UTF8.getCharSet()));
            Request request = new Request.Builder().url(PDF_PRINT_URL).post(body).build();
            Response response = client.newCall(request).execute();
            assert (response.body() != null);
            result = response.body().string();
        }
        catch (Exception e) {
            XxlJobLogger.log((String)"\u539f\u5355\u6253\u5370\u670d\u52a1\u5f02\u5e38\uff01{}", (Object[])new Object[]{e.getMessage()});
            return false;
        }
        if (Objects.equals("HTML", account.getType())) {
            XxlJobLogger.log((String)">>>>>>>>>>> pdfPath: {}", (Object[])new Object[]{pdfFileName});
        } else {
            XxlJobLogger.log((String)">>>>>>>>>>> pdfPath: {}", (Object[])new Object[]{pdfFilePath.concat(File.separator).concat(pdfFileName).concat(".pdf")});
        }
        return Objects.equals("success", result);
    }

    public static boolean savePDF(String htmlPath, AccountTemplateDO account, String pdfFileName) {
        String htmlUrl = ossService.uploadPdfRawFile(htmlPath, account);
        if (StringUtils.isBlank((CharSequence)htmlUrl)) {
            log.info("\u4e0a\u4f20pdf\u6587\u4ef6\u5230oss\u5931\u8d25,htmlPath:" + htmlPath + ",pdfFileName:" + pdfFileName);
            XxlJobLogger.log((String)("\u4e0a\u4f20pdf\u6587\u4ef6\u5230oss\u5931\u8d25,htmlPath:" + htmlPath + ",pdfFileName:" + pdfFileName), (Object[])new Object[0]);
            return false;
        }
        int printStatus = BooleanUtils.toBooleanDefaultIfNull((Boolean)account.getPrintStatus(), (boolean)false) ? 1 : 0;
        String pdfFilePath = FileUtil.getPDFFilePath(account);
        if (Objects.equals("HTML", account.getType())) {
            pdfFileName = pdfFilePath + "/" + pdfFileName + ".pdf";
        }
        OkHttpClient client = new OkHttpClient();
        JSONObject jsonBody = new JSONObject();
        jsonBody.put("htmlUrl", (Object)htmlUrl);
        jsonBody.put("account", JSONObject.toJSON((Object)account));
        jsonBody.put("fileName", (Object)pdfFileName);
        jsonBody.put("printStatus", (Object)printStatus);
        String result = null;
        try {
            RequestBody body = RequestBody.create((MediaType)JSON, (String)URLEncoder.encode(jsonBody.toJSONString(), CharSetEnum.UTF8.getCharSet()));
            Request request = new Request.Builder().url(PDF_PRINT_URL).post(body).build();
            Response response = client.newCall(request).execute();
            assert (response.body() != null);
            result = response.body().string();
        }
        catch (Exception e) {
            XxlJobLogger.log((String)"\u539f\u5355\u6253\u5370\u670d\u52a1\u5f02\u5e38\uff01{}", (Object[])new Object[]{ExceptionUtils.getStackTrace((Throwable)e)});
        }
        return Objects.equals("success", result);
    }

    public static boolean savePDF(String htmlPath, AccountTemplateDO account) {
        String htmlUrl = ossService.uploadPdfRawFile(htmlPath, account);
        log.info("\u4e0a\u4f20pdf html\u6587\u4ef6\u5230oss html path: {}", (Object)htmlUrl);
        XxlJobLogger.log((String)"pdf to html path: {}", (Object[])new Object[]{htmlUrl});
        if (StringUtils.isBlank((CharSequence)htmlUrl)) {
            log.info("\u4e0a\u4f20pdf\u6587\u4ef6\u5230oss\u5931\u8d25,htmlPath:" + htmlPath);
            XxlJobLogger.log((String)("\u4e0a\u4f20pdf\u6587\u4ef6\u5230oss\u5931\u8d25,htmlPath:" + htmlPath), (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    public static boolean excel2Pdf(String excelUrl, String pdfUrl) {
        OkHttpClient client = new OkHttpClient();
        JSONObject jsonBody = new JSONObject();
        jsonBody.put("excelUrl", (Object)excelUrl);
        jsonBody.put("fileName", (Object)pdfUrl);
        String result = null;
        try {
            RequestBody body = RequestBody.create((MediaType)JSON, (String)URLEncoder.encode(jsonBody.toJSONString(), CharSetEnum.UTF8.getCharSet()));
            Request request = new Request.Builder().url(EXCEL2PDF_URL).post(body).build();
            Response response = client.newCall(request).execute();
            assert (response.body() != null);
            result = response.body().string();
        }
        catch (Exception e) {
            XxlJobLogger.log((String)"Excel2PDF\u6253\u5370\u670d\u52a1\u5f02\u5e38\uff01{}", (Object[])new Object[]{e.getMessage()});
        }
        return Objects.equals("success", result);
    }

    public static boolean excel2Pdf(String excelPath, String pdfUrl, AccountTemplateDO account) {
        String ossUrl = ossService.uploadPdfRawFile(excelPath, account);
        if (StringUtils.isBlank((CharSequence)ossUrl)) {
            log.info("\u4e0a\u4f20pdf\u6587\u4ef6\u5230oss\u5931\u8d25,excelPath:" + excelPath + ",pdfUrl:" + pdfUrl);
            XxlJobLogger.log((String)("\u4e0a\u4f20pdf\u6587\u4ef6\u5230oss\u5931\u8d25,excelPath:" + excelPath + ",pdfUrl:" + pdfUrl), (Object[])new Object[0]);
            return false;
        }
        return PDFPrintUtil.excel2Pdf(ossUrl, pdfUrl);
    }

    public static void excel2PdfFormat(String excelUrl, String pdfUrl) {
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)new FileInputStream(excelUrl));
            Sheet sheet = workbook.getSheetAt(0);
            int rowNum = sheet.getLastRowNum();
            for (int i = 0; i < rowNum - 1; ++i) {
                sheet.autoSizeColumn(i, true);
            }
            FileOutputStream out = new FileOutputStream(excelUrl);
            workbook.write((OutputStream)out);
            out.close();
            workbook.close();
            boolean bool = PDFPrintUtil.excel2Pdf(excelUrl, pdfUrl);
            if (bool) {
                File file = new File(excelUrl);
                if (file.exists()) {
                    file.delete();
                }
                XxlJobLogger.log((String)"--------PDF\u4e0d\u53d1\u9001MQ\u6d88\u606f", (Object[])new Object[0]);
                XxlJobLogger.log((String)">>>>>>>>>>> filePath : {}", (Object[])new Object[]{pdfUrl});
            }
        }
        catch (Exception e) {
            XxlJobLogger.log((String)"Excel2PDFFormat\u6253\u5370\u670d\u52a1\u5f02\u5e38\uff01{}", (Object[])new Object[]{e.getMessage()});
        }
    }

    public static void excelPdfFormat(String excelUrl, String pdfUrl, Workbook workbook) {
        try {
            FileOutputStream out = new FileOutputStream(excelUrl);
            workbook.write((OutputStream)out);
            out.close();
            workbook.close();
            boolean bool = PDFPrintUtil.excel2Pdf(excelUrl, pdfUrl);
            if (bool) {
                File file = new File(excelUrl);
                if (file.exists()) {
                    file.delete();
                }
                XxlJobLogger.log((String)"--------PDF\u4e0d\u53d1\u9001MQ\u6d88\u606f", (Object[])new Object[0]);
                XxlJobLogger.log((String)">>>>>>>>>>> filePath : {}", (Object[])new Object[]{pdfUrl});
            }
        }
        catch (Exception e) {
            XxlJobLogger.log((String)"Excel2PDFFormat\u6253\u5370\u670d\u52a1\u5f02\u5e38\uff01{}", (Object[])new Object[]{e.getMessage()});
        }
    }

    public static String convertHtml2Pdf(AccountTemplateDO account, String contentAsString, String poNo) {
        String pdfFilePath = FileUtil.getPDFFilePath(account);
        String pdfFileName = FileUtil.getPDFFileName(account, poNo);
        String pdfFile = pdfFilePath + "/" + pdfFileName;
        File file = new File(pdfFilePath, pdfFileName + ".html");
        File htmlFile = new File(pdfFile + ".html");
        try {
            FileUtil.createDir(pdfFilePath);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
            out.write(contentAsString);
            out.flush();
            out.close();
            FileOutputStream os = new FileOutputStream(pdfFile + ".pdf");
            ITextRenderer render = new ITextRenderer();
            ITextFontResolver fontResolver = render.getFontResolver();
            InputStream resourceAsStream = PDFPrintUtil.class.getResourceAsStream("/static/ttc/simsun.ttc");
            File ttcfile = new File("/data/pdp_data/static/ttc/simsun.ttc");
            if (!ttcfile.exists() || ttcfile.length() == 0L) {
                FileUtils.copyInputStreamToFile((InputStream)resourceAsStream, (File)ttcfile);
            }
            String ttcPath = ttcfile.getAbsolutePath();
            fontResolver.addFont(ttcPath, "Identity-H", false);
            render.setDocument(htmlFile);
            render.layout();
            render.createPDF((OutputStream)os);
            ((OutputStream)os).close();
            resourceAsStream.close();
            XxlJobLogger.log((String)("PDF\u6587\u4ef6\u6587\u4ef6\u8def\u5f84:" + pdfFile + ".pdf"), (Object[])new Object[0]);
            String string = pdfFile;
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (file.exists()) {
                file.delete();
            }
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
        }
    }

    public static String replaceCss(String result) {
        if (result != null) {
            result = result.replace("width=\"100\"", "width=\"12.5%\"");
            result = result.replace("width=\"150\"", "width=\"18.75%\"");
            result = result.replace("width=\"200\"", "width=\"25%\"");
            result = result.replace("width=\"50\"", "width=\"6.25%\"");
            result = result.replace("width=\"40\"", "width=\"5%\"");
            result = result.replace("width=\"30\"", "width=\"3.75%\"");
            result = result.replace("width=\"75\"", "width=\"9.375%\"");
            result = result.replace("width=\"115\"", "width=\"14.375%\"");
            result = result.replace("width: 350px", "width: 240px");
            result = result.replace("height: 120px", "height: 80px");
            result = result.replace("class=\"tabNote\"", "");
            result = result.replace("img src=\"/Order/LoadBarCode?id=", "img src=\"");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mergePdfFiles(String[] files, String newfile) {
        boolean retValue = false;
        Document document = null;
        PdfCopy copy = null;
        PdfReader reader = null;
        try {
            document = new Document(new PdfReader(files[0]).getPageSize(1));
            copy = new PdfCopy(document, (OutputStream)new FileOutputStream(newfile));
            document.open();
            for (int i = 0; i < files.length; ++i) {
                reader = new PdfReader(files[i]);
                int n = reader.getNumberOfPages();
                for (int j = 1; j <= n; ++j) {
                    document.newPage();
                    PdfImportedPage page = copy.getImportedPage(reader, j);
                    copy.addPage(page);
                }
            }
            retValue = true;
        }
        catch (Exception exception) {
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (copy != null) {
                copy.close();
            }
            if (document != null) {
                document.close();
            }
        }
        return retValue;
    }

    public static boolean generatePdfByParam(String tmpFile, String name, Map<String, Object> map, String exeParam, AccountTemplateDO account) throws Exception {
        String htmlStr = HtmlGenerator.generate(tmpFile, map);
        String pdfFilePath = FileUtil.getPDFFilePath(account);
        if (StringUtils.endsWithIgnoreCase((CharSequence)name, (CharSequence)".pdf")) {
            name = FilenameUtils.getBaseName((String)name);
        }
        String concat = name.concat(".html");
        FileUtil.saveFile(htmlStr, pdfFilePath, concat, account);
        htmlStr = null;
        return PDFPrintUtil.savePDF(" " + (String)StringUtils.defaultIfBlank((CharSequence)exeParam, (CharSequence)"") + " " + new File(pdfFilePath, concat).getPath(), account, name);
    }
}

