/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.lock.redisson.RedissonLock;
import com.xforceplus.utils.SpringContext;

public class RedisUtil {
    private static final String PREFIX = "job:";
    private static final String E2ETOTAL = "job:validate_code:e2e_total";
    private static final String E2EOKEY = "job:validate_code:e2e_okey";
    private static final String CJYTOTAL = "job:validate_code:cjy_total";
    private static final String CJYOKEY = "job:validate_code:cjy_okey";
    private static final RedissonLock REDISSON_LOCK = SpringContext.getBean(RedissonLock.class);

    public static String getKey(AccountTemplateDO account) {
        String retailKey = account.getRetailKey();
        String billsType = account.getBillsType();
        String accountName = account.getAccountName();
        String supplierCode = account.getSupplierCode();
        String area = account.getArea() == null ? "" : account.getArea();
        return supplierCode == null ? PREFIX + retailKey + billsType + accountName + area : PREFIX + retailKey + billsType + accountName + supplierCode + area;
    }

    public static Long e2eTotalAdd() {
        return REDISSON_LOCK.incr(E2ETOTAL);
    }

    public static Long e2eOkeyAdd() {
        return REDISSON_LOCK.incr(E2EOKEY);
    }

    public static Long cjyTotalAdd() {
        return REDISSON_LOCK.incr(CJYTOTAL);
    }

    public static Long cjyOkeyAdd() {
        return REDISSON_LOCK.incr(CJYOKEY);
    }
}

