/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class SFTPUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(List<Object> allConnect, String directory, String downloadFile, String saveDirectory) throws Exception {
        ChannelSftp sftpChannel = (ChannelSftp)allConnect.get(0);
        Channel channel = (Channel)allConnect.get(1);
        Session session = (Session)allConnect.get(2);
        FileOutputStream fileOutputStream = null;
        try {
            String saveFile = saveDirectory + "//" + downloadFile;
            sftpChannel.cd(directory);
            File file = new File(saveFile);
            fileOutputStream = new FileOutputStream(file);
            sftpChannel.get(downloadFile, (OutputStream)fileOutputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            SFTPUtil.closeChannel((Channel)sftpChannel);
            SFTPUtil.closeChannel(channel);
            SFTPUtil.closeSession(session);
        }
    }

    public static List<Object> getConnect(String username, String host, Integer port, String password) {
        LinkedList<Object> list = new LinkedList<Object>();
        try {
            JSch jsch = new JSch();
            jsch.getSession(username, host, port.intValue());
            Session sshSession = jsch.getSession(username, host, port.intValue());
            sshSession.setPassword(password);
            Properties sshConfig = new Properties();
            sshConfig.put("StrictHostKeyChecking", "no");
            sshSession.setConfig(sshConfig);
            sshSession.connect();
            Channel channel = sshSession.openChannel("sftp");
            channel.connect();
            ChannelSftp sftp = (ChannelSftp)channel;
            list.add(sftp);
            list.add(channel);
            list.add(sshSession);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void closeChannel(Channel channel) {
        if (channel != null && channel.isConnected()) {
            channel.disconnect();
        }
    }

    private static void closeSession(Session session) {
        if (session != null && session.isConnected()) {
            session.disconnect();
        }
    }

    public static List<String> parseList(Vector fileList) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : fileList) {
            String fileName = ((ChannelSftp.LsEntry)o).getFilename();
            if (".".equals(fileName) || "..".equals(fileName)) continue;
            list.add(fileName);
        }
        return list;
    }

    public static void main(String[] args) throws Exception {
        File file = new File("cache/rtmart");
        if (file.exists()) {
            File[] files = file.listFiles();
            assert (files != null);
            for (File file1 : files) {
                file1.delete();
            }
            file.delete();
        }
    }
}

