/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.ProxyConfig;
import com.gargoylesoftware.htmlunit.WebClient;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.apollo.utils.MD5Util;
import com.xforceplus.proxy.ProxyIpFactory;
import com.xforceplus.proxy.domain.IpResponse;
import com.xforceplus.utils.selenium.SeleniumUtils;
import com.xxl.job.core.log.XxlJobLogger;
import org.apache.commons.lang3.StringUtils;

public class WebClientUtil {
    public static WebClient getWebClient(String pluginName, boolean forbidden) {
        WebClient webClient = new WebClient(BrowserVersion.CHROME);
        webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        webClient.getOptions().setThrowExceptionOnScriptError(false);
        webClient.getOptions().setCssEnabled(false);
        if (forbidden) {
            webClient.getOptions().setJavaScriptEnabled(false);
        }
        webClient.getOptions().setUseInsecureSSL(true);
        webClient.getOptions().setTimeout(600000);
        webClient.getOptions().setPrintContentOnFailingStatusCode(false);
        webClient.getOptions().setMaxInMemory(0x6400000);
        return webClient;
    }

    public static WebClient getWebClient(String pluginName) {
        return WebClientUtil.getWebClient(pluginName, true);
    }

    public static WebClient getWebClient(String pluginName, boolean forbidden, AccountTemplateDO account) {
        IpResponse remoteIpProxy;
        WebClient webClient = WebClientUtil.getWebClient(pluginName, forbidden);
        if (account.getIpProxy() != null && account.getIpProxy() == 1 && (SeleniumUtils.ENV.contains("prod") || SeleniumUtils.ENV.contains("sit")) && null != (remoteIpProxy = ProxyIpFactory.getRemoteIpProxy(account.getAccountId(), account.getProxyArea(), MD5Util.getHexMD5Str((String)(StringUtils.isNotBlank((CharSequence)account.getRetailKey()) ? account.getRetailKey() : account.getSiteUrl()), (int)32), account.getProxyForm())) && StringUtils.isNotBlank((CharSequence)remoteIpProxy.getIp())) {
            String proxyIp = remoteIpProxy.getIp();
            String proxyPort = remoteIpProxy.getPort();
            XxlJobLogger.log((String)"\u4f7f\u7528\u7f13\u5b58\u4e2d\u6709\u6548\u4ee3\u7406{}:{}", (Object[])new Object[]{proxyIp, proxyPort});
            webClient.getOptions().setProxyConfig(new ProxyConfig(proxyIp, Integer.parseInt(proxyPort)));
            XxlJobLogger.log((String)"\u8ba4\u8bc1\u4fe1\u606f\uff1a{}", (Object[])new Object[]{remoteIpProxy.getBasicProxy()});
            if (StringUtils.isNotBlank((CharSequence)remoteIpProxy.getBasicProxy())) {
                webClient.addRequestHeader("Proxy-Authorization", remoteIpProxy.getBasicProxy());
            }
        }
        return webClient;
    }

    public static WebClient getWebClient(BrowserVersion browserVersion, AccountTemplateDO account) {
        IpResponse remoteIpProxy;
        WebClient webClient = new WebClient(browserVersion);
        if (account.getIpProxy() != null && account.getIpProxy() == 1 && (SeleniumUtils.ENV.contains("prod") || SeleniumUtils.ENV.contains("sit")) && null != (remoteIpProxy = ProxyIpFactory.getRemoteIpProxy(account.getAccountId(), account.getProxyArea(), MD5Util.getHexMD5Str((String)(StringUtils.isNotBlank((CharSequence)account.getRetailKey()) ? account.getRetailKey() : account.getSiteUrl()), (int)32), account.getProxyForm())) && StringUtils.isNotBlank((CharSequence)remoteIpProxy.getIp())) {
            String proxyIp = remoteIpProxy.getIp();
            String proxyPort = remoteIpProxy.getPort();
            XxlJobLogger.log((String)"\u4f7f\u7528\u7f13\u5b58\u4e2d\u6709\u6548\u4ee3\u7406{}:{}", (Object[])new Object[]{proxyIp, proxyPort});
            webClient.getOptions().setProxyConfig(new ProxyConfig(proxyIp, Integer.parseInt(proxyPort)));
            XxlJobLogger.log((String)"\u8ba4\u8bc1\u4fe1\u606f\uff1a{}", (Object[])new Object[]{remoteIpProxy.getBasicProxy()});
            if (StringUtils.isNotBlank((CharSequence)remoteIpProxy.getBasicProxy())) {
                webClient.addRequestHeader("Proxy-Authorization", remoteIpProxy.getBasicProxy());
            }
        }
        return webClient;
    }
}

