/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class XMLParseUtils {
    private XMLParseUtils() {
    }

    public static String getValueByRootName(String XML2, String rootName, String nodenName) {
        List<Map<String, String>> maps = XMLParseUtils.getChildElementValuesByRootName(XML2, rootName);
        String value = null;
        if (null != maps && !maps.isEmpty()) {
            Map<String, String> map = maps.get(0);
            value = map.get(nodenName);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                value = value.replaceAll("\t", "").replaceAll("\n", "").trim();
            }
            return value;
        }
        return "";
    }

    public static List<Map<String, String>> getChildElementValuesByRootName(String XML2, String name) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{XML2, name})) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        try {
            Document document = DocumentHelper.parseText((String)XML2);
            List elements = document.selectNodes("//" + name);
            for (Object object : elements) {
                HashMap<String, String> valuesMap = new HashMap<String, String>();
                Element root = (Element)object;
                List childElements = root.elements();
                for (Object o : childElements) {
                    Element element = (Element)o;
                    valuesMap.put(element.getName(), element.getStringValue().replaceAll("\t", "").replaceAll("\n", "").trim());
                }
                result.add(valuesMap);
            }
        }
        catch (DocumentException var13) {
            var13.printStackTrace();
        }
        return result;
    }

    public static String getChildElementXMLByRootName(String XML2, String name) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{XML2, name})) {
            return "";
        }
        StringBuilder builder = new StringBuilder("");
        try {
            Document document = DocumentHelper.parseText((String)XML2);
            List elements = document.selectNodes("//" + name);
            for (Object object : elements) {
                Element root = (Element)object;
                builder.append(root.asXML());
            }
        }
        catch (DocumentException var8) {
            var8.printStackTrace();
        }
        return builder.toString();
    }

    public static Map<String, String> getChildElementValues(Document document) {
        if (null == document) {
            return Collections.emptyMap();
        }
        Element root = document.getRootElement();
        List childElements = root.elements();
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        for (Object object : childElements) {
            Element element = (Element)object;
            valuesMap.put(element.getName(), element.getStringValue());
        }
        return valuesMap;
    }
}

