/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.gargoylesoftware.htmlunit.Page;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.utils.FileUtil;
import com.xforceplus.utils.StringConvertUtils;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class XxlCrawlerUtils {
    public static String crawlerFile(String contentAsString, AccountTemplateDO account) {
        try {
            if (StringConvertUtils.isMessyCode(contentAsString)) {
                XxlJobLogger.log((String)"\u6293\u5355\u4e71\u7801---\u8bf7\u6301\u7eed\u5173\u6ce8---", (Object[])new Object[0]);
            }
            if (StringConvertUtils.loading(contentAsString)) {
                XxlJobLogger.log((String)"\u672a\u52a0\u8f7d\u5b8c\u6210---\u8bf7\u6301\u7eed\u5173\u6ce8---", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            XxlJobLogger.log((String)"\u5224\u65ad\u4e71\u7801\u65b9\u6cd5\u5f02\u5e38\uff01", (Object[])new Object[0]);
        }
        String filePath = FileUtil.getFilePath(account);
        String fileName = FileUtil.getFileName(account);
        return FileUtil.saveFile(contentAsString, filePath, fileName, account);
    }

    public static String crawlerPage(Page page, AccountTemplateDO account) {
        InputStream contentAsStream = null;
        try {
            String contentAsString = page.getWebResponse().getContentAsString();
            if (StringConvertUtils.isMessyCode(contentAsString)) {
                XxlJobLogger.log((String)"\u6293\u5355\u4e71\u7801---\u8bf7\u6301\u7eed\u5173\u6ce8---", (Object[])new Object[0]);
            }
            if (Objects.equals(account.getFileSuffix(), ".html") && StringConvertUtils.loading(contentAsString)) {
                XxlJobLogger.log((String)"\u672a\u52a0\u8f7d\u5b8c\u6210---\u8bf7\u6301\u7eed\u5173\u6ce8---", (Object[])new Object[0]);
            }
            contentAsStream = page.getWebResponse().getContentAsStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            XxlJobLogger.log((String)"\u5224\u65ad\u4e71\u7801\u65b9\u6cd5\u5f02\u5e38\uff01", (Object[])new Object[0]);
        }
        String filePath = FileUtil.getFilePath(account);
        String fileName = FileUtil.getFileName(account);
        assert (contentAsStream != null);
        return FileUtil.saveFile(contentAsStream, filePath, fileName, account);
    }

    public static String crawlerFile(String contentAsString, AccountTemplateDO account, String extName) {
        try {
            if (StringConvertUtils.isMessyCode(contentAsString)) {
                XxlJobLogger.log((String)"\u6293\u5355\u4e71\u7801---\u8bf7\u6301\u7eed\u5173\u6ce8---", (Object[])new Object[0]);
            }
            if (StringConvertUtils.loading(contentAsString)) {
                XxlJobLogger.log((String)"\u672a\u52a0\u8f7d\u5b8c\u6210---\u8bf7\u6301\u7eed\u5173\u6ce8---", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            XxlJobLogger.log((String)"\u5224\u65ad\u4e71\u7801\u65b9\u6cd5\u5f02\u5e38\uff01", (Object[])new Object[0]);
        }
        String filePath = FileUtil.getFilePath(account);
        String fileName = FileUtil.getFileName(account);
        return FileUtil.saveFile(account, contentAsString, extName, account.getFileSuffix());
    }

    public static String crawlerStringFile(String contentAsString, AccountTemplateDO account) {
        String filePath = FileUtil.getFilePath(account);
        String fileName = FileUtil.getFileName(account);
        return FileUtil.saveFile(contentAsString, filePath, fileName, account);
    }

    public static String crawlerStringFile(String contentAsString, AccountTemplateDO account, String suffix) {
        String filePath = FileUtil.getFilePath(account);
        String fileName = FileUtil.getFileNameBySuffix(account, suffix);
        return FileUtil.saveFile(contentAsString, filePath, fileName, account);
    }

    public static String crawlerPageFile(Page page, AccountTemplateDO account) throws IOException {
        InputStream contentAsStream = page.getWebResponse().getContentAsStream();
        String filePath = FileUtil.getFilePath(account);
        String fileName = FileUtil.getFileName(account);
        return FileUtil.saveFile(contentAsStream, filePath, fileName, account);
    }

    public static String crawlerPageFile(Page page, AccountTemplateDO account, String suffix) throws IOException {
        InputStream contentAsStream = page.getWebResponse().getContentAsStream();
        String filePath = FileUtil.getFilePath(account);
        String fileName = FileUtil.getFileNameBySuffix(account, suffix);
        return FileUtil.saveFile(contentAsStream, filePath, fileName, account);
    }
}

