/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.core.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.xforceplus.core.config.UserCenterTokenProperties;
import com.xforceplus.core.exception.RemoteCallException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import kong.unirest.Config;
import kong.unirest.HttpRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Interceptor;
import kong.unirest.ObjectMapper;
import kong.unirest.Unirest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
public class RestConfig {
    private static final Logger log = LoggerFactory.getLogger(RestConfig.class);
    @Resource
    private UserCenterTokenApi userCenterTokenApi;

    @PostConstruct
    public void configUnirest() {
        log.info("init rest client");
        Unirest.config().setObjectMapper(new ObjectMapper(){

            public <T> T readValue(String s, Class<T> aClass) {
                return (T)JSON.parseObject((String)s, aClass);
            }

            public String writeValue(Object o) {
                return JSON.toJSONString((Object)o);
            }
        }).connectTimeout(2000).socketTimeout(30000).interceptor(new Interceptor(){

            public void onRequest(HttpRequest<?> request, Config config) {
                if (request.getUrl().contains("/api/client/login")) {
                    return;
                }
                if (!request.getUrl().contains(".xforceplus.com/api/")) {
                    return;
                }
                request.header("x-app-token", RestConfig.this.userCenterTokenApi.token());
            }
        });
    }

    @Component
    static class UserCenterTokenApi {
        private static final Logger log = LoggerFactory.getLogger(UserCenterTokenApi.class);
        private final UserCenterTokenProperties userCenterTokenProperties;
        private final LoadingCache<String, String> cache;
        private final CacheLoader<String, String> loader = new CacheLoader<String, String>(){

            public String load(String key) {
                return this.fetchToken();
            }
        };

        public UserCenterTokenApi(UserCenterTokenProperties userCenterTokenProperties) {
            this.userCenterTokenProperties = userCenterTokenProperties;
            this.cache = CacheBuilder.newBuilder().maximumSize(1L).expireAfterWrite(Duration.of(userCenterTokenProperties.getExpireHours(), ChronoUnit.HOURS)).build(this.loader);
        }

        public String token() {
            if (this.userCenterTokenProperties.getParams() == null || StringUtils.isBlank((CharSequence)this.userCenterTokenProperties.getParams().getClientId())) {
                return null;
            }
            return (String)this.cache.getUnchecked((Object)this.userCenterTokenProperties.getParams().getClientId());
        }

        public void refresh() {
            log.info("refresh cache");
            this.cache.cleanUp();
        }

        private String fetchToken() {
            try {
                HttpResponse httpResponse = ((HttpRequestWithBody)Unirest.post((String)(this.userCenterTokenProperties.getRequestUrl() + "/api/client/login")).header("Content-Type", "application/json")).body((Object)this.userCenterTokenProperties.getParams()).asString();
                log.debug("request user center status = {}, body = {}", (Object)httpResponse.getStatus(), httpResponse.getBody());
                if (!httpResponse.isSuccess()) {
                    throw new RemoteCallException("\u83b7\u53d6\u7528\u6237\u4e2d\u5fc3token\u5931\u8d25!" + httpResponse.getStatusText());
                }
                String body = (String)httpResponse.getBody();
                if (StringUtils.isBlank((CharSequence)body)) {
                    throw new RemoteCallException("\u83b7\u53d6\u7528\u6237\u4e2d\u5fc3token\u5931\u8d25!\u8fd4\u56de\u4e3a\u7a7a");
                }
                Map bodyMap = (Map)JSON.parseObject((String)body, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                String token = (String)bodyMap.get("data");
                log.info("fetch token: {}", (Object)token);
                return token;
            }
            catch (Exception e) {
                throw new RemoteCallException(e);
            }
        }
    }
}

