/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.core.notice;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.xforceplus.apollo.utils.HttpUtil;
import com.xforceplus.apollo.utils.SystemUtil;
import com.xforceplus.core.notice.DingDingProperties;
import com.xforceplus.core.notice.TextMessage;
import com.xforceplus.utils.SpringContext;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DdingNoticeHelper {
    private static final Logger logger = LoggerFactory.getLogger(DdingNoticeHelper.class);
    private static volatile DdingNoticeHelper ddingNoticeHelper = null;
    private static Cache<String, AtomicInteger> timesMap = CacheBuilder.newBuilder().expireAfterWrite(3L, TimeUnit.SECONDS).maximumSize(1L).build();
    private static Cache<String, Boolean> waitMap = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.SECONDS).maximumSize(1L).build();
    private String ipAddress = "";
    private DingDingProperties dingDingProperties = SpringContext.getBean(DingDingProperties.class);

    private DdingNoticeHelper() {
        this.ipAddress = SystemUtil.getIPAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DdingNoticeHelper getInstance() {
        if (null != ddingNoticeHelper) return ddingNoticeHelper;
        Class<DdingNoticeHelper> clazz = DdingNoticeHelper.class;
        synchronized (DdingNoticeHelper.class) {
            if (null != ddingNoticeHelper) return ddingNoticeHelper;
            ddingNoticeHelper = new DdingNoticeHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ddingNoticeHelper;
        }
    }

    public boolean sendDdingNotice(String content) {
        if (null == this.dingDingProperties || StringUtils.isBlank((CharSequence)this.dingDingProperties.getDdUrl()) || StringUtils.isBlank((CharSequence)this.dingDingProperties.getDdAuthentication()) || StringUtils.isBlank((CharSequence)this.dingDingProperties.getDdAction()) || StringUtils.isBlank((CharSequence)this.dingDingProperties.getDdUiaSign())) {
            logger.warn("\u9489\u9489\u901a\u77e5\u4fe1\u606f\u672a\u914d\u7f6e\u6216\u672a\u914d\u7f6e\u5b8c\u6574");
            return false;
        }
        if (!Objects.equals(this.dingDingProperties.getIsDDEnable(), "true")) {
            logger.warn("\u65e0\u9700\u9489\u9489\u901a\u77e5,\u65e5\u5fd7\u6587\u672c:{}", (Object)content);
            return true;
        }
        TextMessage msg = new TextMessage(this.dingDingProperties.getDdToken(), content + " \u673a\u5668IP:" + this.ipAddress);
        return this.ddingLogAlert(msg.toJsonString());
    }

    private boolean ddingLogAlert(String errJsonMsg) {
        boolean isSend = false;
        try {
            if (Objects.equals(this.dingDingProperties.getIsDDEnable(), "true")) {
                int k;
                if (null != waitMap.getIfPresent((Object)"wait")) {
                    return isSend;
                }
                AtomicInteger times = (AtomicInteger)timesMap.getIfPresent((Object)"times");
                if (null == times) {
                    times = new AtomicInteger(0);
                    timesMap.put((Object)"times", (Object)times);
                }
                if ((k = times.incrementAndGet()) > 2) {
                    timesMap.invalidateAll();
                    waitMap.put((Object)"wait", (Object)true);
                    return isSend;
                }
                String ddUrl = this.dingDingProperties.getDdUrl();
                if (StringUtils.isNotBlank((CharSequence)ddUrl)) {
                    HashMap<String, String> headerParam = new HashMap<String, String>();
                    headerParam.put("Authentication", this.dingDingProperties.getDdAuthentication());
                    headerParam.put("action", this.dingDingProperties.getDdAction());
                    headerParam.put("uiaSign", this.dingDingProperties.getDdUiaSign());
                    headerParam.put("serialNo", System.currentTimeMillis() + "");
                    HttpUtil.ResponseCus res = HttpUtil.doPostJsonEntire((String)ddUrl, (String)errJsonMsg, headerParam, new HashMap());
                    if (null != res && res.getStatus() == 200) {
                        isSend = true;
                    }
                }
            }
        }
        catch (Exception var8) {
            logger.error("\u9489\u9489\u62a5\u8b66\u5f02\u5e38", (Throwable)var8);
        }
        return isSend;
    }
}

