/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.lock.redisson.strategy.impl;

import com.xforceplus.lock.constant.GlobalConstant;
import com.xforceplus.lock.redisson.config.RedissonProperties;
import com.xforceplus.lock.redisson.strategy.RedissonConfigStrategy;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import org.apache.commons.lang3.StringUtils;
import org.redisson.client.codec.Codec;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class StandaloneRedissonConfigStrategyImpl
implements RedissonConfigStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandaloneRedissonConfigStrategyImpl.class);
    private String codec = "org.redisson.codec.JsonJacksonCodec";

    public String getCodec() {
        return this.codec;
    }

    public void setCodec(String codec) {
        this.codec = codec;
    }

    @Override
    public Config createRedissonConfig(RedissonProperties redissonProperties) {
        Config config = new Config();
        try {
            String address = redissonProperties.getAddress();
            String password = redissonProperties.getPassword();
            int cpuNum = redissonProperties.getCpuNum();
            int connectionMinimumIdleSize = 10;
            int idleConnectionTimeout = 10000;
            int pingTimeout = 2000;
            int connectTimeout = 60000;
            int timeout = 10000;
            int retryAttempts = 3;
            int retryInterval = 1500;
            int reconnectionTimeout = 6000;
            int subscriptionsPerConnection = 5;
            String clientName = null;
            int subscriptionConnectionMinimumIdleSize = 1;
            int subscriptionConnectionPoolSize = 50;
            int connectionPoolSize = 1000;
            int database = redissonProperties.getDatabase();
            String redisAddr = GlobalConstant.REDIS_CONNECTION_PREFIX.getConstant_value() + address;
            config.useSingleServer().setAddress(redisAddr);
            config.useSingleServer().setDatabase(database);
            if (StringUtils.isNotBlank((CharSequence)password)) {
                config.useSingleServer().setPassword(password);
                config.useSingleServer().setTimeout(timeout);
                config.useSingleServer().setConnectTimeout(reconnectionTimeout);
                config.useSingleServer().setConnectionMinimumIdleSize(connectionMinimumIdleSize);
                config.useSingleServer().setConnectionPoolSize(connectionPoolSize);
                config.useSingleServer().setSubscriptionConnectionMinimumIdleSize(subscriptionConnectionMinimumIdleSize);
                config.useSingleServer().setSubscriptionConnectionPoolSize(subscriptionConnectionPoolSize);
                config.useSingleServer().setSubscriptionsPerConnection(subscriptionsPerConnection);
                config.useSingleServer().setClientName(clientName);
                config.useSingleServer().setRetryAttempts(retryAttempts);
                config.useSingleServer().setRetryInterval(retryInterval);
                config.useSingleServer().setConnectTimeout(connectTimeout);
                config.useSingleServer().setIdleConnectionTimeout(idleConnectionTimeout);
                config.useSingleServer().setPingConnectionInterval(pingTimeout);
                Codec codec = (Codec)ClassUtils.forName((String)this.getCodec(), (ClassLoader)ClassUtils.getDefaultClassLoader()).newInstance();
                config.setCodec(codec);
                if (cpuNum >= 16) {
                    config.setThreads(cpuNum);
                }
                config.setEventLoopGroup((EventLoopGroup)new NioEventLoopGroup());
            }
            LOGGER.info("\u521d\u59cb\u5316[standalone]\u65b9\u5f0fConfig,redisAddress:" + address);
        }
        catch (Exception var24) {
            LOGGER.error("standalone Redisson init error", (Throwable)var24);
            var24.printStackTrace();
        }
        return config;
    }
}

