/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils.warn.sender;

import com.alibaba.fastjson.JSON;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.core.enums.RetailConstantEnum;
import com.xforceplus.core.message.WarningMessageBo;
import com.xforceplus.core.message.constant.Platform;
import com.xforceplus.core.message.constant.PlatformMenu;
import com.xforceplus.core.message.constant.PlatformModules;
import com.xforceplus.core.message.constant.PlatformService;
import com.xforceplus.core.message.constant.WarnType;
import com.xforceplus.utils.DateUtils;
import com.xforceplus.utils.warn.sender.ChangePasswordProcesser;
import com.xforceplus.utils.warn.sender.QueryCodeProcesser;
import com.xxl.job.core.log.XxlJobLogger;
import com.xxl.rpc.util.IpUtil;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class SendWarnMessage {
    private static final RestTemplate restTemplate = new RestTemplate();
    private static final HttpHeaders requestHeaders = new HttpHeaders();
    private static final ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();
    @Value(value="${warn.sendUrl}")
    private String warnUrl;
    @Value(value="${warn.enable:true}")
    private boolean warnEnable;
    @Value(value="${warn.retryCount:3}")
    private int retryCount;
    @Autowired
    ChangePasswordProcesser changePasswordProcesser;
    @Autowired
    QueryCodeProcesser queryCodeProcesser;

    @PostConstruct
    public void init() {
        requestHeaders.setContentType(MediaType.APPLICATION_JSON);
    }

    public void createWarnMessage(AccountTemplateDO account, Integer warnType, Integer developer, String msgText) {
        if (account.getMobilePhone() != null && warnType != null) {
            if (warnType.intValue() == WarnType.USERERROR.getIndex() || warnType.intValue() == WarnType.PASSWORDNOTNULLERROR.getIndex() || warnType.intValue() == WarnType.PASSWORDLENGTHERROR.getIndex()) {
                this.changePasswordProcesser.changePassword(account);
            } else if (warnType.intValue() == WarnType.CERTIFICATION_CODE.getIndex()) {
                this.queryCodeProcesser.queryCode(account);
            }
        }
        if (account.getWarnMessage() == null) {
            return;
        }
        WarningMessageBo warningMessage = (WarningMessageBo)JSON.parseObject((String)account.getWarnMessage(), WarningMessageBo.class);
        warningMessage.setPlatform(Platform.DCS.getIndex());
        warningMessage.setIp(IpUtil.getIp());
        warningMessage.setService(PlatformService.BILLS.getIndex());
        warningMessage.setModules(PlatformModules.ORDERCONTER.getIndex());
        warningMessage.setMenuOrButton(PlatformMenu.ZZ.getIndex());
        warningMessage.setWarnType(warnType);
        warningMessage.setDeveloper(developer);
        msgText = RetailConstantEnum.geLabelByKey(account.getRetailKey()) + ",\u8d26\u53f7:" + account.getAccountName() + "->" + msgText;
        warningMessage.setMsgText(msgText);
        warningMessage.setMsgCreateTime(DateUtils.dateToLongString(new Date()));
        if (warningMessage.getSendChannel() == 1 || warningMessage.getSendChannel() == 2) {
            warningMessage.setCustomAccepter("other");
        } else {
            warningMessage.setMessageAccepter(9999);
        }
        this.sendMessage(warningMessage);
    }

    public void sendMessage(WarningMessageBo warningMessage) {
        if (!this.warnEnable) {
            return;
        }
        if (this.validateBean(warningMessage)) {
            return;
        }
        singleThreadExecutor.execute(() -> {
            String timeStamp = String.valueOf(System.currentTimeMillis());
            String uuid = UUID.randomUUID().toString().concat("-").concat(timeStamp);
            String msg = JSON.toJSONString((Object)warningMessage);
            XxlJobLogger.log((String)"\u64cd\u4f5cID:{},\u53d1\u9001\u9884\u8b66\u6d88\u606f:{}", (Object[])new Object[]{uuid, msg});
            HttpEntity requestEntity = new HttpEntity((Object)msg, (MultiValueMap)requestHeaders);
            ResponseEntity resonse = null;
            for (int i = 0; i < this.retryCount; ++i) {
                boolean flg = false;
                try {
                    resonse = restTemplate.postForEntity(this.warnUrl, (Object)requestEntity, String.class, new Object[0]);
                }
                catch (Exception e) {
                    XxlJobLogger.log((String)"\u64cd\u4f5cID:{},\u7b2c{}\u6b21\u53d1\u9001\u5931\u8d25,\u9519\u8bef\u4fe1\u606f:{}", (Object[])new Object[]{uuid, i + 1, e.getLocalizedMessage()});
                    flg = true;
                }
                if (!flg) break;
            }
            if (resonse == null) {
                XxlJobLogger.log((String)("\u64cd\u4f5cID:" + uuid + ",\u53d1\u9001\u9884\u8b66\u6d88\u606f\u5931\u8d25"), (Object[])new Object[0]);
                return;
            }
            XxlJobLogger.log((String)"\u64cd\u4f5cID:{},\u53d1\u9001\u9884\u8b66\u7ed3\u679c:{}", (Object[])new Object[]{uuid, resonse.getBody()});
        });
    }

    private boolean validateBean(Object bean) {
        Field[] fileds;
        for (Field field : fileds = bean.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            Object value = null;
            try {
                value = field.get(bean);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (value != null && !"".equals(value.toString().trim())) continue;
            XxlJobLogger.log((String)"{}\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{field.getName()});
            return true;
        }
        return false;
    }
}

