/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.core.message.constant;

import com.xforceplus.core.message.WarningMessagePo;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;

public class ToolsKit {
    public static String getUniqueKey(WarningMessagePo msgPo) {
        String uniqueKey = new String("");
        uniqueKey = msgPo.getSupplier().concat(msgPo.getPlatform()).concat(msgPo.getService()).concat(msgPo.getModules()).concat(msgPo.getMenuOrButton()).concat(msgPo.getWarnType()).concat(msgPo.getDeveloper()).concat(msgPo.getSendChannel()).concat(msgPo.getWebhook()).concat(msgPo.getIp());
        return ToolsKit.encrypByMd5(uniqueKey);
    }

    public static String dateToString(Date date, String pattern) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
            return simpleDateFormat.format(date);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static List<String> getIPAddresses() {
        ArrayList<String> addresses = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> networkInterfaceEnum = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaceEnum.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaceEnum.nextElement();
                if (networkInterface.isLoopback() || !networkInterface.isUp()) continue;
                Enumeration<InetAddress> ips = networkInterface.getInetAddresses();
                while (ips.hasMoreElements()) {
                    InetAddress addr = ips.nextElement();
                    if (!(addr instanceof Inet4Address) || addr.getHostAddress().isEmpty()) continue;
                    addresses.add(addr.getHostAddress());
                }
            }
        }
        catch (SocketException e) {
            System.out.println("\u83b7\u53d6IP\u5730\u5740\u62a5\u9519:" + e.getMessage());
            addresses.add("0.0.0.0");
            return addresses;
        }
        return addresses;
    }

    public static String encrypByMd5(String context) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(context.getBytes());
            byte[] encryContext = md.digest();
            StringBuffer buf = new StringBuffer("");
            for (int offset = 0; offset < encryContext.length; ++offset) {
                int i = encryContext[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
            return buf.toString().substring(8, 24);
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public static String romveSpecialChar(String str) {
        String regEx = "[\"`~!@#$%^*()+|{}';'<>/?~\uff01@#\uffe5%\u2026\u2026*\u2018\u201d\u201c\u2019]";
        str = Pattern.compile(regEx).matcher(str).replaceAll("").trim();
        return str;
    }

    public static void main(String[] args) {
        String tmp = "\u961f\u5217\uff1aqueue.pdp_po_anlyze\uff0c\u6d88\u606f\u7edf\u8ba15\u6b21\u4e3a0\uff0c\u65f6\u95f4\u6bb5\uff1a[20220812 1700,20220812 1640]\uff0c\u8bf7\u4eba\u5de5\u6392\u67e5\u662f\u5426\u5f02\u5e38";
        System.out.println(ToolsKit.romveSpecialChar(tmp));
    }
}

