/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.proxy;

import com.xforceplus.lock.redisson.RedissonLock;
import com.xforceplus.lock.redisson.RedissonManager;
import com.xforceplus.proxy.ProxyIpFactory;
import com.xforceplus.proxy.domain.IpTrackerDo;
import com.xforceplus.utils.SpringContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.redisson.api.RBucket;
import org.redisson.api.RScoredSortedSet;
import org.redisson.api.RedissonClient;

public class IpTracker {
    private static final RedissonManager redissonManager = SpringContext.getBean(RedissonManager.class);
    static final String PROXY_IP_ACCOUNT_LOCK_KEY = "job:ipproxy:account:lockkey:";
    private static final int MAX_HISTORY_SIZE = 10;
    private RScoredSortedSet<String> ipHistory;
    private static RedissonLock redissonLock;
    private static volatile IpTracker ipTracker;
    private RedissonClient redisson = redissonManager.getRedisson();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IpTracker getInstance() {
        if (null != ipTracker) return ipTracker;
        Class<IpTracker> clazz = IpTracker.class;
        synchronized (IpTracker.class) {
            if (null != ipTracker) return ipTracker;
            ipTracker = new IpTracker();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ipTracker;
        }
    }

    private IpTracker() {
        redissonLock = SpringContext.getBean(RedissonLock.class);
    }

    public void addOrUpdateIp(String accountKey, String ip) {
        Double dv;
        this.ipHistory = this.redisson.getScoredSortedSet(PROXY_IP_ACCOUNT_LOCK_KEY + accountKey);
        if (null == this.ipHistory) {
            return;
        }
        if (this.ipHistory.size() > 9) {
            this.ipHistory.removeRangeByRank(0, 0);
        }
        if (null == (dv = this.ipHistory.addScore((Object)ip, (Number)1)) || dv <= 1.0) {
            this.ipHistory.add(1.0, (Object)ip);
        }
    }

    public void incrementIpUsage(String accountKey, String ip, int increment) {
        this.ipHistory = this.redisson.getScoredSortedSet(PROXY_IP_ACCOUNT_LOCK_KEY + accountKey);
        if (null == this.ipHistory) {
            return;
        }
        this.ipHistory.addScore((Object)ip, (Number)increment);
    }

    public void removeIp(String accountKey, String ip) {
        this.ipHistory = this.redisson.getScoredSortedSet(PROXY_IP_ACCOUNT_LOCK_KEY + accountKey);
        if (null == this.ipHistory) {
            return;
        }
        this.ipHistory.remove((Object)ip);
    }

    public List<IpTrackerDo> getRecentIps(String accountKey) {
        this.ipHistory = this.redisson.getScoredSortedSet(PROXY_IP_ACCOUNT_LOCK_KEY + accountKey);
        if (null == this.ipHistory) {
            return new ArrayList<IpTrackerDo>();
        }
        ArrayList<IpTrackerDo> list = new ArrayList<IpTrackerDo>();
        this.ipHistory.entryRangeReversed(0, -1).forEach(entry -> list.add(new IpTrackerDo((String)entry.getValue(), entry.getScore())));
        return list;
    }

    public void addOrUpdateIpIn(String accountKey, String ip) {
        this.ipHistory = this.redisson.getScoredSortedSet(PROXY_IP_ACCOUNT_LOCK_KEY + accountKey);
        if (null == this.ipHistory) {
            return;
        }
        Double dv = this.ipHistory.addScore((Object)ip, (Number)1);
        if (null == dv || dv <= 1.0) {
            this.ipHistory.add(1.0, (Object)ip);
        }
    }

    public void release(String accountKey) {
        String proxyPort;
        String proxyIp;
        boolean validCheck;
        Map proxyConfig;
        RBucket proxyConfigRBucket = redissonLock.getRedissonManager().getRedisson().getBucket("job:ipproxy:map_cache:" + accountKey);
        Map proxyConfigMap = (Map)proxyConfigRBucket.get();
        if (proxyConfigMap != null && (proxyConfig = (Map)proxyConfigMap.get("proxyConfig")) != null && !proxyConfig.isEmpty() && (validCheck = ProxyIpFactory.validateProxy(proxyIp = (String)proxyConfig.get("proxyIp"), proxyPort = (String)proxyConfig.get("proxyPort"), ""))) {
            this.addOrUpdateIpIn("proxyIpSuccessList", proxyIp + "," + proxyPort);
        }
    }
}

