/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.service.handler;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.gargoylesoftware.htmlunit.WebClient;
import com.xforceplus.account.AbstractLoginSys;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.apollo.utils.DateFormatUtil;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.apollo.utils.MD5Util;
import com.xforceplus.core.annotation.DcsJobHandler;
import com.xforceplus.core.annotation.JobHandlerParam;
import com.xforceplus.core.domain.CollectParam;
import com.xforceplus.core.exception.PasswordErrorException;
import com.xforceplus.core.notice.ExceptionDdNoticer;
import com.xforceplus.core.resolve.TaskProducer;
import com.xforceplus.core.resolve.dto.CollectAccountDto;
import com.xforceplus.core.resolve.dto.CollectAccountResponse;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.config.core.util.JanusHttpUtil;
import com.xforceplus.lock.redisson.RedissonLock;
import com.xforceplus.service.handler.CollectRecordHandler;
import com.xforceplus.service.handler.TaskThread;
import com.xforceplus.service.oss.OssService;
import com.xforceplus.utils.AccountGrouper;
import com.xforceplus.utils.AesUtil;
import com.xforceplus.utils.BaseUtils;
import com.xforceplus.utils.CommonDataHelper;
import com.xforceplus.utils.CountUtils;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;

public abstract class BaseDcsHandler
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(BaseDcsHandler.class);
    @Resource
    private OssService ossService;
    @Resource
    private TaskProducer taskProducer;
    @Resource
    private RedissonLock redissonLock;
    @Value(value="${janus.businessKey}")
    private String businessKey;
    @Value(value="${janus.authentication}")
    private String authentication;
    @Value(value="${janus.url}")
    private String janusUrl;
    @Value(value="${janus.thread: 1}")
    private Integer threadNum;
    @Value(value="${dcs.common.account.aesKey}")
    private String aesKey;
    @Resource
    private ApplicationContext applicationContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReturnT<String> execute(String param) throws Exception {
        this.threadNum = null == this.threadNum ? 1 : this.threadNum;
        String paramStr = param.trim();
        if (paramStr.isEmpty()) {
            XxlJobLogger.log((String)"\u4f9b\u5e94\u5546(\u5ba2\u6237)\u5e73\u53f0\u7b80\u79f0\uff08\u4efb\u52a1\u53c2\u6570\uff09\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            return FAIL;
        }
        Map beanMap = this.applicationContext.getBeansWithAnnotation(DcsJobHandler.class);
        if (MapUtils.isEmpty((Map)beanMap)) {
            XxlJobLogger.log((String)"\u6ca1\u6709\u5904\u7406handlers", (Object[])new Object[0]);
            return FAIL;
        }
        ExecutorService executorGroupService = null;
        ConcurrentHashMap<String, String> resultMap = new ConcurrentHashMap<String, String>();
        String jobHandlerType = null;
        try {
            JobHandler jobHandler = ((Object)((Object)this)).getClass().getAnnotation(JobHandler.class);
            if (null != jobHandler) {
                jobHandlerType = jobHandler.value();
            }
        }
        catch (Exception e) {
            XxlJobLogger.log((String)ErrorUtil.getStackMsg((Exception)e), (Object[])new Object[0]);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, Object> headers = new HashMap<String, Object>();
        try {
            CollectAccountResponse accountResponse;
            DcsJobHandler dcsJobHandler = this.getDcsJobHandler();
            JobHandlerParam jobHandlerParam = this.getJobHandlerParam();
            JSONObject json = JSON.parseObject((String)paramStr);
            String accountId = json.getString("accountId");
            String recordId = json.getString("recordId");
            String xxlJobId = json.getString("xxlJobId");
            XxlJobLogger.log((String)("\u5f00\u59cb\u6267\u884cxxlJobId:" + xxlJobId), (Object[])new Object[0]);
            String projectId = json.getString("projectId");
            String collectType = json.getString("collectType");
            String xxlLogId = json.getString("xxlLogId");
            String xxlAddress = json.getString("xxlAddress");
            Long xxlTime = json.getLongValue("xxlTime");
            String xxlJobType = json.getString("xxlJobType");
            String janusOperator = json.getString("janusOperator");
            String paramThreadNum = json.getString("threadNum");
            String paramThreadGroup = json.getString("threadGroup");
            String waitTimeMinutes = json.getString("waitTimeMinutes");
            Integer threadGroupNum = null;
            if (StringUtils.isNotBlank((CharSequence)paramThreadGroup) && StringUtils.isNumeric((CharSequence)paramThreadGroup)) {
                try {
                    threadGroupNum = Integer.parseInt(paramThreadGroup);
                }
                catch (Exception exception) {
                }
                finally {
                    json.remove((Object)"threadGroup");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)paramThreadNum) && StringUtils.isNumeric((CharSequence)paramThreadNum)) {
                try {
                    this.threadNum = Integer.parseInt(paramThreadNum);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (StringUtils.isNotBlank((CharSequence)collectType)) {
                json.remove((Object)"collectType");
            }
            String billType = dcsJobHandler.billType().name();
            if (StringUtils.isNotBlank((CharSequence)accountId)) {
                params.put("accountId", accountId);
            }
            if (StringUtils.isNotBlank((CharSequence)projectId)) {
                params.put("projectId", projectId);
            }
            if (StringUtils.isNotBlank((CharSequence)billType) && !Objects.equals(billType.toUpperCase(), "ALL")) {
                if (StringUtils.isBlank((CharSequence)jobHandlerType)) {
                    jobHandlerType = billType;
                }
                params.put("billType", Objects.equals(billType.toLowerCase(), jobHandlerType.toLowerCase()) ? billType : jobHandlerType);
            }
            headers.put("Authentication", HttpConfig.getConfig((String)"common.authentication"));
            headers.put("action", HttpConfig.getConfig((String)"common.account.action"));
            headers.put("serialNo", this.businessKey);
            headers.put("businessKey", this.businessKey);
            JanusHttpUtil.ResponseCus responseCus = JanusHttpUtil.doGetEntire((String)this.janusUrl, params, (boolean)false, headers);
            if (null == responseCus || !Objects.equals(responseCus.getStatus(), 200) || StringUtils.isBlank((CharSequence)responseCus.getBody())) {
                Thread.sleep(5000L);
                responseCus = JanusHttpUtil.doGetEntire((String)this.janusUrl, params, (boolean)false, headers);
                if (null == responseCus || !Objects.equals(responseCus.getStatus(), 200) || StringUtils.isBlank((CharSequence)responseCus.getBody())) {
                    XxlJobLogger.log((String)"\u83b7\u53d6\u8d26\u53f7\u5931\u8d25", (Object[])new Object[0]);
                    ReturnT returnT = FAIL;
                    return returnT;
                }
            }
            if (null == (accountResponse = (CollectAccountResponse)JacksonUtil.getInstance().fromJson(responseCus.getBody(), CollectAccountResponse.class)) || CollectionUtils.isEmpty(accountResponse.getResult())) {
                XxlJobLogger.log((String)("\u8d26\u53f7\u89e3\u6790\u5931\u8d25:" + responseCus.getBody()), (Object[])new Object[0]);
                ReturnT returnT = FAIL;
                return returnT;
            }
            List<CollectAccountDto> accounts = accountResponse.getResult();
            log.info("\u91c7\u96c6\u5b50\u4efb\u52a1\u603b\u6570:" + accounts.size());
            XxlJobLogger.log((String)("\u91c7\u96c6\u5b50\u4efb\u52a1\u603b\u6570:" + accounts.size()), (Object[])new Object[0]);
            XxlJobLogger.log((String)("\u5f00\u59cb\u91c7\u96c6\u4efb\u52a1:" + xxlLogId), (Object[])new Object[0]);
            threadGroupNum = null == threadGroupNum && null != this.threadNum ? this.threadNum : Integer.valueOf(1);
            if (CollectionUtils.isEmpty(accounts)) {
                XxlJobLogger.log((String)"\u672a\u5339\u914d\u5230\u8d26\u53f7\u4efb\u52a1", (Object[])new Object[0]);
                ReturnT returnT = FAIL;
                return returnT;
            }
            ArrayList<AccountTemplateDO> accountTasks = new ArrayList<AccountTemplateDO>();
            ArrayList<CollectParam> collectParams = new ArrayList<CollectParam>();
            for (CollectAccountDto accountDto : accounts) {
                try {
                    int randomNum = (int)(Math.random() * 999.0) + 1;
                    String taskTime = DateFormatUtil.getCurrentFormatDateTime();
                    String orgId = StringUtils.isNotBlank((CharSequence)recordId) ? recordId : MD5Util.getHexMD5Str((String)(accountDto.getAccountId() + accountDto.getBillId() + accountDto.getPurchaseRetailerId() + accountDto.getKaCode() + accountDto.getBelongTenant() + taskTime + randomNum), (int)32);
                    AccountTemplateDO accountTemplateDO = this.genAccount(accountDto, json, jobHandlerParam);
                    if (StringUtils.isNotBlank((CharSequence)accountTemplateDO.getAccountId()) && StringUtils.isNotBlank((CharSequence)accountTemplateDO.getAccountName())) {
                        CommonDataHelper.ACCOUNT_NAME_MAP.put(accountTemplateDO.getAccountId(), accountTemplateDO.getAccountName());
                    }
                    accountTemplateDO.setGenTaskId(orgId);
                    accountTemplateDO.setJanusOperator(janusOperator);
                    if (StringUtils.isBlank((CharSequence)accountId)) {
                        if (StringUtils.isNotBlank((CharSequence)collectType) && !Objects.equals(collectType, accountTemplateDO.getCollectType())) {
                            XxlJobLogger.log((String)"\u8d26\u53f7:{},0\u4efb\u52a1collectType:{},\u8d26\u53f7\u6267\u884c\u53c2\u6570collectType:{},\u4e24\u8005\u4e0d\u4e00\u81f4\uff0c\u672c\u6b21\u4efb\u52a1\u4e0d\u6267\u884c\uff01", (Object[])new Object[]{accountTemplateDO.getAccountName(), collectType, accountTemplateDO.getCollectType()});
                            continue;
                        }
                        if (StringUtils.isNotBlank((CharSequence)accountTemplateDO.getCollectType()) && !Objects.equals(collectType, accountTemplateDO.getCollectType())) {
                            XxlJobLogger.log((String)"\u8d26\u53f7:{},1\u4efb\u52a1collectType:{},\u8d26\u53f7\u6267\u884c\u53c2\u6570collectType:{},\u4e24\u8005\u4e0d\u4e00\u81f4\uff0c\u672c\u6b21\u4efb\u52a1\u4e0d\u6267\u884c\uff01", (Object[])new Object[]{accountTemplateDO.getAccountName(), collectType, accountTemplateDO.getCollectType()});
                            continue;
                        }
                    }
                    accountTemplateDO.setTaskTime(taskTime);
                    accountTasks.add(accountTemplateDO);
                    CountUtils.TASK_IDS.add(orgId);
                    CollectParam collectParam = new CollectParam(accountTemplateDO.getAccountId(), "init", "\u521d\u59cb\u5316\u4efb\u52a1", accountTemplateDO.getTaskTime(), "", xxlJobId, xxlLogId, xxlAddress, xxlTime, xxlJobType, janusOperator, 0);
                    collectParam.setOrgId(orgId);
                    collectParams.add(collectParam);
                }
                catch (Exception e) {
                    XxlJobLogger.log((String)"\u8d26\u53f7:{},\u8d26\u53f7\u4efb\u52a1\u6570\u636e\u89e3\u6790\u5931\u8d25:{}", (Object[])new Object[]{accountDto.getCollectionAccount(), ErrorUtil.getStackMsg((Exception)e)});
                    if (!(e instanceof PasswordErrorException)) continue;
                    this.lockAccount(accountDto.getAccountId());
                }
            }
            if (CollectionUtils.isEmpty(accountTasks)) {
                XxlJobLogger.log((String)"\u672a\u5339\u914d\u5230\u8d26\u53f7\u4efb\u52a1~", (Object[])new Object[0]);
                ReturnT returnT = FAIL;
                return returnT;
            }
            boolean uploadFlag = CollectRecordHandler.uploadRecord(collectParams);
            if (!uploadFlag) {
                CollectAccountDto accountDto;
                XxlJobLogger.log((String)"\u521d\u59cb\u91c7\u96c6\u5c65\u5386\u4e0a\u62a5\u5931\u8d25~,\u8bf7\u6c42\u6d41\u6c34\u53f7:{}", (Object[])new Object[]{MD5Util.getHexMD5Str((String)JacksonUtil.getInstance().toJson(params), (int)32)});
                accountDto = FAIL;
                return accountDto;
            }
            Map<String, List<AccountTemplateDO>> groupMap = AccountGrouper.groupAccounts(accountTasks);
            LinkedBlockingQueue<List<AccountTemplateDO>> queue = new LinkedBlockingQueue<List<AccountTemplateDO>>();
            int threadNum = Math.min(threadGroupNum, groupMap.size());
            for (List list : groupMap.values()) {
                queue.offer(list);
            }
            TaskThread.ossService = this.ossService;
            TaskThread.taskProducer = this.taskProducer;
            TaskThread.janusUrl = this.janusUrl;
            TaskThread.redissonLock = this.redissonLock;
            for (int i = 0; i < threadNum; ++i) {
                new TaskThread(queue, paramStr, dcsJobHandler, this, resultMap).start();
            }
            int waitSeconds = 43200;
            if (StringUtils.isNotBlank((CharSequence)waitTimeMinutes) && StringUtils.isNumeric((CharSequence)waitTimeMinutes)) {
                waitSeconds = Integer.parseInt(waitTimeMinutes) * 60;
            }
            if (waitSeconds <= 0) {
                waitSeconds = 43200;
            }
            boolean bl = false;
            int wt = 0;
            while (!queue.isEmpty() || resultMap.size() != accountTasks.size()) {
                if (++wt % 10 == 0) {
                    XxlJobLogger.log((String)"\u4efb\u52a1\u6267\u884c\u4e2d\uff0c\u9884\u8ba1\u4efb\u52a1\u6570:{},\u5f53\u524d\u5b8c\u6210\u4efb\u52a1\u6570:{}", (Object[])new Object[]{accountTasks.size(), resultMap.size()});
                }
                int s = BaseUtils.randomLong(5, 3);
                Thread.sleep(s);
                if ((var37_55 += s / 1000) <= waitSeconds) continue;
                break;
            }
            XxlJobLogger.log((String)"\u4efb\u52a1\u6267\u884c\u5b8c\u6210\uff0c\u9884\u8ba1\u4efb\u52a1\u6570:{},\u5b9e\u9645\u4efb\u52a1\u6570:{}", (Object[])new Object[]{accountTasks.size(), resultMap.size()});
        }
        catch (Exception ex) {
            XxlJobLogger.log((String)("\u83b7\u53d6\u8d26\u53f7\u5f02\u5e38 " + ex.getMessage() + ",params:" + JacksonUtil.getInstance().toJson(params) + ",headers:" + JacksonUtil.getInstance().toJson(headers)), (Object[])new Object[0]);
            ExceptionDdNoticer.loggerError(log, "\u83b7\u53d6\u8d26\u53f7\u5f02\u5e38 \u4efb\u52a1\u53c2\u6570: {}, {}", paramStr, ex.getMessage());
            ReturnT returnT = FAIL;
            return returnT;
        }
        finally {
            if (null != executorGroupService) {
                executorGroupService.shutdown();
            }
        }
        boolean isSuccess = true;
        for (String key : resultMap.keySet()) {
            if (Objects.equals(resultMap.get(key), "true")) {
                XxlJobLogger.log((String)("ID+\u8d26\u53f7\u91c7\u96c6\u6210\u529f" + key), (Object[])new Object[0]);
                continue;
            }
            isSuccess = false;
            XxlJobLogger.log((String)("ID+\u8d26\u53f7\u91c7\u96c6\u5931\u8d25" + key), (Object[])new Object[0]);
        }
        return isSuccess ? SUCCESS : FAIL;
    }

    private void lockAccount(String accountId) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("Authentication", HttpConfig.getConfig((String)"common.authentication"));
        headers.put("action", HttpConfig.getConfig((String)"common.lockAccount.action"));
        headers.put("serialNo", accountId);
        headers.put("businessKey", accountId);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("doJanusLock", "true");
        try {
            JanusHttpUtil.doGetEntire((String)this.janusUrl, params, (boolean)false, headers);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    private DcsJobHandler getDcsJobHandler() {
        DcsJobHandler dcsJobHandler = ((Object)((Object)this)).getClass().getAnnotation(DcsJobHandler.class);
        if (dcsJobHandler == null) {
            throw new RuntimeException("\u672a\u627e\u5230DcsJobHandler\u6ce8\u89e3");
        }
        return dcsJobHandler;
    }

    private JobHandlerParam getJobHandlerParam() {
        JobHandlerParam jobHandlerParam = ((Object)((Object)this)).getClass().getAnnotation(JobHandlerParam.class);
        if (jobHandlerParam == null) {
            return null;
        }
        return jobHandlerParam;
    }

    private AccountTemplateDO genAccount(CollectAccountDto accountDto, JSONObject extra, JobHandlerParam jobHandlerParam) {
        long times;
        JSONObject jobExtraInfo;
        String jobExtra = accountDto.getJobExtraInfo();
        String siteUrl = null;
        String retailKey = null;
        String retail = null;
        if (StringUtils.isBlank((CharSequence)jobExtra)) {
            jobExtraInfo = new JSONObject();
        } else {
            jobExtraInfo = JSONObject.parseObject((String)jobExtra);
            jobExtraInfo = null == jobExtraInfo ? new JSONObject() : jobExtraInfo;
            siteUrl = jobExtraInfo.getString("siteUrl");
            retailKey = jobExtraInfo.getString("retailKey");
            retail = jobExtraInfo.getString("retail");
        }
        String printStatus = jobExtraInfo.getString("printStatus");
        Boolean retailExist = StringUtils.isBlank((CharSequence)accountDto.getPurchaseRetailerId());
        jobExtraInfo.putAll((Map)extra);
        AccountTemplateDO account = (AccountTemplateDO)jobExtraInfo.to(AccountTemplateDO.class, new JSONReader.Feature[0]);
        account.setSiteUrl(StringUtils.isNotBlank((CharSequence)siteUrl) ? siteUrl : accountDto.getSiteUrl());
        account.setAccountId(accountDto.getAccountId());
        account.setAccountName(accountDto.getCollectionAccount());
        account.setAccountPassword(this.getPassword(accountDto.getAccountSecretKey()));
        account.setRetailKey(retailExist != false ? jobHandlerParam.retail().getKey() : accountDto.getPurchaseRetailerId());
        account.setRetail(retailExist != false ? jobHandlerParam.retail().getLabel() : accountDto.getPurchaseRetailerName());
        if (StringUtils.isNotBlank((CharSequence)accountDto.getBelongTenant()) && StringUtils.isNumeric((CharSequence)accountDto.getBelongTenant())) {
            account.setTenantId(Long.parseLong(accountDto.getBelongTenant()));
        } else {
            account.setTenantId(0L);
        }
        String projectKey = jobExtraInfo.getString("projectKey");
        account.setProject(StringUtils.isNotBlank((CharSequence)projectKey) ? projectKey : accountDto.getKaCode());
        account.setProjectKey(StringUtils.isNotBlank((CharSequence)projectKey) ? projectKey : accountDto.getKaCode());
        if (null == accountDto.getEffectiveDateFrom()) {
            times = System.currentTimeMillis() - 3600000L;
            accountDto.setEffectiveDateFrom(times);
        }
        if (null == accountDto.getEffectiveDateTo()) {
            times = System.currentTimeMillis() + 2592000000L;
            accountDto.setEffectiveDateTo(times);
        }
        account.setDragValidityDateEnd(new Date(accountDto.getEffectiveDateTo()));
        account.setDragValidityDateStart(new Date(accountDto.getEffectiveDateFrom()));
        account.setMarketAccountId(StringUtils.isNotBlank((CharSequence)accountDto.getMarketAccountId()) ? accountDto.getMarketAccountId() : accountDto.getAccountId());
        if (StringUtils.isNotBlank((CharSequence)retailKey)) {
            account.setRetailKey(retailKey);
        }
        if (StringUtils.isNotBlank((CharSequence)retail)) {
            account.setRetail(retail);
        }
        if (null != account.getPrintStatus() && !account.getPrintStatus().booleanValue() && Objects.equals(printStatus, "1")) {
            account.setPrintStatus(true);
        }
        account.setBillsName(accountDto.getBillName());
        account.setBillsType(accountDto.getBillType());
        account.setJobExtraInfo(accountDto.getJobExtraInfo());
        account.setForceLogout(accountDto.getForceLogout());
        String statusDes = "";
        if (Objects.equals(accountDto.getAccountLock(), 1)) {
            statusDes = "\u8d26\u53f7\u9501\u5b9a";
        }
        if (Objects.equals(accountDto.getBillLock(), 1)) {
            statusDes = "\u5355\u636e\u9501\u5b9a";
        }
        if (Objects.equals(accountDto.getMarketLock(), 1)) {
            statusDes = "\u5546\u8d85\u9501\u5b9a";
        }
        account.setJanusStatusDes(statusDes);
        return account;
    }

    private String getPassword(String encrypted) {
        if (StringUtils.isBlank((CharSequence)encrypted)) {
            throw new PasswordErrorException("\u8d26\u53f7\u5bc6\u7801\u4e3a\u7a7a");
        }
        try {
            return AesUtil.aesDecrypt(encrypted, this.aesKey);
        }
        catch (Exception ex) {
            throw new PasswordErrorException("\u8d26\u53f7\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25 " + ex.getMessage());
        }
    }

    protected abstract AbstractLoginSys getLoginSys();

    protected abstract List<String> doCollect(WebClient var1, AccountTemplateDO var2, Map<String, String> var3) throws Exception;

    protected String getCharset() {
        return "utf-8";
    }

    public static String readFileToString(String filePath) throws IOException {
        StringBuilder content = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            while ((line = reader.readLine()) != null) {
                content.append(line).append("\n");
            }
        }
        return content.toString();
    }

    public static void main(String[] args) throws IOException {
        String body = BaseDcsHandler.readFileToString("/Users/gongjianfeng/Downloads/account.txt");
        CollectAccountResponse accountResponse = (CollectAccountResponse)JacksonUtil.getInstance().fromJson(body, CollectAccountResponse.class);
        List<CollectAccountDto> accounts = accountResponse.getResult();
        ArrayList<AccountTemplateDO> accountTasks = new ArrayList<AccountTemplateDO>();
        ArrayList collectParams = new ArrayList();
        CharSequence collectType = null;
        CharSequence accountId = null;
        for (CollectAccountDto accountDto : accounts) {
            try {
                int randomNum = (int)(Math.random() * 999.0) + 1;
                String taskTime = DateFormatUtil.getCurrentFormatDateTime();
                AccountTemplateDO expAccount = BaseDcsHandler.genAccountDiy(accountDto);
                if (StringUtils.isNotBlank((CharSequence)expAccount.getAccountId()) && StringUtils.isNotBlank((CharSequence)expAccount.getAccountName())) {
                    CommonDataHelper.ACCOUNT_NAME_MAP.put(expAccount.getAccountId(), expAccount.getAccountName());
                }
                if (StringUtils.isBlank(accountId)) {
                    if (StringUtils.isNotBlank(collectType) && !Objects.equals(collectType, expAccount.getCollectType())) {
                        XxlJobLogger.log((String)"\u8d26\u53f7:{},0\u4efb\u52a1collectType:{},\u8d26\u53f7\u6267\u884c\u53c2\u6570collectType:{},\u4e24\u8005\u4e0d\u4e00\u81f4\uff0c\u672c\u6b21\u4efb\u52a1\u4e0d\u6267\u884c\uff01", (Object[])new Object[]{expAccount.getAccountName(), collectType, expAccount.getCollectType()});
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)expAccount.getCollectType()) && !Objects.equals(collectType, expAccount.getCollectType())) {
                        XxlJobLogger.log((String)"\u8d26\u53f7:{},1\u4efb\u52a1collectType:{},\u8d26\u53f7\u6267\u884c\u53c2\u6570collectType:{},\u4e24\u8005\u4e0d\u4e00\u81f4\uff0c\u672c\u6b21\u4efb\u52a1\u4e0d\u6267\u884c\uff01", (Object[])new Object[]{expAccount.getAccountName(), collectType, expAccount.getCollectType()});
                        continue;
                    }
                }
                expAccount.setTaskTime(taskTime);
                accountTasks.add(expAccount);
            }
            catch (Exception exception) {}
        }
        Map<String, List<AccountTemplateDO>> groupMap = AccountGrouper.groupAccounts(accountTasks);
        LinkedBlockingQueue<List<AccountTemplateDO>> queue = new LinkedBlockingQueue<List<AccountTemplateDO>>();
        for (List<AccountTemplateDO> values : groupMap.values()) {
            queue.offer(values);
        }
    }

    private static AccountTemplateDO genAccountDiy(CollectAccountDto accountDto) {
        long times;
        JSONObject jobExtraInfo;
        String jobExtra = accountDto.getJobExtraInfo();
        String siteUrl = null;
        String retailKey = null;
        String retail = null;
        if (StringUtils.isBlank((CharSequence)jobExtra)) {
            jobExtraInfo = new JSONObject();
        } else {
            jobExtraInfo = JSONObject.parseObject((String)jobExtra);
            jobExtraInfo = null == jobExtraInfo ? new JSONObject() : jobExtraInfo;
            siteUrl = jobExtraInfo.getString("siteUrl");
            retailKey = jobExtraInfo.getString("retailKey");
            retail = jobExtraInfo.getString("retail");
        }
        String printStatus = jobExtraInfo.getString("printStatus");
        AccountTemplateDO account = (AccountTemplateDO)jobExtraInfo.to(AccountTemplateDO.class, new JSONReader.Feature[0]);
        account.setSiteUrl(StringUtils.isNotBlank((CharSequence)siteUrl) ? siteUrl : accountDto.getSiteUrl());
        account.setAccountId(accountDto.getAccountId());
        account.setAccountName(accountDto.getCollectionAccount());
        account.setAccountPassword(accountDto.getAccountSecretKey());
        if (StringUtils.isNotBlank((CharSequence)accountDto.getBelongTenant()) && StringUtils.isNumeric((CharSequence)accountDto.getBelongTenant())) {
            account.setTenantId(Long.parseLong(accountDto.getBelongTenant()));
        } else {
            account.setTenantId(0L);
        }
        String projectKey = jobExtraInfo.getString("projectKey");
        account.setProject(StringUtils.isNotBlank((CharSequence)projectKey) ? projectKey : accountDto.getKaCode());
        account.setProjectKey(StringUtils.isNotBlank((CharSequence)projectKey) ? projectKey : accountDto.getKaCode());
        if (null == accountDto.getEffectiveDateFrom()) {
            times = System.currentTimeMillis() - 3600000L;
            accountDto.setEffectiveDateFrom(times);
        }
        if (null == accountDto.getEffectiveDateTo()) {
            times = System.currentTimeMillis() + 2592000000L;
            accountDto.setEffectiveDateTo(times);
        }
        account.setDragValidityDateEnd(new Date(accountDto.getEffectiveDateTo()));
        account.setDragValidityDateStart(new Date(accountDto.getEffectiveDateFrom()));
        account.setMarketAccountId(StringUtils.isNotBlank((CharSequence)accountDto.getMarketAccountId()) ? accountDto.getMarketAccountId() : accountDto.getAccountId());
        if (StringUtils.isNotBlank((CharSequence)retailKey)) {
            account.setRetailKey(retailKey);
        }
        if (StringUtils.isNotBlank((CharSequence)retail)) {
            account.setRetail(retail);
        }
        if (null != account.getPrintStatus() && !account.getPrintStatus().booleanValue() && Objects.equals(printStatus, "1")) {
            account.setPrintStatus(true);
        }
        account.setBillsName(accountDto.getBillName());
        account.setBillsType(accountDto.getBillType());
        account.setJobExtraInfo(accountDto.getJobExtraInfo());
        return account;
    }
}

