/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import java.io.File;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class Excel2HtmlUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertExcelToHtml(String excelPath) throws Exception {
        String htmlContent;
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((File)new File(excelPath));
            Sheet sheet = workbook.getSheetAt(0);
            htmlContent = Excel2HtmlUtils.convertExcelToHtml(sheet);
        }
        finally {
            if (null != workbook) {
                workbook.close();
            }
        }
        return htmlContent;
    }

    public static String convertExcelToHtml(Sheet sheet) {
        StringBuilder html = new StringBuilder();
        html.append("<!DOCTYPE html>\n").append("<html>\n").append("<head>\n").append("<meta charset=\"UTF-8\">\n").append("<style>\n").append("table { border-collapse: collapse; width: 100%; }\n").append("th, td { border: 1px solid black; padding: 8px; text-align: left; }\n").append("th { background-color: #f2f2f2; }\n").append("</style>\n").append("</head>\n").append("<body>\n").append("<table>\n");
        Row headerRow = sheet.getRow(0);
        if (headerRow != null) {
            html.append("<tr>");
            for (Cell cell : headerRow) {
                html.append("<th>").append(Excel2HtmlUtils.getCellValueAsString(cell)).append("</th>");
            }
            html.append("</tr>\n");
        }
        for (int i = 1; i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            html.append("<tr>");
            for (Cell cell : row) {
                html.append("<td>").append(Excel2HtmlUtils.getCellValueAsString(cell)).append("</td>");
            }
            html.append("</tr>\n");
        }
        html.append("</table>\n").append("</body>\n").append("</html>");
        return html.toString();
    }

    private static String getCellValueAsString(Cell cell) {
        if (cell == null) {
            return "";
        }
        switch (CellType.forInt((int)cell.getCellType())) {
            case STRING: {
                return Excel2HtmlUtils.escapeHtml(cell.getStringCellValue());
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue().toString();
                }
                return String.valueOf(cell.getNumericCellValue());
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case FORMULA: {
                return cell.getCellFormula();
            }
        }
        return "";
    }

    private static String escapeHtml(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#39;");
    }
}

