/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.account;

import com.gargoylesoftware.htmlunit.ProxyConfig;
import com.gargoylesoftware.htmlunit.WebClient;
import com.google.common.base.Splitter;
import com.xforceplus.account.LoginCheckUtil;
import com.xforceplus.account.cache.LoginCache;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.account.domain.LoginTokenInfo;
import com.xforceplus.apollo.utils.DateFormatUtil;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.apollo.utils.MD5Util;
import com.xforceplus.core.ILoginSys;
import com.xforceplus.core.enums.IntConstant;
import com.xforceplus.core.notice.ExceptionDdNoticer;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.lock.redisson.RedissonLock;
import com.xforceplus.proxy.ProxyIpFactory;
import com.xforceplus.proxy.domain.IpResponse;
import com.xforceplus.utils.BaseUtils;
import com.xforceplus.utils.Constant;
import com.xforceplus.utils.HttpRequestUtil;
import com.xforceplus.utils.SpringContext;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoginSys
implements ILoginSys {
    private static final Logger log = LoggerFactory.getLogger(AbstractLoginSys.class);
    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static RedissonLock redissonLock = null;

    public WebClient doLogin(@Valid AccountTemplateDO account, Map<String, String> contextMap) throws IOException {
        if (!this.checkLoginParam(account)) {
            return null;
        }
        if (this.needLoginCache(account)) {
            XxlJobLogger.log((String)"\u5f53\u524d\u8d26\u6237\u4e0d\u4f7f\u7528\u767b\u5f55\u7f13\u5b58...{}", (Object[])new Object[]{account.getAccountName()});
            return this.login(account, contextMap);
        }
        String siteUrl = account.getSiteUrl().trim();
        String protocolName = HttpRequestUtil.getWebProtocol(siteUrl, "", "http://");
        contextMap.put("protocolName", protocolName);
        LoginTokenInfo loginTokenInfo = this.fetchLoginCache(account);
        if (loginTokenInfo != null) {
            WebClient webClient = this.verifyToken(account, loginTokenInfo, contextMap);
            if (null != webClient) {
                XxlJobLogger.log((String)"\u4f7f\u7528\u767b\u5f55\u7f13\u5b58\u6210\u529f,\u6267\u884c\u4e1a\u52a1\u64cd\u4f5c...", (Object[])new Object[0]);
                return webClient;
            }
            if (this.tokenInNotLogin(account, loginTokenInfo)) {
                throw new RuntimeException("token\u83b7\u53d6\u65f6\u95f4:" + loginTokenInfo.getCreatedTime() + ",\u8fd8\u672a\u8d85\u65f6\uff0c\u4e0d\u4f5c\u767b\u9646\u5904\u7406\uff01");
            }
            XxlJobLogger.log((String)"\u9a8c\u8bc1\u767b\u5f55\u7f13\u5b58\u5931\u8d25(token\u5df2\u8fc7\u671f\u6216\u672a\u91cd\u5199verifyToken\u65b9\u6cd5),\u91cd\u65b0\u6267\u884c\u767b\u5f55\u64cd\u4f5c...", (Object[])new Object[0]);
            return this.loginSync(account, contextMap);
        }
        XxlJobLogger.log((String)"\u767b\u5f55\u7f13\u5b58\u5931\u6548,\u6267\u884c\u767b\u5f55\u64cd\u4f5c...{}", (Object[])new Object[]{account.getAccountName()});
        return this.loginSync(account, contextMap);
    }

    private boolean tokenInNotLogin(AccountTemplateDO account, LoginTokenInfo loginTokenInfo) {
        LocalDateTime date2;
        LocalDateTime date1;
        long minutesDiff;
        boolean flag = false;
        if (null != account.getOutCacheMinutes() && account.getOutCacheMinutes() > 0 && StringUtils.isNotBlank((CharSequence)loginTokenInfo.getCreatedTime()) && (minutesDiff = Math.abs(Duration.between(date1 = LocalDateTime.parse(loginTokenInfo.getCreatedTime(), this.formatter), date2 = LocalDateTime.parse(DateFormatUtil.getCurrentFormatDateTime(), this.formatter)).toMinutes())) < (long)account.getOutCacheMinutes().intValue()) {
            flag = true;
        }
        return flag;
    }

    public static String loginCacheKey(AccountTemplateDO account) {
        StringBuilder stringBuilder = new StringBuilder(account.getMarketAccountId());
        try {
            List keys;
            Map accountMap;
            String loginCacheKey = (String)HttpConfig.getConfig((String)"login_cache_key");
            if (StringUtils.isNotBlank((CharSequence)loginCacheKey) && MapUtils.isNotEmpty((Map)(accountMap = JacksonUtil.getInstance().convertToMap((Object)account, String.class, Object.class))) && CollectionUtils.isNotEmpty((Collection)(keys = Splitter.on((String)",").splitToList((CharSequence)loginCacheKey)))) {
                for (String key : keys) {
                    stringBuilder.append((Object)accountMap.getOrDefault(key, "null"));
                }
            }
        }
        catch (Exception e) {
            XxlJobLogger.log((String)ErrorUtil.getStackMsg((Exception)e), (Object[])new Object[0]);
        }
        return MD5Util.getHexMD5Str((String)stringBuilder.toString(), (int)32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private WebClient loginSync(AccountTemplateDO account, Map<String, String> contextMap) throws IOException {
        WebClient webClient;
        if (null == redissonLock) {
            redissonLock = SpringContext.getBean(RedissonLock.class);
        }
        XxlJobLogger.log((String)"\u6267\u884c\u767b\u5f55\u64cd\u4f5c...", (Object[])new Object[0]);
        String lockKey = "dcs:common:login:lock:" + account.getMarketAccountId();
        boolean lock = Objects.equals(account.getForceLogout(), 0) && (null == account.getLoginCacheMinutes() || account.getLoginCacheMinutes() <= 0) ? true : redissonLock.lock(lockKey, IntConstant.HUNDRED);
        if (lock) {
            try {
                webClient = this.login(account, contextMap);
                if (webClient == null || !MapUtils.isNotEmpty(contextMap) || !contextMap.containsKey("DCS_TOKEN_MAP_KEY_" + account.getMarketAccountId())) return webClient;
                LoginCache.getInstance().addCacheToken(AbstractLoginSys.loginCacheKey(account), new LoginTokenInfo(contextMap.get("DCS_TOKEN_MAP_KEY_" + account.getMarketAccountId()), account.getLoginCacheMinutes()));
                return webClient;
            }
            finally {
                redissonLock.release(lockKey);
            }
        } else {
            boolean bool = redissonLock.isLock(lockKey);
            for (int i = IntConstant.ZERO; i < Constant.WAIT_TOKEN_WAIT_TIMES && bool; ++i) {
                try {
                    Thread.sleep(BaseUtils.randomLong(15, 10));
                    bool = redissonLock.isLock(lockKey);
                    continue;
                }
                catch (InterruptedException e) {
                    XxlJobLogger.log((String)"\u91c7\u96c6\u767b\u5f55\u7f13\u5b58\u52a0\u9501\u51fa\u73b0\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5\u9501{}\u60c5\u51b5", (Object[])new Object[]{lockKey});
                    return null;
                }
            }
            if (bool) {
                XxlJobLogger.log((String)"\u91c7\u96c6\u767b\u5f55\u7f13\u5b58\u52a0\u9501\u51fa\u73b0\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5\u9501{}\u60c5\u51b5", (Object[])new Object[]{lockKey});
                return null;
            }
            LoginTokenInfo tokenInfo = LoginCache.getInstance().getCacheToken(AbstractLoginSys.loginCacheKey(account));
            if (null == tokenInfo) {
                throw new RuntimeException("\u672a\u83b7\u53d6\u5230\u767b\u9646\u9501\uff0c\u4e14\u7b49\u5f85150s\u672a\u83b7\u53d6\u5230\u767b\u9646\u7f13\u5b58\u3002");
            }
            XxlJobLogger.log((String)"\u5f53\u524d\u88ab\u5176\u4ed6\u7ebf\u7a0b\u62a2\u5360\u767b\u5f55\u64cd\u4f5c,\u7b49\u5f85\u5176\u4ed6\u7ebf\u7a0b\u91ca\u653e\u767b\u5f55\u9501\u540e,\u91cd\u65b0\u83b7\u53d6\u7f13\u5b58,\u76f4\u63a5\u4f7f\u7528...", (Object[])new Object[0]);
            webClient = this.verifyToken(account, tokenInfo, contextMap);
            if (null != webClient) return webClient;
            XxlJobLogger.log((String)("token\u68c0\u9a8c\u5931\u8d25\uff0c\u672c\u6b21\u4efb\u52a1\u7ec8\u6b62." + JacksonUtil.getInstance().toJson((Object)tokenInfo)), (Object[])new Object[0]);
            throw new RuntimeException("token\u68c0\u9a8c\u5931\u8d25\uff0c\u672c\u6b21\u4efb\u52a1\u7ec8\u6b62.");
        }
    }

    public WebClient pushProxy(WebClient webClient, AccountTemplateDO account) {
        if (account.getIpProxy() != null && account.getIpProxy() == 1) {
            String ipProxyCacheKey = "local_ip_proxy_key_" + AbstractLoginSys.loginCacheKey(account);
            IpResponse proxyConfig = ProxyIpFactory.getRemoteIpProxy(account.getAccountId(), account.getProxyArea(), MD5Util.getHexMD5Str((String)(StringUtils.isNotBlank((CharSequence)account.getRetailKey()) ? account.getRetailKey() : account.getSiteUrl()), (int)32), account.getProxyForm(), ipProxyCacheKey);
            if (proxyConfig != null && StringUtils.isNotBlank((CharSequence)proxyConfig.getIp()) && StringUtils.isNotBlank((CharSequence)proxyConfig.getPort())) {
                String proxyIp = proxyConfig.getIp();
                String proxyPort = proxyConfig.getPort();
                XxlJobLogger.log((String)"\u767b\u5f55\u4f7f\u7528\u4ee3\u7406IP\u3010{}:{}\u3011\uff01", (Object[])new Object[]{proxyIp, proxyPort});
                webClient.getOptions().setProxyConfig(new ProxyConfig(proxyIp, Integer.parseInt(proxyPort)));
                if (StringUtils.isNotBlank((CharSequence)proxyConfig.getBasicProxy())) {
                    webClient.addRequestHeader("Proxy-Authorization", proxyConfig.getBasicProxy());
                }
            } else {
                ExceptionDdNoticer.loggerError(log, "\u672a\u83b7\u53d6\u5230\u4ee3\u7406IP");
            }
        }
        return webClient;
    }

    private boolean checkLoginParam(AccountTemplateDO account) {
        return LoginCheckUtil.check(account);
    }

    private boolean needLoginCache(AccountTemplateDO account) {
        return account.getIsNeedLoginCache() == null || account.getIsNeedLoginCache() != 1;
    }

    private LoginTokenInfo fetchLoginCache(AccountTemplateDO account) {
        if (Objects.equals(account.getIsNeedLoginCache(), Constant.LOGIN_CACHE_YES)) {
            return LoginCache.getInstance().getCacheToken(AbstractLoginSys.loginCacheKey(account));
        }
        return null;
    }

    private void addLoginCache(AccountTemplateDO account, Object tokenValue) {
        if (Objects.equals(account.getIsNeedLoginCache(), Constant.LOGIN_CACHE_YES)) {
            LoginCache.getInstance().addCacheToken(AbstractLoginSys.loginCacheKey(account), new LoginTokenInfo(tokenValue, account.getLoginCacheMinutes()));
        }
    }

    public static void main(String[] args) {
        AccountTemplateDO templateDO = new AccountTemplateDO();
        templateDO.setAccountName("122");
        Map accountMap = JacksonUtil.getInstance().convertToMap((Object)templateDO, String.class, Object.class);
        System.out.println(accountMap.size());
    }
}

