/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.lock.redisson.strategy.impl;

import com.xforceplus.lock.constant.GlobalConstant;
import com.xforceplus.lock.redisson.config.RedissonProperties;
import com.xforceplus.lock.redisson.strategy.RedissonConfigStrategy;
import org.apache.commons.lang3.StringUtils;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentinelRedissonConfigStrategyImpl
implements RedissonConfigStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentinelRedissonConfigStrategyImpl.class);

    @Override
    public Config createRedissonConfig(RedissonProperties redissonProperties) {
        Config config = new Config();
        try {
            String address = redissonProperties.getAddress();
            String password = redissonProperties.getPassword();
            int database = redissonProperties.getDatabase();
            String[] addrTokens = address.split(",");
            String sentinelAliasName = addrTokens[0];
            config.useSentinelServers().setMasterName(sentinelAliasName);
            config.useSentinelServers().setDatabase(database);
            if (StringUtils.isNotBlank((CharSequence)password)) {
                config.useSentinelServers().setPassword(password);
            }
            for (int i = 1; i < addrTokens.length; ++i) {
                config.useSentinelServers().addSentinelAddress(new String[]{GlobalConstant.REDIS_CONNECTION_PREFIX.getConstant_value() + addrTokens[i]});
            }
            LOGGER.info("\u521d\u59cb\u5316[sentinel]\u65b9\u5f0fConfig,redisAddress:" + address);
        }
        catch (Exception var9) {
            LOGGER.error("sentinel Redisson init error", (Throwable)var9);
            var9.printStackTrace();
        }
        return config;
    }
}

