/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.proxy;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ProxyConfig;
import com.gargoylesoftware.htmlunit.WebClient;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.xforceplus.account.AbstractLoginSys;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.MD5Util;
import com.xforceplus.core.notice.ExceptionDdNoticer;
import com.xforceplus.janus.config.core.util.JanusHttpUtil;
import com.xforceplus.proxy.domain.IpBaseResponse;
import com.xforceplus.proxy.domain.IpResponse;
import com.xforceplus.utils.BaseUtils;
import com.xforceplus.utils.JsonUtils;
import com.xforceplus.utils.WebClientUtil;
import com.xxl.job.core.log.XxlJobLogger;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyIpFactory {
    private static final Logger log = LoggerFactory.getLogger(ProxyIpFactory.class);
    public static final String CACHE_KEY_PRE = "local_ip_proxy_key_";
    private static Cache<String, IpResponse> cache = CacheBuilder.newBuilder().maximumSize(2000L).expireAfterWrite(15L, TimeUnit.MINUTES).build();

    public static IpResponse getIpProxy(AccountTemplateDO account) {
        String ipProxyCacheKey = CACHE_KEY_PRE + AbstractLoginSys.loginCacheKey(account);
        IpResponse ipResponse = (IpResponse)cache.getIfPresent((Object)ipProxyCacheKey);
        if (null == ipResponse || StringUtils.isBlank((CharSequence)ipResponse.getIp())) {
            ipResponse = account.isIpRenew() ? ProxyIpFactory.getRemoteIpProxyWithRenew(account.getAccountId(), account.getProxyArea(), MD5Util.getHexMD5Str((String)(StringUtils.isNotBlank((CharSequence)account.getRetailKey()) ? account.getRetailKey() : account.getSiteUrl()), (int)32), account.getProxyForm(), ipProxyCacheKey) : ProxyIpFactory.getRemoteIpProxy(account.getAccountId(), account.getProxyArea(), MD5Util.getHexMD5Str((String)(StringUtils.isNotBlank((CharSequence)account.getRetailKey()) ? account.getRetailKey() : account.getSiteUrl()), (int)32), account.getProxyForm(), ipProxyCacheKey);
        } else if (account.isIpRenew()) {
            ipResponse = ProxyIpFactory.getRemoteIpProxyWithRenew(account.getAccountId(), account.getProxyArea(), MD5Util.getHexMD5Str((String)(StringUtils.isNotBlank((CharSequence)account.getRetailKey()) ? account.getRetailKey() : account.getSiteUrl()), (int)32), account.getProxyForm(), ipProxyCacheKey);
        }
        return ipResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validateProxy(String proxyIp, String proxyPort, String basicProxy) {
        WebClient webClient_tmp = WebClientUtil.getWebClient("");
        webClient_tmp.getOptions().setTimeout(3000);
        webClient_tmp.addRequestHeader("Cache-Control", "max-age=0,no-store");
        webClient_tmp.addRequestHeader("Pragma", "no-cache");
        if (StringUtils.isNotBlank((CharSequence)proxyIp) && StringUtils.isNotBlank((CharSequence)proxyPort)) {
            webClient_tmp.getOptions().setProxyConfig(new ProxyConfig(proxyIp, Integer.parseInt(proxyPort)));
            try {
                Page testProxyPage;
                String htmlString;
                if (StringUtils.isNotBlank((CharSequence)basicProxy)) {
                    webClient_tmp.addRequestHeader("Proxy-Authorization", basicProxy);
                }
                if ((htmlString = (testProxyPage = webClient_tmp.getPage("http://checkip-kjw.powere2e.com/?v=" + System.currentTimeMillis())).getWebResponse().getContentAsString()).contains("ok")) {
                    XxlJobLogger.log((String)"\u5b9d\u5c71IDC\u673a\u623f\u8bf7\u6c42\uff0c\u4ee3\u7406IP\u3010{}:{}\u3011\u6709\u6548\uff01", (Object[])new Object[]{proxyIp, proxyPort});
                    boolean bl = true;
                    return bl;
                }
                XxlJobLogger.log((String)"\u5b9d\u5c71IDC\u673a\u623f\u8bf7\u6c42\u5931\u8d25{}:{}", (Object[])new Object[]{proxyIp, proxyPort});
                testProxyPage = null;
                htmlString = null;
                testProxyPage = webClient_tmp.getPage("https://baidu.com/?v=" + System.currentTimeMillis());
                htmlString = testProxyPage.getWebResponse().getContentAsString();
                if (htmlString.contains("submit")) {
                    XxlJobLogger.log((String)"\u767e\u5ea6\u641c\u7d22\u8bf7\u6c42\uff0c\u4ee3\u7406IP\u3010{}:{}\u3011\u6709\u6548\uff01", (Object[])new Object[]{proxyIp, proxyPort});
                    boolean bl = true;
                    return bl;
                }
                XxlJobLogger.log((String)"\u767e\u5ea6\u641c\u7d22\u8bf7\u6c42\u5931\u8d25{}:{}", (Object[])new Object[]{proxyIp, proxyPort});
            }
            catch (Exception e) {
                XxlJobLogger.log((String)"\u4ee3\u7406IP\u3010{}:{}\u3011\u6709\u6548\u6027\u68c0\u67e5\u5f02\u5e38\uff01msg={}", (Object[])new Object[]{proxyIp, proxyPort, e.getMessage()});
                boolean bl = false;
                return bl;
            }
            finally {
                webClient_tmp.close();
            }
        }
        webClient_tmp.close();
        return false;
    }

    public static IpResponse getRemoteIpProxy(String accountKey, String area, String businessPlatform, String ipProxyPlatform, String ipProxyCacheKey) {
        boolean flag;
        IpResponse ipResponse = (IpResponse)cache.getIfPresent((Object)ipProxyCacheKey);
        if (null != ipResponse && (flag = ProxyIpFactory.validateProxy(ipResponse.getIp(), ipResponse.getPort(), ipResponse.getBasicProxy()))) {
            return ipResponse;
        }
        if (StringUtils.isBlank((CharSequence)BaseUtils.JANUS_TOKEN) || StringUtils.isBlank((CharSequence)BaseUtils.JANUS_URL) || StringUtils.isBlank((CharSequence)BaseUtils.IP_PROXY_ACTION)) {
            throw new RuntimeException("ip\u4ee3\u7406\u914d\u7f6e\u5f02\u5e38");
        }
        if (StringUtils.isBlank((CharSequence)ipProxyPlatform)) {
            ipProxyPlatform = BaseUtils.JANUS_IP_PROXY_PLAT;
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("authentication", BaseUtils.JANUS_TOKEN);
        header.put("serialNo", accountKey);
        header.put("accountKey", accountKey);
        header.put("action", BaseUtils.IP_PROXY_ACTION);
        try {
            for (int i = 0; i < 5; ++i) {
                boolean flag2;
                IpBaseResponse ipBaseResponse;
                JanusHttpUtil.ResponseCus responseCus;
                HashMap<String, String> params = new HashMap<String, String>();
                if (i > 0) {
                    params.put("retry", "true");
                }
                if (StringUtils.isNotBlank((CharSequence)area)) {
                    params.put("area", area);
                }
                if (StringUtils.isNotBlank((CharSequence)ipProxyPlatform)) {
                    params.put("platform", ipProxyPlatform);
                }
                if (StringUtils.isNotBlank((CharSequence)businessPlatform)) {
                    params.put("businessPlatform", businessPlatform);
                }
                if (null != (responseCus = JanusHttpUtil.doGetEntire((String)BaseUtils.JANUS_URL, params, (boolean)false, header)) && Objects.equals(responseCus.getStatus(), 200) && StringUtils.isNotBlank((CharSequence)responseCus.getBody()) && null != (ipBaseResponse = JsonUtils.toBean(responseCus.getBody(), IpBaseResponse.class)) && Objects.equals(ipBaseResponse.getCode(), "200") && null != ipBaseResponse.getResult() && (flag2 = ProxyIpFactory.validateProxy((ipResponse = ipBaseResponse.getResult()).getIp(), ipResponse.getPort(), ipResponse.getBasicProxy()))) {
                    cache.put((Object)ipProxyCacheKey, (Object)ipResponse);
                    return ipResponse;
                }
                Thread.sleep(3000L);
            }
        }
        catch (Exception e) {
            ExceptionDdNoticer.loggerError(log, ErrorUtil.getStackMsg((Exception)e));
        }
        XxlJobLogger.log((String)("\u672a\u83b7\u53d6\u5230\u6709\u6548\u5230\u4ee3\u7406IP,\u8d26\u53f7\u6807\u8bc6:" + accountKey), (Object[])new Object[0]);
        return null;
    }

    public static IpResponse getRemoteIpProxyWithRenew(String accountKey, String area, String businessPlatform, String ipProxyPlatform, String ipProxyCacheKey) {
        if (StringUtils.isBlank((CharSequence)BaseUtils.JANUS_TOKEN) || StringUtils.isBlank((CharSequence)BaseUtils.JANUS_URL) || StringUtils.isBlank((CharSequence)BaseUtils.IP_PROXY_ACTION)) {
            throw new RuntimeException("ip\u4ee3\u7406\u914d\u7f6e\u5f02\u5e38");
        }
        if (StringUtils.isBlank((CharSequence)ipProxyPlatform)) {
            ipProxyPlatform = BaseUtils.JANUS_IP_PROXY_PLAT;
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("authentication", BaseUtils.JANUS_TOKEN);
        header.put("serialNo", accountKey);
        header.put("accountKey", accountKey);
        header.put("action", BaseUtils.IP_PROXY_ACTION);
        try {
            for (int i = 0; i < 5; ++i) {
                IpResponse ipResponse;
                boolean flag;
                IpBaseResponse ipBaseResponse;
                JanusHttpUtil.ResponseCus responseCus;
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("retry", "true");
                if (StringUtils.isNotBlank((CharSequence)area)) {
                    params.put("area", area);
                }
                if (StringUtils.isNotBlank((CharSequence)ipProxyPlatform)) {
                    params.put("platform", ipProxyPlatform);
                }
                if (StringUtils.isNotBlank((CharSequence)businessPlatform)) {
                    params.put("businessPlatform", businessPlatform);
                }
                if (null != (responseCus = JanusHttpUtil.doGetEntire((String)BaseUtils.JANUS_URL, params, (boolean)false, header)) && Objects.equals(responseCus.getStatus(), 200) && StringUtils.isNotBlank((CharSequence)responseCus.getBody()) && null != (ipBaseResponse = JsonUtils.toBean(responseCus.getBody(), IpBaseResponse.class)) && Objects.equals(ipBaseResponse.getCode(), "200") && null != ipBaseResponse.getResult() && (flag = ProxyIpFactory.validateProxy((ipResponse = ipBaseResponse.getResult()).getIp(), ipResponse.getPort(), ipResponse.getBasicProxy()))) {
                    cache.put((Object)ipProxyCacheKey, (Object)ipResponse);
                    return ipResponse;
                }
                Thread.sleep(3000L);
            }
        }
        catch (Exception e) {
            ExceptionDdNoticer.loggerError(log, ErrorUtil.getStackMsg((Exception)e));
        }
        XxlJobLogger.log((String)("\u672a\u83b7\u53d6\u5230\u6709\u6548\u5230\u4ee3\u7406IP,\u8d26\u53f7\u6807\u8bc6:" + accountKey), (Object[])new Object[0]);
        return null;
    }

    public static boolean validateSiteUrl(AccountTemplateDO templateDO) {
        if (StringUtils.isBlank((CharSequence)templateDO.getCheckSiteUrl())) {
            return true;
        }
        if (templateDO.getIpProxy() != null && templateDO.getIpProxy() == 1) {
            IpResponse ipResponse = ProxyIpFactory.getIpProxy(templateDO);
            if (null == ipResponse || StringUtils.isBlank((CharSequence)ipResponse.getIp())) {
                return true;
            }
            return ProxyIpFactory.checkUrlWithProxy(templateDO.getCheckSiteUrl(), ipResponse.getIp(), Integer.parseInt(ipResponse.getPort()));
        }
        return ProxyIpFactory.isUrlAvailable(templateDO.getCheckSiteUrl());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isUrlAvailable(String url) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(30000).build();
            HttpHead request = new HttpHead(url);
            request.setConfig(requestConfig);
            request.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36");
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            XxlJobLogger.log((String)"url:{},\u68c0\u6d4b\u72b6\u6001\u7801:{}", (Object[])new Object[]{url, statusCode});
            boolean bl = statusCode < 500;
            return bl;
        }
        catch (Exception e) {
            XxlJobLogger.log((String)ErrorUtil.getStackMsg((Exception)e), (Object[])new Object[0]);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean checkUrlWithProxy(String url, String proxyHost, int proxyPort) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void main(String[] args) {
        AccountTemplateDO templateDO = new AccountTemplateDO();
        templateDO.setCheckSiteUrl("https://sc.ngs1685.com:8088/api/login");
        System.out.println(ProxyIpFactory.validateSiteUrl(templateDO));
    }
}

