/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.service.handler;

import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.apollo.utils.MD5Util;
import com.xforceplus.core.domain.CollectParam;
import com.xforceplus.core.domain.CollectRecordParam;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.config.core.util.JanusHttpUtil;
import com.xforceplus.utils.BaseUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectRecordHandler {
    private static final Logger logger = LoggerFactory.getLogger(CollectRecordHandler.class);
    private static AtomicBoolean init = new AtomicBoolean(false);
    private static ExecutorService executorService = new ThreadPoolExecutor(1, 1, 90L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private static AtomicBoolean running = new AtomicBoolean(false);
    private static BlockingQueue<CollectParam> queue = new LinkedBlockingQueue<CollectParam>(1000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        if (init.get()) {
            return;
        }
        AtomicBoolean atomicBoolean = init;
        synchronized (atomicBoolean) {
            if (init.get()) {
                return;
            }
            if (!running.get()) {
                CollectRecordHandler.start();
            }
            init.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void start() {
        AtomicBoolean atomicBoolean = running;
        synchronized (atomicBoolean) {
            if (running.get()) {
                return;
            }
            running.set(true);
            executorService.execute(() -> {
                ArrayList<CollectParam> params = new ArrayList<CollectParam>();
                while (running.get()) {
                    try {
                        CollectParam param = queue.take();
                        queue.drainTo(params, 10);
                        params.add(param);
                        CollectRecordHandler.uploadRecord(params);
                    }
                    catch (Exception e) {
                        logger.error(ErrorUtil.getStackMsg((Exception)e));
                    }
                    catch (Error error) {
                        logger.error(ErrorUtil.getStackMsg((Throwable)error));
                    }
                    finally {
                        params.clear();
                    }
                }
            });
        }
    }

    public static boolean uploadRecord(List<CollectParam> params) {
        try {
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put("Authentication", HttpConfig.getConfig((String)"common.authentication"));
            headers.put("action", HttpConfig.getConfig((String)"project.record.action"));
            String janusUrl = BaseUtils.JANUS_URL;
            if (StringUtils.isBlank((CharSequence)janusUrl)) {
                return false;
            }
            headers.put("serialNo", MD5Util.getHexMD5Str((String)JacksonUtil.getInstance().toJson(params), (int)32));
            JanusHttpUtil.ResponseCus responseCus = JanusHttpUtil.doPostJsonEntire((String)janusUrl, (String)JacksonUtil.getInstance().toJson((Object)new CollectRecordParam(params)), headers, new HashMap());
            if (null == responseCus || !Objects.equals(responseCus.getStatus(), 200)) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error(ErrorUtil.getStackMsg((Exception)e));
        }
        catch (Error error) {
            logger.error(ErrorUtil.getStackMsg((Throwable)error));
        }
        return true;
    }

    public static boolean uploadRecord(CollectParam message) {
        ArrayList<CollectParam> params = new ArrayList<CollectParam>();
        params.add(message);
        return CollectRecordHandler.uploadRecord(params);
    }

    public static boolean doHoldData(CollectParam message) {
        message.setTimes(message.getTimes() + 1);
        if (message.getTimes() > 5) {
            return false;
        }
        return CollectRecordHandler.offer(message);
    }

    private static boolean offer(CollectParam item) {
        if (!init.get()) {
            CollectRecordHandler.init();
        }
        return queue.offer(item);
    }
}

