/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.core.config.MessageDO;
import com.xforceplus.core.enums.RetailConstantEnum;
import com.xforceplus.core.enums.SupplierConstantEnum;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class JsonUtils {
    private static final String EMPTY = "";
    public static final ObjectMapper mapper = new ObjectMapper();

    public static String getJsonValue2String(JSONObject json, String name) {
        String value = json.getString(name);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value.replaceAll("\t", EMPTY).replaceAll("\n", EMPTY).replaceAll(" ", EMPTY).trim();
        }
        return EMPTY;
    }

    public static <T> T toBean(String json, Class<T> tClass) {
        try {
            return (T)mapper.readValue(json, tClass);
        }
        catch (IOException e) {
            XxlJobLogger.log((String)("json\u89e3\u6790\u51fa\u9519\uff1a" + json), (Object[])new Object[]{e});
            return null;
        }
    }

    public static <E> List<E> toList(String json, Class<E> eClass) {
        try {
            return (List)mapper.readValue(json, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, eClass));
        }
        catch (IOException e) {
            XxlJobLogger.log((String)("json\u89e3\u6790\u51fa\u9519\uff1a" + json), (Object[])new Object[]{e});
            return null;
        }
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj.getClass() == String.class) {
            return (String)obj;
        }
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            XxlJobLogger.log((String)("json\u5e8f\u5217\u5316\u51fa\u9519\uff1a" + obj), (Object[])new Object[]{e});
            return null;
        }
    }

    public static String messageSetValue(MessageDO msg, AccountTemplateDO account) {
        if (Objects.isNull(account)) {
            return EMPTY;
        }
        msg.setAccountName(account.getAccountName());
        msg.setBillsType(account.getBillsType());
        msg.setProjectKey(SupplierConstantEnum.getMergeSupplierMap().get(account.getProjectKey()));
        msg.setRetailKey(RetailConstantEnum.geLabelByKey(account.getRetailKey()));
        msg.setDcsStartDate(account.getDcsStartDate());
        return JSON.toJSONString((Object)msg);
    }

    public static String messagesSetValues(MessageDO msg, AccountTemplateDO account) {
        if (Objects.isNull(account)) {
            return EMPTY;
        }
        msg.setAccountName(account.getAccountName());
        msg.setBillsType(account.getBillsType());
        msg.setProjectKey(account.getProjectKey());
        msg.setRetailKey(account.getRetailKey());
        msg.setDcsStartDate(account.getDcsStartDate());
        return JSON.toJSONString((Object)msg);
    }
}

