/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.core.resolve;

import com.alibaba.fastjson2.JSON;
import com.xforceplus.apollo.janus.standalone.sdk.message.MessageSenderUtils;
import com.xforceplus.core.enums.BillsTypeEnum;
import com.xforceplus.core.resolve.ResolveTask;
import com.xforceplus.core.resolve.TaskQueueManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class TaskProducer {
    @Resource
    private TaskQueueManager manager;
    @Resource
    private MessageSenderUtils messageSenderUtils;

    public void addTask(ResolveTask task) throws InterruptedException {
        this.sendMessageBus(task);
        if (task.isResolveFlag()) {
            this.manager.addTask(task);
        }
    }

    private void sendMessageBus(ResolveTask task) {
        BillsTypeEnum billType = task.getJobBillType().getBillType();
        String eventType = String.format("eccpdcs-rawfile-%s", billType.getKey());
        HashMap<String, String> header = new HashMap<String, String>(8);
        header.put("sellerTenantId", String.valueOf(task.getTenantId()));
        header.put("sellerTenantCode", task.getTenantCode());
        header.put("retailerCode", task.getRetailKey());
        header.put("businessNo", String.format("%s-%s-%s-%s", task.getRetailKey(), task.getAccountName(), billType.getKey(), new SimpleDateFormat("yyMMddHH").format(new Date())));
        header.put("transNo", task.getTenantCode());
        header.put("billType", billType.getKey());
        header.put("beParserOssUrl", task.getUrl());
        this.messageSenderUtils.sendMsgWithConfig(eventType, JSON.toJSONString((Object)task), header);
    }
}

