/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.core.resolve.executor;

import com.google.common.collect.Maps;
import com.xforceplus.core.enums.IntConstant;
import com.xforceplus.core.resolve.executor.MonitorExecutorService;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.springframework.stereotype.Component;

@Component
public class ExecutorTaskService {
    private ScheduledExecutorService scheduledExecutorService = new ScheduledThreadPoolExecutor(IntConstant.TWO, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("ExecutorTaskService-schedule-pool-%d").daemon(true).build());
    private ExecutorService executorService = MonitorExecutorService.newFixedThreadPool(IntConstant.FIVE_HUNDRED, "task-pool");
    private Map<String, Future> futureMap = Maps.newConcurrentMap();

    public void debounce(String key, Runnable runnable, Long delay, TimeUnit timeUnit) {
        Future future = this.futureMap.get(key);
        if (future != null) {
            if (!future.isCancelled()) {
                future.cancel(true);
            }
            this.futureMap.remove(key);
        }
        ScheduledFuture<?> scheduledFuture = this.scheduledExecutorService.schedule(runnable, (long)delay, timeUnit);
        this.futureMap.put(key, scheduledFuture);
    }

    public void run(Runnable runnable) {
        this.executorService.submit(runnable);
    }
}

