/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.lock.redisson;

import com.google.common.base.Preconditions;
import com.xforceplus.lock.constant.RedisConnectionType;
import com.xforceplus.lock.redisson.config.RedissonProperties;
import com.xforceplus.lock.redisson.strategy.RedissonConfigContext;
import com.xforceplus.lock.redisson.strategy.impl.ClusterRedissonConfigStrategyImpl;
import com.xforceplus.lock.redisson.strategy.impl.MasterslaveRedissonConfigStrategyImpl;
import com.xforceplus.lock.redisson.strategy.impl.SentinelRedissonConfigStrategyImpl;
import com.xforceplus.lock.redisson.strategy.impl.StandaloneRedissonConfigStrategyImpl;
import org.redisson.Redisson;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(Redisson.class);
    private Config config = new Config();
    private Redisson redisson = null;

    public RedissonManager() {
    }

    public RedissonManager(RedissonProperties redissonProperties) {
        try {
            this.config = RedissonConfigFactory.getInstance().createConfig(redissonProperties);
            this.redisson = (Redisson)Redisson.create((Config)this.config);
        }
        catch (Exception var3) {
            LOGGER.error("Redisson init error", (Throwable)var3);
            throw new IllegalArgumentException("please input correct configurations,connectionType must in standalone/sentinel/cluster/masterslave");
        }
    }

    public Redisson getRedisson() {
        return this.redisson;
    }

    static class RedissonConfigFactory {
        private static volatile RedissonConfigFactory factory = null;
        private Config config = new Config();

        private RedissonConfigFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static RedissonConfigFactory getInstance() {
            if (factory != null) return factory;
            Class<Object> var0 = Object.class;
            Class<Object> clazz = Object.class;
            synchronized (Object.class) {
                if (factory != null) return factory;
                factory = new RedissonConfigFactory();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return factory;
            }
        }

        Config createConfig(RedissonProperties redissonProperties) {
            Preconditions.checkNotNull((Object)redissonProperties);
            Preconditions.checkNotNull((Object)redissonProperties.getAddress(), (Object)"redisson.lock.server.address cannot be NULL!");
            Preconditions.checkNotNull((Object)redissonProperties.getType(), (Object)"redisson.lock.server.password cannot be NULL");
            Preconditions.checkNotNull((Object)redissonProperties.getDatabase(), (Object)"redisson.lock.server.database cannot be NULL");
            String connectionType = redissonProperties.getType();
            RedissonConfigContext redissonConfigContext = null;
            if (connectionType.equals(RedisConnectionType.STANDALONE.getConnection_type())) {
                redissonConfigContext = new RedissonConfigContext(new StandaloneRedissonConfigStrategyImpl());
            } else if (connectionType.equals(RedisConnectionType.SENTINEL.getConnection_type())) {
                redissonConfigContext = new RedissonConfigContext(new SentinelRedissonConfigStrategyImpl());
            } else if (connectionType.equals(RedisConnectionType.CLUSTER.getConnection_type())) {
                redissonConfigContext = new RedissonConfigContext(new ClusterRedissonConfigStrategyImpl());
            } else {
                if (!connectionType.equals(RedisConnectionType.MASTERSLAVE.getConnection_type())) {
                    throw new IllegalArgumentException("\u521b\u5efaRedisson\u8fde\u63a5Config\u5931\u8d25\uff01\u5f53\u524d\u8fde\u63a5\u65b9\u5f0f:" + connectionType);
                }
                redissonConfigContext = new RedissonConfigContext(new MasterslaveRedissonConfigStrategyImpl());
            }
            return redissonConfigContext.createRedissonConfig(redissonProperties);
        }
    }
}

