/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.google.common.collect.Lists;
import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class StringLib
extends StringUtils {
    public static final String UTF_8 = "UTF-8";
    public static final String GBK = "GBK";
    public static final String SPLIT_1 = "_";
    public static final String SPLIT_2 = ":";
    public static final String SPLIT_3 = ",";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private static final String CHAR1 = "+";
    private static final String ChAR1_ENCODE = "%20";

    public static String decodeURI(String str) {
        if (StringLib.isBlank((CharSequence)str)) {
            return "";
        }
        try {
            str = URLDecoder.decode(str, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return str;
    }

    public static boolean equalsAny(String key, String ... values) {
        if (ArrayUtils.isNotEmpty((Object[])values)) {
            for (String str : values) {
                if (!StringLib.equals((CharSequence)key, (CharSequence)str)) continue;
                return true;
            }
        }
        return false;
    }

    public static String encodeURI(String part) {
        try {
            return URLEncoder.encode(part, UTF_8).replace(CHAR1, ChAR1_ENCODE);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String toString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public static String abbr(String str, int length) {
        if (str == null) {
            return "";
        }
        try {
            StringBuilder sb = new StringBuilder();
            int currentLength = 0;
            for (char c : str.toCharArray()) {
                if ((currentLength += StringLib.toString(Character.valueOf(c)).getBytes(GBK).length) > length - 3) {
                    sb.append("...");
                    break;
                }
                sb.append(c);
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static Double toDouble(Object val) {
        if (val == null) {
            return 0.0;
        }
        try {
            return Double.valueOf(StringLib.trim((String)val.toString()));
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static Float toFloat(Object val) {
        return Float.valueOf(StringLib.toDouble(val).floatValue());
    }

    public static Long toLong(Object val) {
        return StringLib.toDouble(val).longValue();
    }

    public static Integer toInteger(Object val) {
        return StringLib.toLong(val).intValue();
    }

    public static Short toShort(Object val) {
        return (short)StringLib.toShort(val);
    }

    public static String toBinaryString(long value, int length) {
        String binString = Long.toBinaryString(value);
        StringBuffer b = new StringBuffer(binString);
        while (b.length() < length) {
            b.insert(0, '0');
        }
        return b.toString();
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public static List<String> getMACAddresses() {
        ArrayList addresses = Lists.newArrayList();
        try {
            Enumeration<NetworkInterface> networkInterfaceEnum = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaceEnum.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaceEnum.nextElement();
                if (networkInterface.isLoopback() || networkInterface.isPointToPoint() || networkInterface.isVirtual()) continue;
                ArrayList list = Lists.newArrayList();
                byte[] macAddress = networkInterface.getHardwareAddress();
                if (macAddress != null) {
                    for (int i = 0; i < macAddress.length; ++i) {
                        String s = Integer.toHexString(macAddress[i] & 0xFF);
                        list.add(s.length() == 1 ? 0 + s : s);
                    }
                }
                if (list.size() <= 0) continue;
                addresses.add(StringLib.join((Iterable)list, (String)"-"));
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return addresses;
    }

    public static List<String> getIPAddresses() {
        ArrayList addresses = Lists.newArrayList();
        try {
            Enumeration<NetworkInterface> networkInterfaceEnum = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaceEnum.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaceEnum.nextElement();
                if (networkInterface.isLoopback() || !networkInterface.isUp()) continue;
                Enumeration<InetAddress> ips = networkInterface.getInetAddresses();
                while (ips.hasMoreElements()) {
                    InetAddress addr = ips.nextElement();
                    if (!(addr instanceof Inet4Address) || !StringLib.isNotEmpty((CharSequence)addr.getHostAddress())) continue;
                    addresses.add(addr.getHostAddress());
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return addresses;
    }

    public static String toEncodeStringWithAutoCharset(byte[] in) {
        String value = null;
        if (in != null) {
            try {
                CharsetDetector detector = new CharsetDetector();
                detector.setText(in);
                CharsetMatch match = detector.detect();
                String encoding = GBK;
                if (match.getConfidence() > 85) {
                    encoding = match.getName();
                }
                value = StringLib.toEncodedString((byte[])in, (Charset)Charset.forName(encoding));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }
}

