/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.core.config;

import com.xxl.job.core.executor.impl.XxlJobSpringExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class XxlJobConfig {
    private Logger logger = LoggerFactory.getLogger(XxlJobConfig.class);
    @Value(value="${xxl.job.admin.addresses}")
    private String adminAddresses;
    @Value(value="${xxl.job.executor.appname}")
    private String appName;
    @Value(value="${xxl.job.executor.ip:}")
    private String ip;
    @Value(value="${xxl.job.executor.port:3204}")
    private int port;
    @Value(value="${xxl.job.accessToken:default_token}")
    private String accessToken;
    @Value(value="${xxl.job.executor.logpath:/data/applogs/xforceplus-job/jobhandler}")
    private String logPath;
    @Value(value="${xxl.job.executor.logretentiondays:-1}")
    private int logRetentionDays;
    @Value(value="${spring.profiles.active}")
    private String env;

    @Bean(initMethod="start", destroyMethod="destroy")
    public XxlJobSpringExecutor xxlJobExecutor() {
        this.logger.info("eccp-dcs-job config init! workspace:{}", (Object)this.env);
        XxlJobSpringExecutor xxlJobSpringExecutor = new XxlJobSpringExecutor();
        xxlJobSpringExecutor.setAdminAddresses(this.adminAddresses);
        xxlJobSpringExecutor.setAppName(this.appName);
        xxlJobSpringExecutor.setIp(this.ip);
        xxlJobSpringExecutor.setPort(this.port);
        xxlJobSpringExecutor.setAccessToken(this.accessToken);
        xxlJobSpringExecutor.setLogPath(this.logPath);
        xxlJobSpringExecutor.setLogRetentionDays(this.logRetentionDays);
        return xxlJobSpringExecutor;
    }

    public String getAdminAddresses() {
        return this.adminAddresses;
    }
}

