/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.core.resolve;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.xforceplus.core.enums.BillsTypeEnum;
import com.xforceplus.core.resolve.DocumentResolverPost;
import com.xforceplus.core.resolve.ResolveTask;
import java.util.Random;

public class DocumentResolverPostImpl
implements DocumentResolverPost {
    private Random random = new Random(System.currentTimeMillis());

    @Override
    public String handle(String result, ResolveTask task) {
        String batchNo = "edcs-" + System.currentTimeMillis() + (this.random.nextInt(899) + 100);
        Object obj = JSON.parse((String)result);
        if (obj instanceof JSONObject) {
            this.addInfo((JSONObject)obj, task, batchNo);
        } else if (obj instanceof JSONArray) {
            JSONArray arr = (JSONArray)obj;
            for (int i = 0; i < arr.size(); ++i) {
                this.addInfo(arr.getJSONObject(i), task, batchNo);
            }
        }
        return JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    private void addInfo(JSONObject object, ResolveTask task, String batchNo) {
        object.put("collectionAccount", (Object)task.getAccountName());
        BillsTypeEnum billType = task.getJobBillType().getBillType();
        if ((BillsTypeEnum.POS.equals(billType) || BillsTypeEnum.IR.equals(billType)) && !object.containsKey((Object)"collectionBatch")) {
            object.put("collectionBatch", (Object)batchNo);
        }
        object.put("purchaseRetailerId", (Object)task.getRetailKey());
        object.put("purchaseRetailerName", (Object)task.getRetailName());
        object.put("originalFileUrl", (Object)task.getUrl());
    }
}

