/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.core.resolve.excel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.xforceplus.core.resolve.AbstractFileTypeImportBean;
import com.xforceplus.core.resolve.ResolveTask;
import com.xforceplus.core.resolve.excel.DataSourceExcelReadListener;
import com.xforceplus.core.resolve.excel.convert.ExcelCustomerStringConverter;
import com.xforceplus.utils.CSVReadUtils;
import com.xforceplus.utils.ExcelUtil;
import com.xforceplus.utils.JsonLib;
import com.xforceplus.utils.StringLib;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class ExcelImportBean
extends AbstractFileTypeImportBean {
    public static void main(String[] args) {
        try {
            File file = new File("/Users/gongjianfeng/Downloads/edi-sit/pepsicocostcopo-VEN1001782-VEN1001782-1759978814202.xls");
            FileInputStream fileInput = new FileInputStream(file);
            ExcelImportBean e = new ExcelImportBean();
            e.handle1(fileInput, new ResolveTask());
            System.out.println(e);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle1(InputStream inputStream, ResolveTask dataSource) {
        ExcelReader excelReader = null;
        try {
            DataSourceExcelReadListener excelListener = new DataSourceExcelReadListener();
            excelReader = ((ExcelReaderBuilder)((ExcelReaderBuilder)EasyExcel.read((InputStream)inputStream, (ReadListener)excelListener).registerConverter((Converter)new ExcelCustomerStringConverter())).headRowNumber(Integer.valueOf(0))).build();
            HashMap excelDataMap = Maps.newHashMap();
            List sheetList = excelReader.excelExecutor().sheetList();
            for (int sheetIdx = 0; sheetIdx < sheetList.size(); ++sheetIdx) {
                ReadSheet readSheet = (ReadSheet)sheetList.get(sheetIdx);
                excelReader.read(new ReadSheet[]{readSheet});
                List<JSONObject> data = this.dataTableToList(excelListener.getTableData());
                String key = StringLib.join((Object[])new Serializable[]{"data", Integer.valueOf(sheetIdx + 1)});
                excelDataMap.put(key, data);
                excelListener.reset();
            }
            System.out.println(JsonLib.toJSON(excelDataMap).toString());
            this.addData("sheetData", excelDataMap);
        }
        catch (Exception e) {
            this.useCSV(inputStream, dataSource);
        }
        finally {
            if (excelReader != null) {
                excelReader.finish();
            }
        }
    }

    private void useCSV(InputStream inputStream, ResolveTask dataSource) {
        try {
            String charset = dataSource.getCharset();
            if (StringLib.isEmpty((CharSequence)charset)) {
                charset = "GBK";
            }
            String inputStr = IOUtils.toString((InputStream)inputStream, (String)charset);
            Table<Integer, Integer, String> table = CSVReadUtils.read(inputStr, 0, "\r\n\t\t", '\t');
            List<JSONObject> data = this.dataTableToList(table);
            this.addData("data1", data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private List<JSONObject> dataTableToList(Table<Integer, Integer, String> dataTable) {
        ArrayList list = Lists.newArrayList();
        Set rowIdxSet = dataTable.rowKeySet();
        for (Integer rowIdx : rowIdxSet) {
            JSONObject document = new JSONObject();
            document.put("row_index", (Object)(rowIdx + 1));
            Map rowData = dataTable.row((Object)rowIdx);
            for (Map.Entry rowDataEntry : rowData.entrySet()) {
                String colName = ExcelUtil.getExcelColKeyByIndex((Integer)rowDataEntry.getKey());
                document.put(colName, rowDataEntry.getValue());
            }
            list.add(document);
        }
        return list;
    }
}

