/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.account;

import com.google.common.base.Splitter;
import com.xforceplus.account.domain.AccountTemplateDO;
import com.xforceplus.captcha.CaptchaUtil;
import com.xforceplus.core.exception.SliderFailException;
import com.xforceplus.utils.selenium.ChromeDriverProxy;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.File;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class TuringCaptchaSolver {
    private ChromeDriverProxy driver;
    private WebDriverWait wait;
    private Actions actions;
    private AccountTemplateDO account;

    public TuringCaptchaSolver(ChromeDriverProxy driver, AccountTemplateDO account) {
        this.driver = driver;
        this.account = account;
        this.wait = new WebDriverWait((WebDriver)driver, Duration.ofSeconds(15L));
        this.actions = new Actions((WebDriver)driver);
    }

    public static String encodePngToBase64(String filePath) throws Exception {
        byte[] fileContent = Files.readAllBytes(Paths.get(filePath, new String[0]));
        return Base64.getEncoder().encodeToString(fileContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void solveTencentCaptcha() throws Exception {
        try {
            this.driver.switchTo().frame("tcaptcha_iframe_dy");
            this.wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)"tcWrap")));
            XxlJobLogger.log((String)"\u9a8c\u8bc1\u7801\u5f39\u7a97\u5df2\u52a0\u8f7d", (Object[])new Object[0]);
            WebElement slideBg = (WebElement)this.wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)"slideBg")));
            this.wait.until(driver -> {
                String bgImage = slideBg.getCssValue("background-image");
                return bgImage != null && !bgImage.equals("none") && !bgImage.contains("base64");
            });
            XxlJobLogger.log((String)"\u9a8c\u8bc1\u7801\u56fe\u7247\u5df2\u52a0\u8f7d\u5b8c\u6210", (Object[])new Object[0]);
            String bgImageUrl = this.extractBackgroundImageUrl(slideBg);
            String bgPath = this.downloadImage(bgImageUrl, this.account.getAccountName() + "background.png");
            String point = CaptchaUtil.captchaPlus(TuringCaptchaSolver.encodePngToBase64(bgPath), "9901", this.account.getAccountId(), "chaojiying");
            XxlJobLogger.log((String)("\u8fd4\u56de\u5750\u6807\uff1a" + point), (Object[])new Object[0]);
            List ps = Splitter.on((String)",").splitToList((CharSequence)point);
            int slideDistance = new BigDecimal((String)ps.get(0)).intValue() / 3 + 10;
            if (slideDistance >= 190) {
                slideDistance += 30;
            } else if (slideDistance > 150) {
                slideDistance += 20;
            } else if (slideDistance <= 120) {
                slideDistance -= 10;
            }
            XxlJobLogger.log((String)("\u8ba1\u7b97\u51fa\u7684\u6ed1\u52a8\u8ddd\u79bb: " + slideDistance + "px"), (Object[])new Object[0]);
            WebElement slider = (WebElement)this.wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.cssSelector((String)".tc-slider-normal")));
            this.slideTheBlock(slider, slideDistance);
            boolean sliderFlag = this.checkVerificationResult();
            if (!sliderFlag) {
                throw new SliderFailException("\u6ed1\u5757\u9a8c\u8bc1\u5931\u8d25");
            }
        }
        finally {
            this.driver.switchTo().defaultContent();
        }
    }

    private String extractBackgroundImageUrl(WebElement slideBg) {
        String bgImageStyle = slideBg.getCssValue("background-image");
        return bgImageStyle.replace("url(\"", "").replace("\")", "");
    }

    private String downloadImage(String imageUrl, String fileName) throws Exception {
        URL url = new URL(imageUrl);
        String filePath = System.getProperty("java.io.tmpdir") + File.separator + fileName;
        Files.copy(url.openStream(), Paths.get(filePath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        XxlJobLogger.log((String)("\u56fe\u7247\u5df2\u4e0b\u8f7d: " + filePath), (Object[])new Object[0]);
        return filePath;
    }

    private void slideTheBlock(WebElement slider, int distance) {
        try {
            int currentPos;
            int move;
            this.actions.clickAndHold(slider).perform();
            Thread.sleep(200L);
            int target = distance;
            int fastDistance = (int)((double)target * 0.7);
            for (currentPos = 0; currentPos < fastDistance; currentPos += move) {
                move = 5 + (int)(Math.random() * 5.0);
                this.actions.moveByOffset(move, 0).perform();
                Thread.sleep(10 + (int)(Math.random() * 10.0));
            }
            while (currentPos < target) {
                move = 1 + (int)(Math.random() * 3.0);
                if (currentPos + move > target) {
                    move = target - currentPos;
                }
                this.actions.moveByOffset(move, 0).perform();
                currentPos += move;
                Thread.sleep(20 + (int)(Math.random() * 20.0));
            }
            Thread.sleep(100L);
            this.actions.moveByOffset(2, 0).perform();
            Thread.sleep(50L);
            this.actions.moveByOffset(-1, 0).perform();
            this.actions.release().perform();
            XxlJobLogger.log((String)"\u6ed1\u5757\u62d6\u52a8\u5b8c\u6210", (Object[])new Object[0]);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private boolean checkVerificationResult() {
        try {
            WebElement successElement = (WebElement)this.wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.cssSelector((String)".tc-success")));
            XxlJobLogger.log((String)"\u9a8c\u8bc1\u6210\u529f\uff01", (Object[])new Object[0]);
            return true;
        }
        catch (Exception e) {
            XxlJobLogger.log((String)"\u9a8c\u8bc1\u53ef\u80fd\u5931\u8d25\uff0c\u5c1d\u8bd5\u91cd\u65b0\u9a8c\u8bc1", (Object[])new Object[0]);
            return false;
        }
    }
}

